package software.amazon.awscdk.services.robomaker;

/**
 * Properties for defining a `AWS::RoboMaker::SimulationApplicationVersion`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:26:24.028Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnSimulationApplicationVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.Application`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-application
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApplication();

    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.CurrentRevisionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-currentrevisionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCurrentRevisionId();

    /**
     * @return a {@link Builder} of {@link CfnSimulationApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSimulationApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String application;
        private java.lang.String currentRevisionId;

        /**
         * Sets the value of Application
         * @param application `AWS::RoboMaker::SimulationApplicationVersion.Application`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder application(java.lang.String application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of CurrentRevisionId
         * @param currentRevisionId `AWS::RoboMaker::SimulationApplicationVersion.CurrentRevisionId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder currentRevisionId(java.lang.String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSimulationApplicationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnSimulationApplicationVersionProps build() {
            return new Jsii$Proxy(application, currentRevisionId);
        }
    }

    /**
     * An implementation for {@link CfnSimulationApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSimulationApplicationVersionProps {
        private final java.lang.String application;
        private final java.lang.String currentRevisionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.application = this.jsiiGet("application", java.lang.String.class);
            this.currentRevisionId = this.jsiiGet("currentRevisionId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String application, java.lang.String currentRevisionId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.application = java.util.Objects.requireNonNull(application, "application is required");
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        public java.lang.String getApplication() {
            return this.application;
        }

        @Override
        public java.lang.String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("application", om.valueToTree(this.getApplication()));
            if (this.getCurrentRevisionId() != null) {
                obj.set("currentRevisionId", om.valueToTree(this.getCurrentRevisionId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSimulationApplicationVersionProps.Jsii$Proxy that = (CfnSimulationApplicationVersionProps.Jsii$Proxy) o;

            if (!application.equals(that.application)) return false;
            return this.currentRevisionId != null ? this.currentRevisionId.equals(that.currentRevisionId) : that.currentRevisionId == null;
        }

        @Override
        public int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + (this.currentRevisionId != null ? this.currentRevisionId.hashCode() : 0);
            return result;
        }
    }
}
