/**
 * <h1>AWS RoboMaker Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.robomaker.*;
 * </pre></blockquote>
 * <p>
 * <!--BEGIN CFNONLY DISCLAIMER-->
 * <p>
 * There are no official hand-written (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">L2</a>) constructs for this service yet. Here are some suggestions on how to proceed:
 * <p>
 * <ul>
 * <li>Search <a href="https://constructs.dev/search?q=robomaker">Construct Hub for RoboMaker construct libraries</a></li>
 * <li>Use the automatically generated <a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using">L1</a> constructs, in the same way you would use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_RoboMaker.html">the CloudFormation AWS::RoboMaker resources</a> directly.</li>
 * </ul>
 * <p>
 * (Read the <a href="https://github.com/aws/aws-cdk/blob/master/CONTRIBUTING.md">CDK Contributing Guide</a> if you are interested in contributing to this construct library.)
 * <p>
 * <!--END CFNONLY DISCLAIMER-->
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.robomaker;
