package software.amazon.awscdk.services.robomaker;

/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 * <p>
 * The <code>AWS::RoboMaker::SimulationApplication</code> resource creates an AWS RoboMaker simulation application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.robomaker.*;
 * CfnSimulationApplication cfnSimulationApplication = CfnSimulationApplication.Builder.create(this, "MyCfnSimulationApplication")
 *         .robotSoftwareSuite(RobotSoftwareSuiteProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .simulationSoftwareSuite(SimulationSoftwareSuiteProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         // the properties below are optional
 *         .currentRevisionId("currentRevisionId")
 *         .environment("environment")
 *         .name("name")
 *         .renderingEngine(RenderingEngineProperty.builder()
 *                 .name("name")
 *                 .version("version")
 *                 .build())
 *         .sources(List.of(SourceConfigProperty.builder()
 *                 .architecture("architecture")
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:30:46.251Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication")
public class CfnSimulationApplication extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSimulationApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSimulationApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.robomaker.CfnSimulationApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RoboMaker::SimulationApplication`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSimulationApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.robomaker.CfnSimulationApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current revision id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCurrentRevisionId() {
        return software.amazon.jsii.Kernel.get(this, "attrCurrentRevisionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A map that contains tag keys and tag values that are attached to the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The robot software suite used by the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRobotSoftwareSuite() {
        return software.amazon.jsii.Kernel.get(this, "robotSoftwareSuite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The robot software suite used by the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRobotSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "robotSoftwareSuite", java.util.Objects.requireNonNull(value, "robotSoftwareSuite is required"));
    }

    /**
     * The robot software suite used by the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRobotSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty value) {
        software.amazon.jsii.Kernel.set(this, "robotSoftwareSuite", java.util.Objects.requireNonNull(value, "robotSoftwareSuite is required"));
    }

    /**
     * The simulation software suite used by the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSimulationSoftwareSuite() {
        return software.amazon.jsii.Kernel.get(this, "simulationSoftwareSuite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The simulation software suite used by the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSimulationSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "simulationSoftwareSuite", java.util.Objects.requireNonNull(value, "simulationSoftwareSuite is required"));
    }

    /**
     * The simulation software suite used by the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSimulationSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty value) {
        software.amazon.jsii.Kernel.set(this, "simulationSoftwareSuite", java.util.Objects.requireNonNull(value, "simulationSoftwareSuite is required"));
    }

    /**
     * The current revision id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCurrentRevisionId() {
        return software.amazon.jsii.Kernel.get(this, "currentRevisionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current revision id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCurrentRevisionId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "currentRevisionId", value);
    }

    /**
     * The environment of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The environment of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     * The name of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The rendering engine for the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRenderingEngine() {
        return software.amazon.jsii.Kernel.get(this, "renderingEngine", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The rendering engine for the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRenderingEngine(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "renderingEngine", value);
    }

    /**
     * The rendering engine for the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRenderingEngine(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RenderingEngineProperty value) {
        software.amazon.jsii.Kernel.set(this, "renderingEngine", value);
    }

    /**
     * The sources of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSources() {
        return software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The sources of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sources", value);
    }

    /**
     * The sources of the simulation application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SourceConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SourceConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "sources", value);
    }
    /**
     * Information about a rendering engine.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.robomaker.*;
     * RenderingEngineProperty renderingEngineProperty = RenderingEngineProperty.builder()
     *         .name("name")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.RenderingEngineProperty")
    @software.amazon.jsii.Jsii.Proxy(RenderingEngineProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenderingEngineProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the rendering engine.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The version of the rendering engine.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenderingEngineProperty> {
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link RenderingEngineProperty#getName}
             * @param name The name of the rendering engine. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RenderingEngineProperty#getVersion}
             * @param version The version of the rendering engine. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenderingEngineProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenderingEngineProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenderingEngineProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.RenderingEngineProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenderingEngineProperty.Jsii$Proxy that = (RenderingEngineProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about a robot software suite.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.robomaker.*;
     * RobotSoftwareSuiteProperty robotSoftwareSuiteProperty = RobotSoftwareSuiteProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty")
    @software.amazon.jsii.Jsii.Proxy(RobotSoftwareSuiteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RobotSoftwareSuiteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the robot software suite.
         * <p>
         * <code>General</code> is the only supported value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The version of the robot software suite.
         * <p>
         * Not applicable for General software suite.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RobotSoftwareSuiteProperty> {
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link RobotSoftwareSuiteProperty#getName}
             * @param name The name of the robot software suite. This parameter is required.
             *             <code>General</code> is the only supported value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RobotSoftwareSuiteProperty#getVersion}
             * @param version The version of the robot software suite.
             *                Not applicable for General software suite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RobotSoftwareSuiteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RobotSoftwareSuiteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RobotSoftwareSuiteProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RobotSoftwareSuiteProperty.Jsii$Proxy that = (RobotSoftwareSuiteProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a simulation software suite.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.robomaker.*;
     * SimulationSoftwareSuiteProperty simulationSoftwareSuiteProperty = SimulationSoftwareSuiteProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty")
    @software.amazon.jsii.Jsii.Proxy(SimulationSoftwareSuiteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SimulationSoftwareSuiteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the simulation software suite.
         * <p>
         * <code>SimulationRuntime</code> is the only supported value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The version of the simulation software suite.
         * <p>
         * Not applicable for <code>SimulationRuntime</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SimulationSoftwareSuiteProperty> {
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link SimulationSoftwareSuiteProperty#getName}
             * @param name The name of the simulation software suite. This parameter is required.
             *             <code>SimulationRuntime</code> is the only supported value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SimulationSoftwareSuiteProperty#getVersion}
             * @param version The version of the simulation software suite.
             *                Not applicable for <code>SimulationRuntime</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimulationSoftwareSuiteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SimulationSoftwareSuiteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimulationSoftwareSuiteProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimulationSoftwareSuiteProperty.Jsii$Proxy that = (SimulationSoftwareSuiteProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a source configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.robomaker.*;
     * SourceConfigProperty sourceConfigProperty = SourceConfigProperty.builder()
     *         .architecture("architecture")
     *         .s3Bucket("s3Bucket")
     *         .s3Key("s3Key")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.SourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target processor architecture for the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArchitecture();

        /**
         * The Amazon S3 bucket name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * The s3 object key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConfigProperty> {
            java.lang.String architecture;
            java.lang.String s3Bucket;
            java.lang.String s3Key;

            /**
             * Sets the value of {@link SourceConfigProperty#getArchitecture}
             * @param architecture The target processor architecture for the application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder architecture(java.lang.String architecture) {
                this.architecture = architecture;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigProperty#getS3Bucket}
             * @param s3Bucket The Amazon S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigProperty#getS3Key}
             * @param s3Key The s3 object key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigProperty {
            private final java.lang.String architecture;
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.architecture = software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Key = software.amazon.jsii.Kernel.get(this, "s3Key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.architecture = java.util.Objects.requireNonNull(builder.architecture, "architecture is required");
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.s3Key = java.util.Objects.requireNonNull(builder.s3Key, "s3Key is required");
            }

            @Override
            public final java.lang.String getArchitecture() {
                return this.architecture;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("architecture", om.valueToTree(this.getArchitecture()));
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                data.set("s3Key", om.valueToTree(this.getS3Key()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.SourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigProperty.Jsii$Proxy that = (SourceConfigProperty.Jsii$Proxy) o;

                if (!architecture.equals(that.architecture)) return false;
                if (!s3Bucket.equals(that.s3Bucket)) return false;
                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public final int hashCode() {
                int result = this.architecture.hashCode();
                result = 31 * result + (this.s3Bucket.hashCode());
                result = 31 * result + (this.s3Key.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.robomaker.CfnSimulationApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.robomaker.CfnSimulationApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.robomaker.CfnSimulationApplicationProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.robomaker.CfnSimulationApplicationProps.Builder();
        }

        /**
         * The robot software suite used by the simulation application.
         * <p>
         * @return {@code this}
         * @param robotSoftwareSuite The robot software suite used by the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder robotSoftwareSuite(final software.amazon.awscdk.core.IResolvable robotSoftwareSuite) {
            this.props.robotSoftwareSuite(robotSoftwareSuite);
            return this;
        }
        /**
         * The robot software suite used by the simulation application.
         * <p>
         * @return {@code this}
         * @param robotSoftwareSuite The robot software suite used by the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder robotSoftwareSuite(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty robotSoftwareSuite) {
            this.props.robotSoftwareSuite(robotSoftwareSuite);
            return this;
        }

        /**
         * The simulation software suite used by the simulation application.
         * <p>
         * @return {@code this}
         * @param simulationSoftwareSuite The simulation software suite used by the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simulationSoftwareSuite(final software.amazon.awscdk.core.IResolvable simulationSoftwareSuite) {
            this.props.simulationSoftwareSuite(simulationSoftwareSuite);
            return this;
        }
        /**
         * The simulation software suite used by the simulation application.
         * <p>
         * @return {@code this}
         * @param simulationSoftwareSuite The simulation software suite used by the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simulationSoftwareSuite(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty simulationSoftwareSuite) {
            this.props.simulationSoftwareSuite(simulationSoftwareSuite);
            return this;
        }

        /**
         * The current revision id.
         * <p>
         * @return {@code this}
         * @param currentRevisionId The current revision id. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentRevisionId(final java.lang.String currentRevisionId) {
            this.props.currentRevisionId(currentRevisionId);
            return this;
        }

        /**
         * The environment of the simulation application.
         * <p>
         * @return {@code this}
         * @param environment The environment of the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.lang.String environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The name of the simulation application.
         * <p>
         * @return {@code this}
         * @param name The name of the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The rendering engine for the simulation application.
         * <p>
         * @return {@code this}
         * @param renderingEngine The rendering engine for the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingEngine(final software.amazon.awscdk.core.IResolvable renderingEngine) {
            this.props.renderingEngine(renderingEngine);
            return this;
        }
        /**
         * The rendering engine for the simulation application.
         * <p>
         * @return {@code this}
         * @param renderingEngine The rendering engine for the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingEngine(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RenderingEngineProperty renderingEngine) {
            this.props.renderingEngine(renderingEngine);
            return this;
        }

        /**
         * The sources of the simulation application.
         * <p>
         * @return {@code this}
         * @param sources The sources of the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(final software.amazon.awscdk.core.IResolvable sources) {
            this.props.sources(sources);
            return this;
        }
        /**
         * The sources of the simulation application.
         * <p>
         * @return {@code this}
         * @param sources The sources of the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(final java.util.List<? extends java.lang.Object> sources) {
            this.props.sources(sources);
            return this;
        }

        /**
         * A map that contains tag keys and tag values that are attached to the simulation application.
         * <p>
         * @return {@code this}
         * @param tags A map that contains tag keys and tag values that are attached to the simulation application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.robomaker.CfnSimulationApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.robomaker.CfnSimulationApplication build() {
            return new software.amazon.awscdk.services.robomaker.CfnSimulationApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
