package software.amazon.awscdk.services.robomaker;

/**
 * Properties for defining a `CfnRobotApplication`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.robomaker.*;
 * CfnRobotApplicationProps cfnRobotApplicationProps = CfnRobotApplicationProps.builder()
 *         .robotSoftwareSuite(RobotSoftwareSuiteProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         // the properties below are optional
 *         .currentRevisionId("currentRevisionId")
 *         .environment("environment")
 *         .name("name")
 *         .sources(List.of(SourceConfigProperty.builder()
 *                 .architecture("architecture")
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T20:01:35.139Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnRobotApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnRobotApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRobotApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The robot software suite used by the robot application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRobotSoftwareSuite();

    /**
     * The current revision id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCurrentRevisionId() {
        return null;
    }

    /**
     * The environment of the robot application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironment() {
        return null;
    }

    /**
     * The name of the robot application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The sources of the robot application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSources() {
        return null;
    }

    /**
     * A map that contains tag keys and tag values that are attached to the robot application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRobotApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRobotApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRobotApplicationProps> {
        java.lang.Object robotSoftwareSuite;
        java.lang.String currentRevisionId;
        java.lang.String environment;
        java.lang.String name;
        java.lang.Object sources;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getRobotSoftwareSuite}
         * @param robotSoftwareSuite The robot software suite used by the robot application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder robotSoftwareSuite(software.amazon.awscdk.services.robomaker.CfnRobotApplication.RobotSoftwareSuiteProperty robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getRobotSoftwareSuite}
         * @param robotSoftwareSuite The robot software suite used by the robot application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder robotSoftwareSuite(software.amazon.awscdk.core.IResolvable robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getCurrentRevisionId}
         * @param currentRevisionId The current revision id.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentRevisionId(java.lang.String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getEnvironment}
         * @param environment The environment of the robot application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.lang.String environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getName}
         * @param name The name of the robot application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getSources}
         * @param sources The sources of the robot application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(software.amazon.awscdk.core.IResolvable sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getSources}
         * @param sources The sources of the robot application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(java.util.List<? extends java.lang.Object> sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotApplicationProps#getTags}
         * @param tags A map that contains tag keys and tag values that are attached to the robot application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRobotApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRobotApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRobotApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRobotApplicationProps {
        private final java.lang.Object robotSoftwareSuite;
        private final java.lang.String currentRevisionId;
        private final java.lang.String environment;
        private final java.lang.String name;
        private final java.lang.Object sources;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.robotSoftwareSuite = software.amazon.jsii.Kernel.get(this, "robotSoftwareSuite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.currentRevisionId = software.amazon.jsii.Kernel.get(this, "currentRevisionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.robotSoftwareSuite = java.util.Objects.requireNonNull(builder.robotSoftwareSuite, "robotSoftwareSuite is required");
            this.currentRevisionId = builder.currentRevisionId;
            this.environment = builder.environment;
            this.name = builder.name;
            this.sources = builder.sources;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getRobotSoftwareSuite() {
            return this.robotSoftwareSuite;
        }

        @Override
        public final java.lang.String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        @Override
        public final java.lang.String getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSources() {
            return this.sources;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("robotSoftwareSuite", om.valueToTree(this.getRobotSoftwareSuite()));
            if (this.getCurrentRevisionId() != null) {
                data.set("currentRevisionId", om.valueToTree(this.getCurrentRevisionId()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getSources() != null) {
                data.set("sources", om.valueToTree(this.getSources()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnRobotApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRobotApplicationProps.Jsii$Proxy that = (CfnRobotApplicationProps.Jsii$Proxy) o;

            if (!robotSoftwareSuite.equals(that.robotSoftwareSuite)) return false;
            if (this.currentRevisionId != null ? !this.currentRevisionId.equals(that.currentRevisionId) : that.currentRevisionId != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.robotSoftwareSuite.hashCode();
            result = 31 * result + (this.currentRevisionId != null ? this.currentRevisionId.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.sources != null ? this.sources.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
