package software.amazon.awscdk.services.robomaker;

/**
 * Properties for defining a `CfnRobot`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.robomaker.*;
 * CfnRobotProps cfnRobotProps = CfnRobotProps.builder()
 *         .architecture("architecture")
 *         .greengrassGroupId("greengrassGroupId")
 *         // the properties below are optional
 *         .fleet("fleet")
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-21T19:24:01.971Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnRobotProps")
@software.amazon.jsii.Jsii.Proxy(CfnRobotProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRobotProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The architecture of the robot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArchitecture();

    /**
     * The Greengrass group associated with the robot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGreengrassGroupId();

    /**
     * The Amazon Resource Name (ARN) of the fleet to which the robot will be registered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFleet() {
        return null;
    }

    /**
     * The name of the robot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A map that contains tag keys and tag values that are attached to the robot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRobotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRobotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRobotProps> {
        java.lang.String architecture;
        java.lang.String greengrassGroupId;
        java.lang.String fleet;
        java.lang.String name;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnRobotProps#getArchitecture}
         * @param architecture The architecture of the robot. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(java.lang.String architecture) {
            this.architecture = architecture;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotProps#getGreengrassGroupId}
         * @param greengrassGroupId The Greengrass group associated with the robot. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder greengrassGroupId(java.lang.String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotProps#getFleet}
         * @param fleet The Amazon Resource Name (ARN) of the fleet to which the robot will be registered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleet(java.lang.String fleet) {
            this.fleet = fleet;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotProps#getName}
         * @param name The name of the robot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRobotProps#getTags}
         * @param tags A map that contains tag keys and tag values that are attached to the robot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRobotProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRobotProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRobotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRobotProps {
        private final java.lang.String architecture;
        private final java.lang.String greengrassGroupId;
        private final java.lang.String fleet;
        private final java.lang.String name;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.architecture = software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.greengrassGroupId = software.amazon.jsii.Kernel.get(this, "greengrassGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fleet = software.amazon.jsii.Kernel.get(this, "fleet", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.architecture = java.util.Objects.requireNonNull(builder.architecture, "architecture is required");
            this.greengrassGroupId = java.util.Objects.requireNonNull(builder.greengrassGroupId, "greengrassGroupId is required");
            this.fleet = builder.fleet;
            this.name = builder.name;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final java.lang.String getGreengrassGroupId() {
            return this.greengrassGroupId;
        }

        @Override
        public final java.lang.String getFleet() {
            return this.fleet;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("architecture", om.valueToTree(this.getArchitecture()));
            data.set("greengrassGroupId", om.valueToTree(this.getGreengrassGroupId()));
            if (this.getFleet() != null) {
                data.set("fleet", om.valueToTree(this.getFleet()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnRobotProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRobotProps.Jsii$Proxy that = (CfnRobotProps.Jsii$Proxy) o;

            if (!architecture.equals(that.architecture)) return false;
            if (!greengrassGroupId.equals(that.greengrassGroupId)) return false;
            if (this.fleet != null ? !this.fleet.equals(that.fleet) : that.fleet != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.architecture.hashCode();
            result = 31 * result + (this.greengrassGroupId.hashCode());
            result = 31 * result + (this.fleet != null ? this.fleet.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
