package software.amazon.awscdk.services.robomaker;

/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:10.264Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication")
public class CfnSimulationApplication extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSimulationApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSimulationApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.robomaker.CfnSimulationApplication.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::RoboMaker::SimulationApplication`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnSimulationApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.robomaker.CfnSimulationApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCurrentRevisionId() {
        return this.jsiiGet("attrCurrentRevisionId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRenderingEngine() {
        return this.jsiiGet("renderingEngine", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRenderingEngine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("renderingEngine", java.util.Objects.requireNonNull(value, "renderingEngine is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRenderingEngine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RenderingEngineProperty value) {
        this.jsiiSet("renderingEngine", java.util.Objects.requireNonNull(value, "renderingEngine is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRobotSoftwareSuite() {
        return this.jsiiGet("robotSoftwareSuite", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRobotSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("robotSoftwareSuite", java.util.Objects.requireNonNull(value, "robotSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRobotSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty value) {
        this.jsiiSet("robotSoftwareSuite", java.util.Objects.requireNonNull(value, "robotSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSimulationSoftwareSuite() {
        return this.jsiiGet("simulationSoftwareSuite", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSimulationSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("simulationSoftwareSuite", java.util.Objects.requireNonNull(value, "simulationSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSimulationSoftwareSuite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty value) {
        this.jsiiSet("simulationSoftwareSuite", java.util.Objects.requireNonNull(value, "simulationSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSources() {
        return this.jsiiGet("sources", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sources", java.util.Objects.requireNonNull(value, "sources is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSources(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        this.jsiiSet("sources", java.util.Objects.requireNonNull(value, "sources is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getCurrentRevisionId() {
        return this.jsiiGet("currentRevisionId", java.lang.String.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCurrentRevisionId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("currentRevisionId", value);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("name", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.RenderingEngineProperty")
    @software.amazon.jsii.Jsii.Proxy(RenderingEngineProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RenderingEngineProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Version`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String version;

            /**
             * Sets the value of {@link RenderingEngineProperty#getName}
             * @param name `CfnSimulationApplication.RenderingEngineProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RenderingEngineProperty#getVersion}
             * @param version `CfnSimulationApplication.RenderingEngineProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenderingEngineProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RenderingEngineProperty build() {
                return new Jsii$Proxy(name, version);
            }
        }

        /**
         * An implementation for {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenderingEngineProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.RenderingEngineProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenderingEngineProperty.Jsii$Proxy that = (RenderingEngineProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty")
    @software.amazon.jsii.Jsii.Proxy(RobotSoftwareSuiteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RobotSoftwareSuiteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Version`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String version;

            /**
             * Sets the value of {@link RobotSoftwareSuiteProperty#getName}
             * @param name `CfnSimulationApplication.RobotSoftwareSuiteProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RobotSoftwareSuiteProperty#getVersion}
             * @param version `CfnSimulationApplication.RobotSoftwareSuiteProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RobotSoftwareSuiteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RobotSoftwareSuiteProperty build() {
                return new Jsii$Proxy(name, version);
            }
        }

        /**
         * An implementation for {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RobotSoftwareSuiteProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RobotSoftwareSuiteProperty.Jsii$Proxy that = (RobotSoftwareSuiteProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty")
    @software.amazon.jsii.Jsii.Proxy(SimulationSoftwareSuiteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SimulationSoftwareSuiteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Version`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String version;

            /**
             * Sets the value of {@link SimulationSoftwareSuiteProperty#getName}
             * @param name `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SimulationSoftwareSuiteProperty#getVersion}
             * @param version `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimulationSoftwareSuiteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SimulationSoftwareSuiteProperty build() {
                return new Jsii$Proxy(name, version);
            }
        }

        /**
         * An implementation for {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimulationSoftwareSuiteProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimulationSoftwareSuiteProperty.Jsii$Proxy that = (SimulationSoftwareSuiteProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication.SourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.SourceConfigProperty.Architecture`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-architecture
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getArchitecture();

        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Bucket`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Key`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String architecture;
            private java.lang.String s3Bucket;
            private java.lang.String s3Key;

            /**
             * Sets the value of {@link SourceConfigProperty#getArchitecture}
             * @param architecture `CfnSimulationApplication.SourceConfigProperty.Architecture`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder architecture(java.lang.String architecture) {
                this.architecture = architecture;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigProperty#getS3Bucket}
             * @param s3Bucket `CfnSimulationApplication.SourceConfigProperty.S3Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigProperty#getS3Key}
             * @param s3Key `CfnSimulationApplication.SourceConfigProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SourceConfigProperty build() {
                return new Jsii$Proxy(architecture, s3Bucket, s3Key);
            }
        }

        /**
         * An implementation for {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigProperty {
            private final java.lang.String architecture;
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.architecture = this.jsiiGet("architecture", java.lang.String.class);
                this.s3Bucket = this.jsiiGet("s3Bucket", java.lang.String.class);
                this.s3Key = this.jsiiGet("s3Key", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String architecture, final java.lang.String s3Bucket, final java.lang.String s3Key) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.architecture = java.util.Objects.requireNonNull(architecture, "architecture is required");
                this.s3Bucket = java.util.Objects.requireNonNull(s3Bucket, "s3Bucket is required");
                this.s3Key = java.util.Objects.requireNonNull(s3Key, "s3Key is required");
            }

            @Override
            public java.lang.String getArchitecture() {
                return this.architecture;
            }

            @Override
            public java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("architecture", om.valueToTree(this.getArchitecture()));
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                data.set("s3Key", om.valueToTree(this.getS3Key()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-robomaker.CfnSimulationApplication.SourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigProperty.Jsii$Proxy that = (SourceConfigProperty.Jsii$Proxy) o;

                if (!architecture.equals(that.architecture)) return false;
                if (!s3Bucket.equals(that.s3Bucket)) return false;
                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public int hashCode() {
                int result = this.architecture.hashCode();
                result = 31 * result + (this.s3Bucket.hashCode());
                result = 31 * result + (this.s3Key.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.robomaker.CfnSimulationApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.robomaker.CfnSimulationApplicationProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.robomaker.CfnSimulationApplicationProps.Builder();
        }

        /**
         * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
         * @param renderingEngine `AWS::RoboMaker::SimulationApplication.RenderingEngine`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder renderingEngine(final software.amazon.awscdk.core.IResolvable renderingEngine) {
            this.props.renderingEngine(renderingEngine);
            return this;
        }
        /**
         * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
         * @param renderingEngine `AWS::RoboMaker::SimulationApplication.RenderingEngine`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder renderingEngine(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RenderingEngineProperty renderingEngine) {
            this.props.renderingEngine(renderingEngine);
            return this;
        }

        /**
         * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
         * @param robotSoftwareSuite `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder robotSoftwareSuite(final software.amazon.awscdk.core.IResolvable robotSoftwareSuite) {
            this.props.robotSoftwareSuite(robotSoftwareSuite);
            return this;
        }
        /**
         * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
         * @param robotSoftwareSuite `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder robotSoftwareSuite(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty robotSoftwareSuite) {
            this.props.robotSoftwareSuite(robotSoftwareSuite);
            return this;
        }

        /**
         * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
         * @param simulationSoftwareSuite `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder simulationSoftwareSuite(final software.amazon.awscdk.core.IResolvable simulationSoftwareSuite) {
            this.props.simulationSoftwareSuite(simulationSoftwareSuite);
            return this;
        }
        /**
         * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
         * @param simulationSoftwareSuite `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder simulationSoftwareSuite(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty simulationSoftwareSuite) {
            this.props.simulationSoftwareSuite(simulationSoftwareSuite);
            return this;
        }

        /**
         * `AWS::RoboMaker::SimulationApplication.Sources`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
         * @param sources `AWS::RoboMaker::SimulationApplication.Sources`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sources(final software.amazon.awscdk.core.IResolvable sources) {
            this.props.sources(sources);
            return this;
        }
        /**
         * `AWS::RoboMaker::SimulationApplication.Sources`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
         * @param sources `AWS::RoboMaker::SimulationApplication.Sources`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sources(final java.util.List<java.lang.Object> sources) {
            this.props.sources(sources);
            return this;
        }

        /**
         * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
         * @param currentRevisionId `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder currentRevisionId(final java.lang.String currentRevisionId) {
            this.props.currentRevisionId(currentRevisionId);
            return this;
        }

        /**
         * `AWS::RoboMaker::SimulationApplication.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
         * @param name `AWS::RoboMaker::SimulationApplication.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::RoboMaker::SimulationApplication.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
         * @param tags `AWS::RoboMaker::SimulationApplication.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.robomaker.CfnSimulationApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.robomaker.CfnSimulationApplication build() {
            return new software.amazon.awscdk.services.robomaker.CfnSimulationApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
