package software.amazon.awscdk.services.robomaker;

/**
 * Properties for defining a `AWS::RoboMaker::RobotApplicationVersion`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:25:03.320Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnRobotApplicationVersionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.Application`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-application
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApplication();

    /**
     * `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-currentrevisionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCurrentRevisionId();

    /**
     * @return a {@link Builder} of {@link CfnRobotApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnRobotApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String application;
        private java.lang.String currentRevisionId;

        /**
         * Sets the value of Application
         * @param application `AWS::RoboMaker::RobotApplicationVersion.Application`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder application(java.lang.String application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of CurrentRevisionId
         * @param currentRevisionId `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder currentRevisionId(java.lang.String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRobotApplicationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnRobotApplicationVersionProps build() {
            return new Jsii$Proxy(application, currentRevisionId);
        }

    }

    /**
     * An implementation for {@link CfnRobotApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRobotApplicationVersionProps {
        private final java.lang.String application;
        private final java.lang.String currentRevisionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.application = this.jsiiGet("application", java.lang.String.class);
            this.currentRevisionId = this.jsiiGet("currentRevisionId", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String application, java.lang.String currentRevisionId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.application = java.util.Objects.requireNonNull(application, "application is required");
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        public java.lang.String getApplication() {
            return this.application;
        }

        @Override
        public java.lang.String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("application", om.valueToTree(this.getApplication()));
            if (this.getCurrentRevisionId() != null) {
                obj.set("currentRevisionId", om.valueToTree(this.getCurrentRevisionId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRobotApplicationVersionProps.Jsii$Proxy that = (CfnRobotApplicationVersionProps.Jsii$Proxy) o;

            if (!application.equals(that.application)) return false;
            return this.currentRevisionId != null ? this.currentRevisionId.equals(that.currentRevisionId) : that.currentRevisionId == null;
        }

        @Override
        public int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + (this.currentRevisionId != null ? this.currentRevisionId.hashCode() : 0);
            return result;
        }

    }
}
