package software.amazon.awscdk.services.route53;

/**
 * Construction properties for a ARecord.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigateway.*;
 * HostedZone zone;
 * LambdaRestApi restApi;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new ApiGateway(restApi)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:56.363Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.ARecordProps")
@software.amazon.jsii.Jsii.Proxy(ARecordProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ARecordProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.route53.RecordSetOptions {

    /**
     * The target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.RecordTarget getTarget();

    /**
     * @return a {@link Builder} of {@link ARecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ARecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ARecordProps> {
        software.amazon.awscdk.services.route53.RecordTarget target;
        software.amazon.awscdk.services.route53.IHostedZone zone;
        java.lang.String comment;
        java.lang.String recordName;
        software.amazon.awscdk.core.Duration ttl;

        /**
         * Sets the value of {@link ARecordProps#getTarget}
         * @param target The target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.route53.RecordTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link ARecordProps#getZone}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.zone = zone;
            return this;
        }

        /**
         * Sets the value of {@link ARecordProps#getComment}
         * @param comment A comment to add on the record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link ARecordProps#getRecordName}
         * @param recordName The domain name for this record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(java.lang.String recordName) {
            this.recordName = recordName;
            return this;
        }

        /**
         * Sets the value of {@link ARecordProps#getTtl}
         * @param ttl The resource record cache time to live (TTL).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(software.amazon.awscdk.core.Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ARecordProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ARecordProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ARecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ARecordProps {
        private final software.amazon.awscdk.services.route53.RecordTarget target;
        private final software.amazon.awscdk.services.route53.IHostedZone zone;
        private final java.lang.String comment;
        private final java.lang.String recordName;
        private final software.amazon.awscdk.core.Duration ttl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.RecordTarget.class));
            this.zone = software.amazon.jsii.Kernel.get(this, "zone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordName = software.amazon.jsii.Kernel.get(this, "recordName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.zone = java.util.Objects.requireNonNull(builder.zone, "zone is required");
            this.comment = builder.comment;
            this.recordName = builder.recordName;
            this.ttl = builder.ttl;
        }

        @Override
        public final software.amazon.awscdk.services.route53.RecordTarget getTarget() {
            return this.target;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getZone() {
            return this.zone;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getRecordName() {
            return this.recordName;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTtl() {
            return this.ttl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("target", om.valueToTree(this.getTarget()));
            data.set("zone", om.valueToTree(this.getZone()));
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getRecordName() != null) {
                data.set("recordName", om.valueToTree(this.getRecordName()));
            }
            if (this.getTtl() != null) {
                data.set("ttl", om.valueToTree(this.getTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.ARecordProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ARecordProps.Jsii$Proxy that = (ARecordProps.Jsii$Proxy) o;

            if (!target.equals(that.target)) return false;
            if (!zone.equals(that.zone)) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.recordName != null ? !this.recordName.equals(that.recordName) : that.recordName != null) return false;
            return this.ttl != null ? this.ttl.equals(that.ttl) : that.ttl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + (this.zone.hashCode());
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.recordName != null ? this.recordName.hashCode() : 0);
            result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
            return result;
        }
    }
}
