package software.amazon.awscdk.services.route53;

/**
 * Properties for defining a `CfnRecordSetGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CfnRecordSetGroupProps cfnRecordSetGroupProps = CfnRecordSetGroupProps.builder()
 *         .comment("comment")
 *         .hostedZoneId("hostedZoneId")
 *         .hostedZoneName("hostedZoneName")
 *         .recordSets(List.of(RecordSetProperty.builder()
 *                 .name("name")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .aliasTarget(AliasTargetProperty.builder()
 *                         .dnsName("dnsName")
 *                         .hostedZoneId("hostedZoneId")
 *                         // the properties below are optional
 *                         .evaluateTargetHealth(false)
 *                         .build())
 *                 .cidrRoutingConfig(CidrRoutingConfigProperty.builder()
 *                         .collectionId("collectionId")
 *                         .locationName("locationName")
 *                         .build())
 *                 .failover("failover")
 *                 .geoLocation(GeoLocationProperty.builder()
 *                         .continentCode("continentCode")
 *                         .countryCode("countryCode")
 *                         .subdivisionCode("subdivisionCode")
 *                         .build())
 *                 .healthCheckId("healthCheckId")
 *                 .hostedZoneId("hostedZoneId")
 *                 .hostedZoneName("hostedZoneName")
 *                 .multiValueAnswer(false)
 *                 .region("region")
 *                 .resourceRecords(List.of("resourceRecords"))
 *                 .setIdentifier("setIdentifier")
 *                 .ttl("ttl")
 *                 .weight(123)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:56.468Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CfnRecordSetGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnRecordSetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRecordSetGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * *Optional:* Any comments you want to include about a change batch request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * The ID of the hosted zone that you want to create records in.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
        return null;
    }

    /**
     * The name of the hosted zone that you want to create records in.
     * <p>
     * You must include a trailing dot (for example, <code>www.example.com.</code> ) as part of the <code>HostedZoneName</code> .
     * <p>
     * When you create a stack using an <code>AWS::Route53::RecordSet</code> that specifies <code>HostedZoneName</code> , AWS CloudFormation attempts to find a hosted zone whose name matches the <code>HostedZoneName</code> . If AWS CloudFormation can't find a hosted zone with a matching domain name, or if there is more than one hosted zone with the specified domain name, AWS CloudFormation will not create the stack.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneName() {
        return null;
    }

    /**
     * A complex type that contains one `RecordSet` element for each record that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecordSets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRecordSetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRecordSetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRecordSetGroupProps> {
        java.lang.String comment;
        java.lang.String hostedZoneId;
        java.lang.String hostedZoneName;
        java.lang.Object recordSets;

        /**
         * Sets the value of {@link CfnRecordSetGroupProps#getComment}
         * @param comment *Optional:* Any comments you want to include about a change batch request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetGroupProps#getHostedZoneId}
         * @param hostedZoneId The ID of the hosted zone that you want to create records in.
         *                     Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(java.lang.String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetGroupProps#getHostedZoneName}
         * @param hostedZoneName The name of the hosted zone that you want to create records in.
         *                       You must include a trailing dot (for example, <code>www.example.com.</code> ) as part of the <code>HostedZoneName</code> .
         *                       <p>
         *                       When you create a stack using an <code>AWS::Route53::RecordSet</code> that specifies <code>HostedZoneName</code> , AWS CloudFormation attempts to find a hosted zone whose name matches the <code>HostedZoneName</code> . If AWS CloudFormation can't find a hosted zone with a matching domain name, or if there is more than one hosted zone with the specified domain name, AWS CloudFormation will not create the stack.
         *                       <p>
         *                       Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneName(java.lang.String hostedZoneName) {
            this.hostedZoneName = hostedZoneName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetGroupProps#getRecordSets}
         * @param recordSets A complex type that contains one `RecordSet` element for each record that you want to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordSets(software.amazon.awscdk.core.IResolvable recordSets) {
            this.recordSets = recordSets;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordSetGroupProps#getRecordSets}
         * @param recordSets A complex type that contains one `RecordSet` element for each record that you want to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordSets(java.util.List<? extends java.lang.Object> recordSets) {
            this.recordSets = recordSets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRecordSetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRecordSetGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRecordSetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRecordSetGroupProps {
        private final java.lang.String comment;
        private final java.lang.String hostedZoneId;
        private final java.lang.String hostedZoneName;
        private final java.lang.Object recordSets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostedZoneName = software.amazon.jsii.Kernel.get(this, "hostedZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordSets = software.amazon.jsii.Kernel.get(this, "recordSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.hostedZoneId = builder.hostedZoneId;
            this.hostedZoneName = builder.hostedZoneName;
            this.recordSets = builder.recordSets;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final java.lang.String getHostedZoneName() {
            return this.hostedZoneName;
        }

        @Override
        public final java.lang.Object getRecordSets() {
            return this.recordSets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHostedZoneId() != null) {
                data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
            }
            if (this.getHostedZoneName() != null) {
                data.set("hostedZoneName", om.valueToTree(this.getHostedZoneName()));
            }
            if (this.getRecordSets() != null) {
                data.set("recordSets", om.valueToTree(this.getRecordSets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CfnRecordSetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRecordSetGroupProps.Jsii$Proxy that = (CfnRecordSetGroupProps.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.hostedZoneId != null ? !this.hostedZoneId.equals(that.hostedZoneId) : that.hostedZoneId != null) return false;
            if (this.hostedZoneName != null ? !this.hostedZoneName.equals(that.hostedZoneName) : that.hostedZoneName != null) return false;
            return this.recordSets != null ? this.recordSets.equals(that.recordSets) : that.recordSets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.hostedZoneId != null ? this.hostedZoneId.hashCode() : 0);
            result = 31 * result + (this.hostedZoneName != null ? this.hostedZoneName.hashCode() : 0);
            result = 31 * result + (this.recordSets != null ? this.recordSets.hashCode() : 0);
            return result;
        }
    }
}
