package software.amazon.awscdk.services.route53;

/**
 * Create a Route53 private hosted zone for use in one or more VPCs.
 * <p>
 * Note that <code>enableDnsHostnames</code> and <code>enableDnsSupport</code> must have been enabled
 * for the VPC you're configuring for private hosted zones.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * PrivateHostedZone zone = PrivateHostedZone.Builder.create(this, "HostedZone")
 *         .zoneName("fully.qualified.domain.com")
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:56.495Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.PrivateHostedZone")
public class PrivateHostedZone extends software.amazon.awscdk.services.route53.HostedZone implements software.amazon.awscdk.services.route53.IPrivateHostedZone {

    protected PrivateHostedZone(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PrivateHostedZone(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PrivateHostedZone(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.PrivateHostedZoneProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a Route 53 private hosted zone defined either outside the CDK, or in a different CDK stack.
     * <p>
     * @param scope the parent Construct for this Construct. This parameter is required.
     * @param id the logical name of this Construct. This parameter is required.
     * @param privateHostedZoneId the ID of the private hosted zone to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IPrivateHostedZone fromPrivateHostedZoneId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String privateHostedZoneId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.PrivateHostedZone.class, "fromPrivateHostedZoneId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IPrivateHostedZone.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(privateHostedZoneId, "privateHostedZoneId is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.PrivateHostedZone}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.PrivateHostedZone> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.PrivateHostedZoneProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.PrivateHostedZoneProps.Builder();
        }

        /**
         * The name of the domain.
         * <p>
         * For resource record types that include a domain
         * name, specify a fully qualified domain name.
         * <p>
         * @return {@code this}
         * @param zoneName The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(final java.lang.String zoneName) {
            this.props.zoneName(zoneName);
            return this;
        }

        /**
         * Any comments that you want to include about the hosted zone.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param comment Any comments that you want to include about the hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
         * <p>
         * Default: disabled
         * <p>
         * @return {@code this}
         * @param queryLogsLogGroupArn The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogsLogGroupArn(final java.lang.String queryLogsLogGroupArn) {
            this.props.queryLogsLogGroupArn(queryLogsLogGroupArn);
            return this;
        }

        /**
         * A VPC that you want to associate with this hosted zone.
         * <p>
         * Private hosted zones must be associated with at least one VPC. You can
         * associated additional VPCs using <code>addVpc(vpc)</code>.
         * <p>
         * @return {@code this}
         * @param vpc A VPC that you want to associate with this hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.PrivateHostedZone}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.PrivateHostedZone build() {
            return new software.amazon.awscdk.services.route53.PrivateHostedZone(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
