package software.amazon.awscdk.services.route53recoverycontrol;

/**
 * Properties for defining a `CfnRoutingControl`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53recoverycontrol.*;
 * CfnRoutingControlProps cfnRoutingControlProps = CfnRoutingControlProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .clusterArn("clusterArn")
 *         .controlPanelArn("controlPanelArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:37.876Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53recoverycontrol.$Module.class, fqn = "@aws-cdk/aws-route53recoverycontrol.CfnRoutingControlProps")
@software.amazon.jsii.Jsii.Proxy(CfnRoutingControlProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRoutingControlProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the routing control.
     * <p>
     * You can use any non-white space character in the name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the cluster that includes the routing control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterArn() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the control panel that includes the routing control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getControlPanelArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRoutingControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRoutingControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRoutingControlProps> {
        java.lang.String name;
        java.lang.String clusterArn;
        java.lang.String controlPanelArn;

        /**
         * Sets the value of {@link CfnRoutingControlProps#getName}
         * @param name The name of the routing control. This parameter is required.
         *             You can use any non-white space character in the name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingControlProps#getClusterArn}
         * @param clusterArn The Amazon Resource Name (ARN) of the cluster that includes the routing control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterArn(java.lang.String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRoutingControlProps#getControlPanelArn}
         * @param controlPanelArn The Amazon Resource Name (ARN) of the control panel that includes the routing control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder controlPanelArn(java.lang.String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRoutingControlProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRoutingControlProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRoutingControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRoutingControlProps {
        private final java.lang.String name;
        private final java.lang.String clusterArn;
        private final java.lang.String controlPanelArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.controlPanelArn = software.amazon.jsii.Kernel.get(this, "controlPanelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.clusterArn = builder.clusterArn;
            this.controlPanelArn = builder.controlPanelArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final java.lang.String getControlPanelArn() {
            return this.controlPanelArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getClusterArn() != null) {
                data.set("clusterArn", om.valueToTree(this.getClusterArn()));
            }
            if (this.getControlPanelArn() != null) {
                data.set("controlPanelArn", om.valueToTree(this.getControlPanelArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53recoverycontrol.CfnRoutingControlProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRoutingControlProps.Jsii$Proxy that = (CfnRoutingControlProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.clusterArn != null ? !this.clusterArn.equals(that.clusterArn) : that.clusterArn != null) return false;
            return this.controlPanelArn != null ? this.controlPanelArn.equals(that.controlPanelArn) : that.controlPanelArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.clusterArn != null ? this.clusterArn.hashCode() : 0);
            result = 31 * result + (this.controlPanelArn != null ? this.controlPanelArn.hashCode() : 0);
            return result;
        }
    }
}
