package software.amazon.awscdk.services.s3.notifications;

/**
 * Represents the properties of a notification destination.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:00:35.555Z")
public interface BucketNotificationDestinationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the destination (i.e. Lambda, SNS, SQS).
     */
    java.lang.String getArn();
    /**
     * The notification type.
     */
    software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType getType();
    /**
     * Any additional dependencies that should be resolved before the bucket notification
     * can be configured (for example, the SNS Topic Policy resource).
     */
    java.util.List<software.amazon.awscdk.IDependable> getDependencies();

    /**
     * @return a {@link Builder} of {@link BucketNotificationDestinationProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketNotificationDestinationProps}
     */
    final class Builder {
        private java.lang.String _arn;
        private software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType _type;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.IDependable> _dependencies;

        /**
         * Sets the value of Arn
         * @param value The ARN of the destination (i.e. Lambda, SNS, SQS).
         * @return {@code this}
         */
        public Builder withArn(final java.lang.String value) {
            this._arn = java.util.Objects.requireNonNull(value, "arn is required");
            return this;
        }
        /**
         * Sets the value of Type
         * @param value The notification type.
         * @return {@code this}
         */
        public Builder withType(final software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType value) {
            this._type = java.util.Objects.requireNonNull(value, "type is required");
            return this;
        }
        /**
         * Sets the value of Dependencies
         * @param value Any additional dependencies that should be resolved before the bucket notification
can be configured (for example, the SNS Topic Policy resource).
         * @return {@code this}
         */
        public Builder withDependencies(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.IDependable> value) {
            this._dependencies = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketNotificationDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketNotificationDestinationProps build() {
            return new BucketNotificationDestinationProps() {
                private final java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                private final software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType $type = java.util.Objects.requireNonNull(_type, "type is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.IDependable> $dependencies = _dependencies;

                @Override
                public java.lang.String getArn() {
                    return this.$arn;
                }

                @Override
                public software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType getType() {
                    return this.$type;
                }

                @Override
                public java.util.List<software.amazon.awscdk.IDependable> getDependencies() {
                    return this.$dependencies;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("arn", om.valueToTree(this.getArn()));
                    obj.set("type", om.valueToTree(this.getType()));
                    obj.set("dependencies", om.valueToTree(this.getDependencies()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the destination (i.e. Lambda, SNS, SQS).
         */
        @Override
        public java.lang.String getArn() {
            return this.jsiiGet("arn", java.lang.String.class);
        }

        /**
         * The notification type.
         */
        @Override
        public software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType getType() {
            return this.jsiiGet("type", software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType.class);
        }

        /**
         * Any additional dependencies that should be resolved before the bucket notification
         * can be configured (for example, the SNS Topic Policy resource).
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.IDependable> getDependencies() {
            return this.jsiiGet("dependencies", java.util.List.class);
        }
    }
}
