package software.amazon.awscdk.services.s3.notifications;

/**
 * Represents the properties of a notification destination.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:51:46.663Z")
public interface BucketNotificationDestinationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the destination (i.e. Lambda, SNS, SQS).
     */
    software.amazon.awscdk.Arn getArn();
    /**
     * The ARN of the destination (i.e. Lambda, SNS, SQS).
     */
    void setArn(final software.amazon.awscdk.Arn value);
    /**
     * The notification type.
     */
    software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType getType();
    /**
     * The notification type.
     */
    void setType(final software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType value);
    /**
     * Any additional dependencies that should be resolved before the bucket notification
     * can be configured (for example, the SNS Topic Policy resource).
     */
    java.util.List<software.amazon.awscdk.IDependable> getDependencies();
    /**
     * Any additional dependencies that should be resolved before the bucket notification
     * can be configured (for example, the SNS Topic Policy resource).
     */
    void setDependencies(final java.util.List<software.amazon.awscdk.IDependable> value);

    /**
     * @return a {@link Builder} of {@link BucketNotificationDestinationProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketNotificationDestinationProps}
     */
    final class Builder {
        private software.amazon.awscdk.Arn _arn;
        private software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType _type;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.IDependable> _dependencies;

        /**
         * Sets the value of Arn
         * @param value The ARN of the destination (i.e. Lambda, SNS, SQS).
         * @return {@code this}
         */
        public Builder withArn(final software.amazon.awscdk.Arn value) {
            this._arn = java.util.Objects.requireNonNull(value, "arn is required");
            return this;
        }
        /**
         * Sets the value of Type
         * @param value The notification type.
         * @return {@code this}
         */
        public Builder withType(final software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType value) {
            this._type = java.util.Objects.requireNonNull(value, "type is required");
            return this;
        }
        /**
         * Sets the value of Dependencies
         * @param value Any additional dependencies that should be resolved before the bucket notification
can be configured (for example, the SNS Topic Policy resource).
         * @return {@code this}
         */
        public Builder withDependencies(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.IDependable> value) {
            this._dependencies = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketNotificationDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketNotificationDestinationProps build() {
            return new BucketNotificationDestinationProps() {
                private software.amazon.awscdk.Arn $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                private software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType $type = java.util.Objects.requireNonNull(_type, "type is required");
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.IDependable> $dependencies = _dependencies;

                @Override
                public software.amazon.awscdk.Arn getArn() {
                    return this.$arn;
                }

                @Override
                public void setArn(final software.amazon.awscdk.Arn value) {
                    this.$arn = java.util.Objects.requireNonNull(value, "arn is required");
                }

                @Override
                public software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType getType() {
                    return this.$type;
                }

                @Override
                public void setType(final software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType value) {
                    this.$type = java.util.Objects.requireNonNull(value, "type is required");
                }

                @Override
                public java.util.List<software.amazon.awscdk.IDependable> getDependencies() {
                    return this.$dependencies;
                }

                @Override
                public void setDependencies(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.IDependable> value) {
                    this.$dependencies = value;
                }

            };
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the destination (i.e. Lambda, SNS, SQS).
         */
        @Override
        public software.amazon.awscdk.Arn getArn() {
            return this.jsiiGet("arn", software.amazon.awscdk.Arn.class);
        }

        /**
         * The ARN of the destination (i.e. Lambda, SNS, SQS).
         */
        @Override
        public void setArn(final software.amazon.awscdk.Arn value) {
            this.jsiiSet("arn", java.util.Objects.requireNonNull(value, "arn is required"));
        }

        /**
         * The notification type.
         */
        @Override
        public software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType getType() {
            return this.jsiiGet("type", software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType.class);
        }

        /**
         * The notification type.
         */
        @Override
        public void setType(final software.amazon.awscdk.services.s3.notifications.BucketNotificationDestinationType value) {
            this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
        }

        /**
         * Any additional dependencies that should be resolved before the bucket notification
         * can be configured (for example, the SNS Topic Policy resource).
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.IDependable> getDependencies() {
            return this.jsiiGet("dependencies", java.util.List.class);
        }

        /**
         * Any additional dependencies that should be resolved before the bucket notification
         * can be configured (for example, the SNS Topic Policy resource).
         */
        @Override
        public void setDependencies(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.IDependable> value) {
            this.jsiiSet("dependencies", value);
        }
    }
}
