/**
 * <h1>S3 Bucket Notifications Destinations</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module includes integration classes for using Topics, Queues or Lambdas
 * as S3 Notification Destinations.
 * <p>
 * <h2>Examples</h2>
 * <p>
 * The following example shows how to send a notification to an SNS
 * topic when an object is created in an S3 bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.s3.notifications.*;
 * 
 * Object bucket = new Bucket(stack, "Bucket");
 * Object topic = new Topic(stack, "Topic");
 * 
 * bucket.addEventNotification(s3.EventType.getOBJECT_CREATED_PUT(), new SnsDestination(topic));
 * </pre></blockquote>
 * <p>
 * The following example shows how to send a notification to a Lambda function when an object is created in an S3 bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.s3.notifications.*;
 * 
 * Object bucket = new Bucket(stack, "Bucket");
 * Function fn = new Function(this, "MyFunction", Map.of(
 *         "runtime", Runtime.getNODEJS_12_X(),
 *         "handler", "index.handler",
 *         "code", Code.fromAsset(path.join(__dirname, "lambda-handler"))));
 * 
 * bucket.addEventNotification(s3.EventType.getOBJECT_CREATED(), new LambdaDestination(fn));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.s3.notifications;
