/**
 * <h2>S3 Bucket Notifications Destinations</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Stable-success.svg?style=for-the-badge" alt="Stability: Stable" /></p>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This module includes integration classes for using Topics, Queues or Lambdas
 * as S3 Notification Destinations.</p>
 * <h2>Example</h2>
 * <p>The following example shows how to send a notification to an SNS
 * topic when an object is created in an S3 bucket:</p>
 * <pre><code class="language-ts">import s3n = require('@aws-cdk/aws-s3-notifications');
 * 
 * const bucket = new s3.Bucket(stack, 'Bucket');
 * const topic = new sns.Topic(stack, 'Topic');
 * 
 * bucket.addEventNotification(s3.EventType.OBJECT_CREATED_PUT, new s3n.SnsDestination(topic));
 * </code></pre>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.s3.notifications;
