package software.amazon.awscdk.services.s3.notifications;

/**
 * Use an SQS queue as a bucket notification destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Queue myQueue;
 * Bucket bucket = new Bucket(this, "MyBucket");
 * bucket.addEventNotification(EventType.OBJECT_REMOVED,
 * new SqsDestination(myQueue), NotificationKeyFilter.builder().prefix("foo/").suffix(".jpg").build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.65.0 (build 7a02b7f)", date = "2022-08-25T20:40:36.836Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.notifications.$Module.class, fqn = "@aws-cdk/aws-s3-notifications.SqsDestination")
public class SqsDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.IBucketNotificationDestination {

    protected SqsDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * Allows using SQS queues as destinations for bucket notifications.
     * <p>
     * Use <code>bucket.onEvent(event, queue)</code> to subscribe.
     * <p>
     * @param _scope This parameter is required.
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.BucketNotificationDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketNotificationDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }
}
