/**
 * <h1>S3 Bucket Notifications Destinations</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module includes integration classes for using Topics, Queues or Lambdas
 * as S3 Notification Destinations.
 * <p>
 * <h2>Examples</h2>
 * <p>
 * The following example shows how to send a notification to an SNS
 * topic when an object is created in an S3 bucket:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sns.*;
 * 
 * 
 * Bucket bucket = new Bucket(this, "Bucket");
 * Topic topic = new Topic(this, "Topic");
 * 
 * bucket.addEventNotification(EventType.OBJECT_CREATED_PUT, new SnsDestination(topic));
 * </pre></blockquote>
 * <p>
 * The following example shows how to send a notification to an SQS queue
 * when an object is created in an S3 bucket:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sqs.*;
 * 
 * 
 * Bucket bucket = new Bucket(this, "Bucket");
 * Queue queue = new Queue(this, "Queue");
 * 
 * bucket.addEventNotification(EventType.OBJECT_CREATED_PUT, new SqsDestination(queue));
 * </pre></blockquote>
 * <p>
 * The following example shows how to send a notification to a Lambda function when an object is created in an S3 bucket:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * 
 * 
 * Bucket bucket = new Bucket(this, "Bucket");
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * 
 * bucket.addEventNotification(EventType.OBJECT_CREATED, new LambdaDestination(fn));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.s3.notifications;
