/**
 * <h2>S3 Bucket Notifications Destinations</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Stable" src="https://img.shields.io/badge/stability-Stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module includes integration classes for using Topics, Queues or Lambdas
 * as S3 Notification Destinations.
 * <p>
 * <h2>Example</h2>
 * <p>
 * The following example shows how to send a notification to an SNS
 * topic when an object is created in an S3 bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.s3.notifications.*;
 * 
 * var bucket = new Bucket(stack, "Bucket");
 * var topic = new Topic(stack, "Topic");
 * 
 * bucket.addEventNotification(s3.EventType.getOBJECT_CREATED_PUT(), new SnsDestination(topic));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.s3.notifications;
