package software.amazon.awscdk.services.s3;

/**
 * An S3 bucket with associated policy objects
 * 
 * This bucket does not yet have all features that exposed by the underlying
 * BucketResource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-27T21:46:56.503Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Bucket")
public class Bucket extends software.amazon.awscdk.services.s3.BucketRef {
    protected Bucket(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Bucket(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    public Bucket(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    /**
     * Add a lifecycle rule to the bucket
     * @param rule The rule to add
     */
    public void addLifecycleRule(final software.amazon.awscdk.services.s3.LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(rule, "rule is required")).toArray());
    }

    /**
     * Adds a bucket notification event destination.
     * @example bucket.onEvent(EventType.OnObjectCreated, myLambda, 'home/myusername/*')
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
     * @param event The event to trigger the notification
     * @param dest The notification destination (Lambda, SNS Topic or SQS Queue)
     * @param filters S3 object key filter rules to determine which objects
trigger this event. Each filter must include a `prefix` and/or `suffix`
that will be matched against the s3 object key. Refer to the S3 Developer Guide
for details about allowed filter rules.
     */
    public void onEvent(final software.amazon.awscdk.services.s3.EventType event, final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onEvent", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(event, "event is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(dest, "dest is required"))), java.util.Arrays.stream(java.util.Objects.requireNonNull(filters, "filters is required"))).toArray());
    }

    /**
     * Subscribes a destination to receive notificatins when an object is
     * created in the bucket. This is identical to calling
     * `onEvent(EventType.ObjectCreated)`.
     * @param dest The notification destination (see onEvent)
     * @param filters Filters (see onEvent)
     */
    public void onObjectCreated(final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onObjectCreated", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(dest, "dest is required")), java.util.Arrays.stream(java.util.Objects.requireNonNull(filters, "filters is required"))).toArray());
    }

    /**
     * Subscribes a destination to receive notificatins when an object is
     * removed from the bucket. This is identical to calling
     * `onEvent(EventType.ObjectRemoved)`.
     * @param dest The notification destination (see onEvent)
     * @param filters Filters (see onEvent)
     */
    public void onObjectRemoved(final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onObjectRemoved", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(dest, "dest is required")), java.util.Arrays.stream(java.util.Objects.requireNonNull(filters, "filters is required"))).toArray());
    }

    /**
     * The ARN of the bucket.
     */
    @Override
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     * The name of the bucket.
     */
    @Override
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    public java.lang.String getDomainName() {
        return this.jsiiGet("domainName", java.lang.String.class);
    }

    public java.lang.String getDualstackDomainName() {
        return this.jsiiGet("dualstackDomainName", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    @Override
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    @Override
    protected void setAutoCreatePolicy(final java.lang.Boolean value) {
        this.jsiiSet("autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    @javax.annotation.Nullable
    protected software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    protected void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
        this.jsiiSet("policy", value);
    }
}
