/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codepipeline.api.CommonActionProps;
import software.amazon.awscdk.services.codepipeline.api.IStage;
import software.amazon.awscdk.services.s3.BucketRef;
import software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineSourceActionProps
extends JsiiSerializable,
CommonPipelineSourceActionProps,
CommonActionProps {
    public BucketRef getBucket();

    public void setBucket(BucketRef var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BucketRef _bucket;
        private String _artifactName;
        private String _bucketKey;
        @Nullable
        private Boolean _pollForSourceChanges;
        private IStage _stage;

        public Builder withBucket(BucketRef value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withArtifactName(String value) {
            this._artifactName = Objects.requireNonNull(value, "artifactName is required");
            return this;
        }

        public Builder withBucketKey(String value) {
            this._bucketKey = Objects.requireNonNull(value, "bucketKey is required");
            return this;
        }

        public Builder withPollForSourceChanges(@Nullable Boolean value) {
            this._pollForSourceChanges = value;
            return this;
        }

        public Builder withStage(IStage value) {
            this._stage = Objects.requireNonNull(value, "stage is required");
            return this;
        }

        public PipelineSourceActionProps build() {
            return new PipelineSourceActionProps(){
                private BucketRef $bucket;
                private String $artifactName;
                private String $bucketKey;
                @Nullable
                private Boolean $pollForSourceChanges;
                private IStage $stage;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$artifactName = Objects.requireNonNull(_artifactName, "artifactName is required");
                    this.$bucketKey = Objects.requireNonNull(_bucketKey, "bucketKey is required");
                    this.$pollForSourceChanges = _pollForSourceChanges;
                    this.$stage = Objects.requireNonNull(_stage, "stage is required");
                }

                @Override
                public BucketRef getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(BucketRef value) {
                    this.$bucket = Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public String getArtifactName() {
                    return this.$artifactName;
                }

                @Override
                public void setArtifactName(String value) {
                    this.$artifactName = Objects.requireNonNull(value, "artifactName is required");
                }

                @Override
                public String getBucketKey() {
                    return this.$bucketKey;
                }

                @Override
                public void setBucketKey(String value) {
                    this.$bucketKey = Objects.requireNonNull(value, "bucketKey is required");
                }

                @Override
                public Boolean getPollForSourceChanges() {
                    return this.$pollForSourceChanges;
                }

                @Override
                public void setPollForSourceChanges(@Nullable Boolean value) {
                    this.$pollForSourceChanges = value;
                }

                public IStage getStage() {
                    return this.$stage;
                }

                public void setStage(IStage value) {
                    this.$stage = Objects.requireNonNull(value, "stage is required");
                }
            };
        }
    }
}

