package software.amazon.awscdk.services.s3;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-19T13:25:56.251Z")
public interface BucketPolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Amazon S3 bucket that the policy applies to.
     */
    software.amazon.awscdk.services.s3.BucketRef getBucket();
    /**
     * The Amazon S3 bucket that the policy applies to.
     */
    void setBucket(final software.amazon.awscdk.services.s3.BucketRef value);

    /**
     * @return a {@link Builder} of {@link BucketPolicyProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketPolicyProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.BucketRef _bucket;

        /**
         * Sets the value of Bucket
         * @param value The Amazon S3 bucket that the policy applies to.
         * @return {@code this}
         */
        public Builder withBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
            this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketPolicyProps build() {
            return new BucketPolicyProps() {
                private software.amazon.awscdk.services.s3.BucketRef $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");

                @Override
                public software.amazon.awscdk.services.s3.BucketRef getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
                    this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketPolicyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon S3 bucket that the policy applies to.
         */
        @Override
        public software.amazon.awscdk.services.s3.BucketRef getBucket() {
            return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.BucketRef.class);
        }

        /**
         * The Amazon S3 bucket that the policy applies to.
         */
        @Override
        public void setBucket(final software.amazon.awscdk.services.s3.BucketRef value) {
            this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
        }
    }
}
