package software.amazon.awscdk.services.s3;

/**
 * A reference to a bucket. The easiest way to instantiate is to call
 * `bucket.export()`. Then, the consumer can use `Bucket.import(this, ref)` and
 * get a `Bucket`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-19T13:25:56.257Z")
public interface BucketRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN fo the bucket. At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    java.lang.String getBucketArn();
    /**
     * The ARN fo the bucket. At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    void setBucketArn(final java.lang.String value);
    /**
     * The domain name of the bucket.
     * @default Inferred from bucket name
     */
    java.lang.String getBucketDomainName();
    /**
     * The domain name of the bucket.
     * @default Inferred from bucket name
     */
    void setBucketDomainName(final java.lang.String value);
    /**
     * The name of the bucket. If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    java.lang.String getBucketName();
    /**
     * The name of the bucket. If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    void setBucketName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link BucketRefProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketRefProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _bucketArn;
        @javax.annotation.Nullable
        private java.lang.String _bucketDomainName;
        @javax.annotation.Nullable
        private java.lang.String _bucketName;

        /**
         * Sets the value of BucketArn
         * @param value The ARN fo the bucket. At least one of bucketArn or bucketName must be
defined in order to initialize a bucket ref.
         * @return {@code this}
         */
        public Builder withBucketArn(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketArn = value;
            return this;
        }
        /**
         * Sets the value of BucketDomainName
         * @param value The domain name of the bucket.
         * @return {@code this}
         */
        public Builder withBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketDomainName = value;
            return this;
        }
        /**
         * Sets the value of BucketName
         * @param value The name of the bucket. If the underlying value of ARN is a string, the
name will be parsed from the ARN. Otherwise, the name is optional, but
some features that require the bucket name such as auto-creating a bucket
policy, won't work.
         * @return {@code this}
         */
        public Builder withBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketRefProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketRefProps build() {
            return new BucketRefProps() {
                @javax.annotation.Nullable
                private java.lang.String $bucketArn = _bucketArn;
                @javax.annotation.Nullable
                private java.lang.String $bucketDomainName = _bucketDomainName;
                @javax.annotation.Nullable
                private java.lang.String $bucketName = _bucketName;

                @Override
                public java.lang.String getBucketArn() {
                    return this.$bucketArn;
                }

                @Override
                public void setBucketArn(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketArn = value;
                }

                @Override
                public java.lang.String getBucketDomainName() {
                    return this.$bucketDomainName;
                }

                @Override
                public void setBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketDomainName = value;
                }

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketName = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN fo the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketArn() {
            return this.jsiiGet("bucketArn", java.lang.String.class);
        }

        /**
         * The ARN fo the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        @Override
        public void setBucketArn(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketArn", value);
        }

        /**
         * The domain name of the bucket.
         * @default Inferred from bucket name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketDomainName() {
            return this.jsiiGet("bucketDomainName", java.lang.String.class);
        }

        /**
         * The domain name of the bucket.
         * @default Inferred from bucket name
         */
        @Override
        public void setBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketDomainName", value);
        }

        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        @Override
        public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketName", value);
        }
    }
}
