package software.amazon.awscdk.services.s3;

/**
 * Describes when an object transitions to a specified storage class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-19T13:25:56.263Z")
public interface Transition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     */
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * The storage class to which you want the object to transition.
     */
    void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value);
    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * @default No transition date.
     */
    java.time.Instant getTransitionDate();
    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * @default No transition date.
     */
    void setTransitionDate(final java.time.Instant value);
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    java.lang.Number getTransitionInDays();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    void setTransitionInDays(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link Transition}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Transition}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.StorageClass _storageClass;
        @javax.annotation.Nullable
        private java.time.Instant _transitionDate;
        @javax.annotation.Nullable
        private java.lang.Number _transitionInDays;

        /**
         * Sets the value of StorageClass
         * @param value The storage class to which you want the object to transition.
         * @return {@code this}
         */
        public Builder withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
            return this;
        }
        /**
         * Sets the value of TransitionDate
         * @param value Indicates when objects are transitioned to the specified storage class.

The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @return {@code this}
         */
        public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
            this._transitionDate = value;
            return this;
        }
        /**
         * Sets the value of TransitionInDays
         * @param value Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        public Builder withTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this._transitionInDays = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Transition}
         * @throws NullPointerException if any required attribute was not provided
         */
        public Transition build() {
            return new Transition() {
                private software.amazon.awscdk.services.s3.StorageClass $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                @javax.annotation.Nullable
                private java.time.Instant $transitionDate = _transitionDate;
                @javax.annotation.Nullable
                private java.lang.Number $transitionInDays = _transitionInDays;

                @Override
                public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
                    this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                }

                @Override
                public java.time.Instant getTransitionDate() {
                    return this.$transitionDate;
                }

                @Override
                public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                    this.$transitionDate = value;
                }

                @Override
                public java.lang.Number getTransitionInDays() {
                    return this.$transitionInDays;
                }

                @Override
                public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$transitionInDays = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.Transition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The storage class to which you want the object to transition.
         */
        @Override
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }

        /**
         * The storage class to which you want the object to transition.
         */
        @Override
        public void setStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
        }

        /**
         * Indicates when objects are transitioned to the specified storage class.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @default No transition date.
         */
        @Override
        @javax.annotation.Nullable
        public java.time.Instant getTransitionDate() {
            return this.jsiiGet("transitionDate", java.time.Instant.class);
        }

        /**
         * Indicates when objects are transitioned to the specified storage class.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @default No transition date.
         */
        @Override
        public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
            this.jsiiSet("transitionDate", value);
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getTransitionInDays() {
            return this.jsiiGet("transitionInDays", java.lang.Number.class);
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        @Override
        public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("transitionInDays", value);
        }
    }
}
