package software.amazon.awscdk.services.s3.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-13T10:26:54.247Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.cloudformation.BucketResource")
public class BucketResource extends software.amazon.awscdk.Resource {
    protected BucketResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.cloudformation.BucketResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::S3::Bucket``.
     * @param parent the ``cdk.Construct`` this ``BucketResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``BucketResource``
     */
    public BucketResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::S3::Bucket``.
     * @param parent the ``cdk.Construct`` this ``BucketResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public BucketResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformation_attribute Arn
     */
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute DomainName
     */
    public java.lang.String getBucketDomainName() {
        return this.jsiiGet("bucketDomainName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute DualStackDomainName
     */
    public java.lang.String getBucketDualStackDomainName() {
        return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
    }

    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute RegionalDomainName
     */
    public java.lang.String getBucketRegionalDomainName() {
        return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute WebsiteURL
     */
    public java.lang.String getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
    }

    public software.amazon.awscdk.services.s3.cloudformation.BucketResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.s3.cloudformation.BucketResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        java.lang.Object getDaysAfterInitiation();
        /**
         * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        void setDaysAfterInitiation(final java.lang.Number value);
        /**
         * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        void setDaysAfterInitiation(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        final class Builder {
            private java.lang.Object _daysAfterInitiation;

            /**
             * Sets the value of DaysAfterInitiation
             * @param value ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @return {@code this}
             */
            public Builder withDaysAfterInitiation(final java.lang.Number value) {
                this._daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }
            /**
             * Sets the value of DaysAfterInitiation
             * @param value ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @return {@code this}
             */
            public Builder withDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                this._daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AbortIncompleteMultipartUploadProperty build() {
                return new AbortIncompleteMultipartUploadProperty() {
                    private java.lang.Object $daysAfterInitiation = java.util.Objects.requireNonNull(_daysAfterInitiation, "daysAfterInitiation is required");

                    @Override
                    public java.lang.Object getDaysAfterInitiation() {
                        return this.$daysAfterInitiation;
                    }

                    @Override
                    public void setDaysAfterInitiation(final java.lang.Number value) {
                        this.$daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }

                    @Override
                    public void setDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                        this.$daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            public java.lang.Object getDaysAfterInitiation() {
                return this.jsiiGet("daysAfterInitiation", java.lang.Object.class);
            }

            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            public void setDaysAfterInitiation(final java.lang.Number value) {
                this.jsiiSet("daysAfterInitiation", java.util.Objects.requireNonNull(value, "daysAfterInitiation is required"));
            }

            /**
             * ``BucketResource.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            public void setDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                this.jsiiSet("daysAfterInitiation", java.util.Objects.requireNonNull(value, "daysAfterInitiation is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        java.lang.Object getAccelerationStatus();
        /**
         * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        void setAccelerationStatus(final java.lang.String value);
        /**
         * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        void setAccelerationStatus(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AccelerateConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccelerateConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _accelerationStatus;

            /**
             * Sets the value of AccelerationStatus
             * @param value ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @return {@code this}
             */
            public Builder withAccelerationStatus(final java.lang.String value) {
                this._accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }
            /**
             * Sets the value of AccelerationStatus
             * @param value ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @return {@code this}
             */
            public Builder withAccelerationStatus(final software.amazon.awscdk.Token value) {
                this._accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccelerateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccelerateConfigurationProperty build() {
                return new AccelerateConfigurationProperty() {
                    private java.lang.Object $accelerationStatus = java.util.Objects.requireNonNull(_accelerationStatus, "accelerationStatus is required");

                    @Override
                    public java.lang.Object getAccelerationStatus() {
                        return this.$accelerationStatus;
                    }

                    @Override
                    public void setAccelerationStatus(final java.lang.String value) {
                        this.$accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                    }

                    @Override
                    public void setAccelerationStatus(final software.amazon.awscdk.Token value) {
                        this.$accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccelerateConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            @Override
            public java.lang.Object getAccelerationStatus() {
                return this.jsiiGet("accelerationStatus", java.lang.Object.class);
            }

            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            @Override
            public void setAccelerationStatus(final java.lang.String value) {
                this.jsiiSet("accelerationStatus", java.util.Objects.requireNonNull(value, "accelerationStatus is required"));
            }

            /**
             * ``BucketResource.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            @Override
            public void setAccelerationStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("accelerationStatus", java.util.Objects.requireNonNull(value, "accelerationStatus is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        java.lang.Object getOwner();
        /**
         * ``BucketResource.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        void setOwner(final java.lang.String value);
        /**
         * ``BucketResource.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        void setOwner(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AccessControlTranslationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccessControlTranslationProperty}
         */
        final class Builder {
            private java.lang.Object _owner;

            /**
             * Sets the value of Owner
             * @param value ``BucketResource.AccessControlTranslationProperty.Owner``
             * @return {@code this}
             */
            public Builder withOwner(final java.lang.String value) {
                this._owner = java.util.Objects.requireNonNull(value, "owner is required");
                return this;
            }
            /**
             * Sets the value of Owner
             * @param value ``BucketResource.AccessControlTranslationProperty.Owner``
             * @return {@code this}
             */
            public Builder withOwner(final software.amazon.awscdk.Token value) {
                this._owner = java.util.Objects.requireNonNull(value, "owner is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlTranslationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccessControlTranslationProperty build() {
                return new AccessControlTranslationProperty() {
                    private java.lang.Object $owner = java.util.Objects.requireNonNull(_owner, "owner is required");

                    @Override
                    public java.lang.Object getOwner() {
                        return this.$owner;
                    }

                    @Override
                    public void setOwner(final java.lang.String value) {
                        this.$owner = java.util.Objects.requireNonNull(value, "owner is required");
                    }

                    @Override
                    public void setOwner(final software.amazon.awscdk.Token value) {
                        this.$owner = java.util.Objects.requireNonNull(value, "owner is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            @Override
            public java.lang.Object getOwner() {
                return this.jsiiGet("owner", java.lang.Object.class);
            }

            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            @Override
            public void setOwner(final java.lang.String value) {
                this.jsiiSet("owner", java.util.Objects.requireNonNull(value, "owner is required"));
            }

            /**
             * ``BucketResource.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            @Override
            public void setOwner(final software.amazon.awscdk.Token value) {
                this.jsiiSet("owner", java.util.Objects.requireNonNull(value, "owner is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        java.lang.Object getStorageClassAnalysis();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        void setStorageClassAnalysis(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _id;
            private java.lang.Object _storageClassAnalysis;
            @javax.annotation.Nullable
            private java.lang.Object _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final software.amazon.awscdk.Token value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @return {@code this}
             */
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @return {@code this}
             */
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AnalyticsConfigurationProperty build() {
                return new AnalyticsConfigurationProperty() {
                    private java.lang.Object $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private java.lang.Object $storageClassAnalysis = java.util.Objects.requireNonNull(_storageClassAnalysis, "storageClassAnalysis is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $prefix = _prefix;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(final java.lang.String value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public void setId(final software.amazon.awscdk.Token value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public java.lang.Object getStorageClassAnalysis() {
                        return this.$storageClassAnalysis;
                    }

                    @Override
                    public void setStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                        this.$storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value) {
                        this.$storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public java.lang.Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$prefix = value;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagFilters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.AnalyticsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            @Override
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            @Override
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            @Override
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            public java.lang.Object getStorageClassAnalysis() {
                return this.jsiiGet("storageClassAnalysis", java.lang.Object.class);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            public void setStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClassAnalysis", java.util.Objects.requireNonNull(value, "storageClassAnalysis is required"));
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            public void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty value) {
                this.jsiiSet("storageClassAnalysis", java.util.Objects.requireNonNull(value, "storageClassAnalysis is required"));
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``BucketResource.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        java.lang.Object getServerSideEncryptionConfiguration();
        /**
         * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        final class Builder {
            private java.lang.Object _serverSideEncryptionConfiguration;

            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BucketEncryptionProperty build() {
                return new BucketEncryptionProperty() {
                    private java.lang.Object $serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(_serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");

                    @Override
                    public java.lang.Object getServerSideEncryptionConfiguration() {
                        return this.$serverSideEncryptionConfiguration;
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                        this.$serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                        this.$serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.BucketEncryptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this.jsiiGet("serverSideEncryptionConfiguration", java.lang.Object.class);
            }

            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            public void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this.jsiiSet("serverSideEncryptionConfiguration", java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required"));
            }

            /**
             * ``BucketResource.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            public void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("serverSideEncryptionConfiguration", java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        java.lang.Object getCorsRules();
        /**
         * ``BucketResource.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        void setCorsRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        void setCorsRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _corsRules;

            /**
             * Sets the value of CorsRules
             * @param value ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @return {@code this}
             */
            public Builder withCorsRules(final software.amazon.awscdk.Token value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }
            /**
             * Sets the value of CorsRules
             * @param value ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @return {@code this}
             */
            public Builder withCorsRules(final java.util.List<java.lang.Object> value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CorsConfigurationProperty build() {
                return new CorsConfigurationProperty() {
                    private java.lang.Object $corsRules = java.util.Objects.requireNonNull(_corsRules, "corsRules is required");

                    @Override
                    public java.lang.Object getCorsRules() {
                        return this.$corsRules;
                    }

                    @Override
                    public void setCorsRules(final software.amazon.awscdk.Token value) {
                        this.$corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                    }

                    @Override
                    public void setCorsRules(final java.util.List<java.lang.Object> value) {
                        this.$corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.CorsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            public java.lang.Object getCorsRules() {
                return this.jsiiGet("corsRules", java.lang.Object.class);
            }

            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            public void setCorsRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("corsRules", java.util.Objects.requireNonNull(value, "corsRules is required"));
            }

            /**
             * ``BucketResource.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            public void setCorsRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("corsRules", java.util.Objects.requireNonNull(value, "corsRules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        java.lang.Object getAllowedMethods();
        /**
         * ``BucketResource.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        void setAllowedMethods(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        void setAllowedMethods(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        java.lang.Object getAllowedOrigins();
        /**
         * ``BucketResource.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        void setAllowedOrigins(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        void setAllowedOrigins(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        java.lang.Object getAllowedHeaders();
        /**
         * ``BucketResource.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        void setAllowedHeaders(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        void setAllowedHeaders(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        java.lang.Object getExposedHeaders();
        /**
         * ``BucketResource.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        void setExposedHeaders(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        void setExposedHeaders(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        java.lang.Object getMaxAge();
        /**
         * ``BucketResource.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        void setMaxAge(final java.lang.Number value);
        /**
         * ``BucketResource.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        void setMaxAge(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsRuleProperty}
         */
        final class Builder {
            private java.lang.Object _allowedMethods;
            private java.lang.Object _allowedOrigins;
            @javax.annotation.Nullable
            private java.lang.Object _allowedHeaders;
            @javax.annotation.Nullable
            private java.lang.Object _exposedHeaders;
            @javax.annotation.Nullable
            private java.lang.Object _id;
            @javax.annotation.Nullable
            private java.lang.Object _maxAge;

            /**
             * Sets the value of AllowedMethods
             * @param value ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @return {@code this}
             */
            public Builder withAllowedMethods(final software.amazon.awscdk.Token value) {
                this._allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }
            /**
             * Sets the value of AllowedMethods
             * @param value ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @return {@code this}
             */
            public Builder withAllowedMethods(final java.util.List<java.lang.Object> value) {
                this._allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }
            /**
             * Sets the value of AllowedOrigins
             * @param value ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @return {@code this}
             */
            public Builder withAllowedOrigins(final software.amazon.awscdk.Token value) {
                this._allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }
            /**
             * Sets the value of AllowedOrigins
             * @param value ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @return {@code this}
             */
            public Builder withAllowedOrigins(final java.util.List<java.lang.Object> value) {
                this._allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }
            /**
             * Sets the value of AllowedHeaders
             * @param value ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @return {@code this}
             */
            public Builder withAllowedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._allowedHeaders = value;
                return this;
            }
            /**
             * Sets the value of AllowedHeaders
             * @param value ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @return {@code this}
             */
            public Builder withAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._allowedHeaders = value;
                return this;
            }
            /**
             * Sets the value of ExposedHeaders
             * @param value ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @return {@code this}
             */
            public Builder withExposedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._exposedHeaders = value;
                return this;
            }
            /**
             * Sets the value of ExposedHeaders
             * @param value ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @return {@code this}
             */
            public Builder withExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._exposedHeaders = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.CorsRuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.CorsRuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of MaxAge
             * @param value ``BucketResource.CorsRuleProperty.MaxAge``
             * @return {@code this}
             */
            public Builder withMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxAge = value;
                return this;
            }
            /**
             * Sets the value of MaxAge
             * @param value ``BucketResource.CorsRuleProperty.MaxAge``
             * @return {@code this}
             */
            public Builder withMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxAge = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CorsRuleProperty build() {
                return new CorsRuleProperty() {
                    private java.lang.Object $allowedMethods = java.util.Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                    private java.lang.Object $allowedOrigins = java.util.Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $allowedHeaders = _allowedHeaders;
                    @javax.annotation.Nullable
                    private java.lang.Object $exposedHeaders = _exposedHeaders;
                    @javax.annotation.Nullable
                    private java.lang.Object $id = _id;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxAge = _maxAge;

                    @Override
                    public java.lang.Object getAllowedMethods() {
                        return this.$allowedMethods;
                    }

                    @Override
                    public void setAllowedMethods(final software.amazon.awscdk.Token value) {
                        this.$allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public void setAllowedMethods(final java.util.List<java.lang.Object> value) {
                        this.$allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public java.lang.Object getAllowedOrigins() {
                        return this.$allowedOrigins;
                    }

                    @Override
                    public void setAllowedOrigins(final software.amazon.awscdk.Token value) {
                        this.$allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public void setAllowedOrigins(final java.util.List<java.lang.Object> value) {
                        this.$allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public java.lang.Object getAllowedHeaders() {
                        return this.$allowedHeaders;
                    }

                    @Override
                    public void setAllowedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public void setAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public java.lang.Object getExposedHeaders() {
                        return this.$exposedHeaders;
                    }

                    @Override
                    public void setExposedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public void setExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public java.lang.Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$id = value;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$id = value;
                    }

                    @Override
                    public java.lang.Object getMaxAge() {
                        return this.$maxAge;
                    }

                    @Override
                    public void setMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$maxAge = value;
                    }

                    @Override
                    public void setMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$maxAge = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.CorsRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            public java.lang.Object getAllowedMethods() {
                return this.jsiiGet("allowedMethods", java.lang.Object.class);
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            public void setAllowedMethods(final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedMethods", java.util.Objects.requireNonNull(value, "allowedMethods is required"));
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            public void setAllowedMethods(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedMethods", java.util.Objects.requireNonNull(value, "allowedMethods is required"));
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            public java.lang.Object getAllowedOrigins() {
                return this.jsiiGet("allowedOrigins", java.lang.Object.class);
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            public void setAllowedOrigins(final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedOrigins", java.util.Objects.requireNonNull(value, "allowedOrigins is required"));
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            public void setAllowedOrigins(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedOrigins", java.util.Objects.requireNonNull(value, "allowedOrigins is required"));
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAllowedHeaders() {
                return this.jsiiGet("allowedHeaders", java.lang.Object.class);
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            public void setAllowedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedHeaders", value);
            }

            /**
             * ``BucketResource.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            public void setAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedHeaders", value);
            }

            /**
             * ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExposedHeaders() {
                return this.jsiiGet("exposedHeaders", java.lang.Object.class);
            }

            /**
             * ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            public void setExposedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("exposedHeaders", value);
            }

            /**
             * ``BucketResource.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            public void setExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("exposedHeaders", value);
            }

            /**
             * ``BucketResource.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }

            /**
             * ``BucketResource.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``BucketResource.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``BucketResource.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxAge() {
                return this.jsiiGet("maxAge", java.lang.Object.class);
            }

            /**
             * ``BucketResource.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            public void setMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxAge", value);
            }

            /**
             * ``BucketResource.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            public void setMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxAge", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        java.lang.Object getDestination();
        /**
         * ``BucketResource.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value);
        /**
         * ``BucketResource.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        java.lang.Object getOutputSchemaVersion();
        /**
         * ``BucketResource.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        void setOutputSchemaVersion(final java.lang.String value);
        /**
         * ``BucketResource.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        void setOutputSchemaVersion(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DataExportProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.Object _outputSchemaVersion;

            /**
             * Sets the value of Destination
             * @param value ``BucketResource.DataExportProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value ``BucketResource.DataExportProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of OutputSchemaVersion
             * @param value ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @return {@code this}
             */
            public Builder withOutputSchemaVersion(final java.lang.String value) {
                this._outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }
            /**
             * Sets the value of OutputSchemaVersion
             * @param value ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @return {@code this}
             */
            public Builder withOutputSchemaVersion(final software.amazon.awscdk.Token value) {
                this._outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DataExportProperty build() {
                return new DataExportProperty() {
                    private java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private java.lang.Object $outputSchemaVersion = java.util.Objects.requireNonNull(_outputSchemaVersion, "outputSchemaVersion is required");

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.Token value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public java.lang.Object getOutputSchemaVersion() {
                        return this.$outputSchemaVersion;
                    }

                    @Override
                    public void setOutputSchemaVersion(final java.lang.String value) {
                        this.$outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                    }

                    @Override
                    public void setOutputSchemaVersion(final software.amazon.awscdk.Token value) {
                        this.$outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``BucketResource.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            @Override
            public java.lang.Object getOutputSchemaVersion() {
                return this.jsiiGet("outputSchemaVersion", java.lang.Object.class);
            }

            /**
             * ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            @Override
            public void setOutputSchemaVersion(final java.lang.String value) {
                this.jsiiSet("outputSchemaVersion", java.util.Objects.requireNonNull(value, "outputSchemaVersion is required"));
            }

            /**
             * ``BucketResource.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            @Override
            public void setOutputSchemaVersion(final software.amazon.awscdk.Token value) {
                this.jsiiSet("outputSchemaVersion", java.util.Objects.requireNonNull(value, "outputSchemaVersion is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        java.lang.Object getBucketArn();
        /**
         * ``BucketResource.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        void setBucketArn(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        void setBucketArn(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        java.lang.Object getFormat();
        /**
         * ``BucketResource.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        void setFormat(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        void setFormat(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        java.lang.Object getBucketAccountId();
        /**
         * ``BucketResource.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        void setBucketAccountId(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        void setBucketAccountId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DestinationProperty}
         */
        final class Builder {
            private java.lang.Object _bucketArn;
            private java.lang.Object _format;
            @javax.annotation.Nullable
            private java.lang.Object _bucketAccountId;
            @javax.annotation.Nullable
            private java.lang.Object _prefix;

            /**
             * Sets the value of BucketArn
             * @param value ``BucketResource.DestinationProperty.BucketArn``
             * @return {@code this}
             */
            public Builder withBucketArn(final java.lang.String value) {
                this._bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }
            /**
             * Sets the value of BucketArn
             * @param value ``BucketResource.DestinationProperty.BucketArn``
             * @return {@code this}
             */
            public Builder withBucketArn(final software.amazon.awscdk.Token value) {
                this._bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }
            /**
             * Sets the value of Format
             * @param value ``BucketResource.DestinationProperty.Format``
             * @return {@code this}
             */
            public Builder withFormat(final java.lang.String value) {
                this._format = java.util.Objects.requireNonNull(value, "format is required");
                return this;
            }
            /**
             * Sets the value of Format
             * @param value ``BucketResource.DestinationProperty.Format``
             * @return {@code this}
             */
            public Builder withFormat(final software.amazon.awscdk.Token value) {
                this._format = java.util.Objects.requireNonNull(value, "format is required");
                return this;
            }
            /**
             * Sets the value of BucketAccountId
             * @param value ``BucketResource.DestinationProperty.BucketAccountId``
             * @return {@code this}
             */
            public Builder withBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                this._bucketAccountId = value;
                return this;
            }
            /**
             * Sets the value of BucketAccountId
             * @param value ``BucketResource.DestinationProperty.BucketAccountId``
             * @return {@code this}
             */
            public Builder withBucketAccountId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._bucketAccountId = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.DestinationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.DestinationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DestinationProperty build() {
                return new DestinationProperty() {
                    private java.lang.Object $bucketArn = java.util.Objects.requireNonNull(_bucketArn, "bucketArn is required");
                    private java.lang.Object $format = java.util.Objects.requireNonNull(_format, "format is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $bucketAccountId = _bucketAccountId;
                    @javax.annotation.Nullable
                    private java.lang.Object $prefix = _prefix;

                    @Override
                    public java.lang.Object getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public void setBucketArn(final java.lang.String value) {
                        this.$bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                    }

                    @Override
                    public void setBucketArn(final software.amazon.awscdk.Token value) {
                        this.$bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                    }

                    @Override
                    public java.lang.Object getFormat() {
                        return this.$format;
                    }

                    @Override
                    public void setFormat(final java.lang.String value) {
                        this.$format = java.util.Objects.requireNonNull(value, "format is required");
                    }

                    @Override
                    public void setFormat(final software.amazon.awscdk.Token value) {
                        this.$format = java.util.Objects.requireNonNull(value, "format is required");
                    }

                    @Override
                    public java.lang.Object getBucketAccountId() {
                        return this.$bucketAccountId;
                    }

                    @Override
                    public void setBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$bucketAccountId = value;
                    }

                    @Override
                    public void setBucketAccountId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$bucketAccountId = value;
                    }

                    @Override
                    public java.lang.Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$prefix = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            @Override
            public java.lang.Object getBucketArn() {
                return this.jsiiGet("bucketArn", java.lang.Object.class);
            }

            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            @Override
            public void setBucketArn(final java.lang.String value) {
                this.jsiiSet("bucketArn", java.util.Objects.requireNonNull(value, "bucketArn is required"));
            }

            /**
             * ``BucketResource.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            @Override
            public void setBucketArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucketArn", java.util.Objects.requireNonNull(value, "bucketArn is required"));
            }

            /**
             * ``BucketResource.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            @Override
            public java.lang.Object getFormat() {
                return this.jsiiGet("format", java.lang.Object.class);
            }

            /**
             * ``BucketResource.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            @Override
            public void setFormat(final java.lang.String value) {
                this.jsiiSet("format", java.util.Objects.requireNonNull(value, "format is required"));
            }

            /**
             * ``BucketResource.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            @Override
            public void setFormat(final software.amazon.awscdk.Token value) {
                this.jsiiSet("format", java.util.Objects.requireNonNull(value, "format is required"));
            }

            /**
             * ``BucketResource.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBucketAccountId() {
                return this.jsiiGet("bucketAccountId", java.lang.Object.class);
            }

            /**
             * ``BucketResource.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @Override
            public void setBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bucketAccountId", value);
            }

            /**
             * ``BucketResource.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @Override
            public void setBucketAccountId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucketAccountId", value);
            }

            /**
             * ``BucketResource.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }

            /**
             * ``BucketResource.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        java.lang.Object getReplicaKmsKeyId();
        /**
         * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        void setReplicaKmsKeyId(final java.lang.String value);
        /**
         * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        void setReplicaKmsKeyId(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _replicaKmsKeyId;

            /**
             * Sets the value of ReplicaKmsKeyId
             * @param value ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @return {@code this}
             */
            public Builder withReplicaKmsKeyId(final java.lang.String value) {
                this._replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }
            /**
             * Sets the value of ReplicaKmsKeyId
             * @param value ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @return {@code this}
             */
            public Builder withReplicaKmsKeyId(final software.amazon.awscdk.Token value) {
                this._replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EncryptionConfigurationProperty build() {
                return new EncryptionConfigurationProperty() {
                    private java.lang.Object $replicaKmsKeyId = java.util.Objects.requireNonNull(_replicaKmsKeyId, "replicaKmsKeyId is required");

                    @Override
                    public java.lang.Object getReplicaKmsKeyId() {
                        return this.$replicaKmsKeyId;
                    }

                    @Override
                    public void setReplicaKmsKeyId(final java.lang.String value) {
                        this.$replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                    }

                    @Override
                    public void setReplicaKmsKeyId(final software.amazon.awscdk.Token value) {
                        this.$replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            @Override
            public java.lang.Object getReplicaKmsKeyId() {
                return this.jsiiGet("replicaKmsKeyId", java.lang.Object.class);
            }

            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            @Override
            public void setReplicaKmsKeyId(final java.lang.String value) {
                this.jsiiSet("replicaKmsKeyId", java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required"));
            }

            /**
             * ``BucketResource.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            @Override
            public void setReplicaKmsKeyId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("replicaKmsKeyId", java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        java.lang.Object getName();
        /**
         * ``BucketResource.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        void setName(final java.lang.String value);
        /**
         * ``BucketResource.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        void setName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        java.lang.Object getValue();
        /**
         * ``BucketResource.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``BucketResource.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FilterRuleProperty}
         */
        final class Builder {
            private java.lang.Object _name;
            private java.lang.Object _value;

            /**
             * Sets the value of Name
             * @param value ``BucketResource.FilterRuleProperty.Name``
             * @return {@code this}
             */
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``BucketResource.FilterRuleProperty.Name``
             * @return {@code this}
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``BucketResource.FilterRuleProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``BucketResource.FilterRuleProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FilterRuleProperty build() {
                return new FilterRuleProperty() {
                    private java.lang.Object $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private java.lang.Object $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(final java.lang.String value) {
                        this.$name = java.util.Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public void setName(final software.amazon.awscdk.Token value) {
                        this.$name = java.util.Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public java.lang.Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(final java.lang.String value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public void setValue(final software.amazon.awscdk.Token value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.FilterRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            @Override
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            @Override
            public void setName(final java.lang.String value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }

            /**
             * ``BucketResource.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            @Override
            public void setName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }

            /**
             * ``BucketResource.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            @Override
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }

            /**
             * ``BucketResource.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            @Override
            public void setValue(final java.lang.String value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }

            /**
             * ``BucketResource.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            @Override
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        java.lang.Object getDestination();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        java.lang.Object getIncludedObjectVersions();
        /**
         * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        void setIncludedObjectVersions(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        void setIncludedObjectVersions(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        java.lang.Object getScheduleFrequency();
        /**
         * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        void setScheduleFrequency(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        void setScheduleFrequency(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        java.lang.Object getOptionalFields();
        /**
         * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        void setOptionalFields(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        void setOptionalFields(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link InventoryConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InventoryConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.Object _enabled;
            private java.lang.Object _id;
            private java.lang.Object _includedObjectVersions;
            private java.lang.Object _scheduleFrequency;
            @javax.annotation.Nullable
            private java.lang.Object _optionalFields;
            @javax.annotation.Nullable
            private java.lang.Object _prefix;

            /**
             * Sets the value of Destination
             * @param value ``BucketResource.InventoryConfigurationProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value ``BucketResource.InventoryConfigurationProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.InventoryConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.InventoryConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final software.amazon.awscdk.Token value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of IncludedObjectVersions
             * @param value ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @return {@code this}
             */
            public Builder withIncludedObjectVersions(final java.lang.String value) {
                this._includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }
            /**
             * Sets the value of IncludedObjectVersions
             * @param value ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @return {@code this}
             */
            public Builder withIncludedObjectVersions(final software.amazon.awscdk.Token value) {
                this._includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }
            /**
             * Sets the value of ScheduleFrequency
             * @param value ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @return {@code this}
             */
            public Builder withScheduleFrequency(final java.lang.String value) {
                this._scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }
            /**
             * Sets the value of ScheduleFrequency
             * @param value ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @return {@code this}
             */
            public Builder withScheduleFrequency(final software.amazon.awscdk.Token value) {
                this._scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }
            /**
             * Sets the value of OptionalFields
             * @param value ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @return {@code this}
             */
            public Builder withOptionalFields(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._optionalFields = value;
                return this;
            }
            /**
             * Sets the value of OptionalFields
             * @param value ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @return {@code this}
             */
            public Builder withOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._optionalFields = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InventoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InventoryConfigurationProperty build() {
                return new InventoryConfigurationProperty() {
                    private java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");
                    private java.lang.Object $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private java.lang.Object $includedObjectVersions = java.util.Objects.requireNonNull(_includedObjectVersions, "includedObjectVersions is required");
                    private java.lang.Object $scheduleFrequency = java.util.Objects.requireNonNull(_scheduleFrequency, "scheduleFrequency is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $optionalFields = _optionalFields;
                    @javax.annotation.Nullable
                    private java.lang.Object $prefix = _prefix;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.Token value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(final java.lang.Boolean value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public void setEnabled(final software.amazon.awscdk.Token value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public java.lang.Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(final java.lang.String value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public void setId(final software.amazon.awscdk.Token value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public java.lang.Object getIncludedObjectVersions() {
                        return this.$includedObjectVersions;
                    }

                    @Override
                    public void setIncludedObjectVersions(final java.lang.String value) {
                        this.$includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                    }

                    @Override
                    public void setIncludedObjectVersions(final software.amazon.awscdk.Token value) {
                        this.$includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                    }

                    @Override
                    public java.lang.Object getScheduleFrequency() {
                        return this.$scheduleFrequency;
                    }

                    @Override
                    public void setScheduleFrequency(final java.lang.String value) {
                        this.$scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                    }

                    @Override
                    public void setScheduleFrequency(final software.amazon.awscdk.Token value) {
                        this.$scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                    }

                    @Override
                    public java.lang.Object getOptionalFields() {
                        return this.$optionalFields;
                    }

                    @Override
                    public void setOptionalFields(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public void setOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public java.lang.Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$prefix = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.InventoryConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            public void setEnabled(final java.lang.Boolean value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            @Override
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            @Override
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            @Override
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            @Override
            public java.lang.Object getIncludedObjectVersions() {
                return this.jsiiGet("includedObjectVersions", java.lang.Object.class);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            @Override
            public void setIncludedObjectVersions(final java.lang.String value) {
                this.jsiiSet("includedObjectVersions", java.util.Objects.requireNonNull(value, "includedObjectVersions is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            @Override
            public void setIncludedObjectVersions(final software.amazon.awscdk.Token value) {
                this.jsiiSet("includedObjectVersions", java.util.Objects.requireNonNull(value, "includedObjectVersions is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            @Override
            public java.lang.Object getScheduleFrequency() {
                return this.jsiiGet("scheduleFrequency", java.lang.Object.class);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            @Override
            public void setScheduleFrequency(final java.lang.String value) {
                this.jsiiSet("scheduleFrequency", java.util.Objects.requireNonNull(value, "scheduleFrequency is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            @Override
            public void setScheduleFrequency(final software.amazon.awscdk.Token value) {
                this.jsiiSet("scheduleFrequency", java.util.Objects.requireNonNull(value, "scheduleFrequency is required"));
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOptionalFields() {
                return this.jsiiGet("optionalFields", java.lang.Object.class);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            public void setOptionalFields(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("optionalFields", value);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            public void setOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("optionalFields", value);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        java.lang.Object getEvent();
        /**
         * ``BucketResource.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        void setEvent(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        java.lang.Object getFunction();
        /**
         * ``BucketResource.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        void setFunction(final java.lang.String value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        void setFunction(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``BucketResource.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);

        /**
         * @return a {@link Builder} of {@link LambdaConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LambdaConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _event;
            private java.lang.Object _function;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value ``BucketResource.LambdaConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Event
             * @param value ``BucketResource.LambdaConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final software.amazon.awscdk.Token value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Function
             * @param value ``BucketResource.LambdaConfigurationProperty.Function``
             * @return {@code this}
             */
            public Builder withFunction(final java.lang.String value) {
                this._function = java.util.Objects.requireNonNull(value, "function is required");
                return this;
            }
            /**
             * Sets the value of Function
             * @param value ``BucketResource.LambdaConfigurationProperty.Function``
             * @return {@code this}
             */
            public Builder withFunction(final software.amazon.awscdk.Token value) {
                this._function = java.util.Objects.requireNonNull(value, "function is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``BucketResource.LambdaConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``BucketResource.LambdaConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LambdaConfigurationProperty build() {
                return new LambdaConfigurationProperty() {
                    private java.lang.Object $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private java.lang.Object $function = java.util.Objects.requireNonNull(_function, "function is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.Object getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(final java.lang.String value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public void setEvent(final software.amazon.awscdk.Token value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public java.lang.Object getFunction() {
                        return this.$function;
                    }

                    @Override
                    public void setFunction(final java.lang.String value) {
                        this.$function = java.util.Objects.requireNonNull(value, "function is required");
                    }

                    @Override
                    public void setFunction(final software.amazon.awscdk.Token value) {
                        this.$function = java.util.Objects.requireNonNull(value, "function is required");
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                        this.$filter = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.LambdaConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            @Override
            public java.lang.Object getEvent() {
                return this.jsiiGet("event", java.lang.Object.class);
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            @Override
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            @Override
            public void setEvent(final software.amazon.awscdk.Token value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            @Override
            public java.lang.Object getFunction() {
                return this.jsiiGet("function", java.lang.Object.class);
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            @Override
            public void setFunction(final java.lang.String value) {
                this.jsiiSet("function", java.util.Objects.requireNonNull(value, "function is required"));
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            @Override
            public void setFunction(final software.amazon.awscdk.Token value) {
                this.jsiiSet("function", java.util.Objects.requireNonNull(value, "function is required"));
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }

            /**
             * ``BucketResource.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        java.lang.Object getRules();
        /**
         * ``BucketResource.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LifecycleConfigurationProperty build() {
                return new LifecycleConfigurationProperty() {
                    private java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(final software.amazon.awscdk.Token value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(final java.util.List<java.lang.Object> value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.LifecycleConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }

            /**
             * ``BucketResource.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        java.lang.Object getDestinationBucketName();
        /**
         * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        void setDestinationBucketName(final java.lang.String value);
        /**
         * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        void setDestinationBucketName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        java.lang.Object getLogFilePrefix();
        /**
         * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        void setLogFilePrefix(final java.lang.String value);
        /**
         * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        void setLogFilePrefix(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _destinationBucketName;
            @javax.annotation.Nullable
            private java.lang.Object _logFilePrefix;

            /**
             * Sets the value of DestinationBucketName
             * @param value ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @return {@code this}
             */
            public Builder withDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationBucketName = value;
                return this;
            }
            /**
             * Sets the value of DestinationBucketName
             * @param value ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @return {@code this}
             */
            public Builder withDestinationBucketName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._destinationBucketName = value;
                return this;
            }
            /**
             * Sets the value of LogFilePrefix
             * @param value ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @return {@code this}
             */
            public Builder withLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._logFilePrefix = value;
                return this;
            }
            /**
             * Sets the value of LogFilePrefix
             * @param value ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @return {@code this}
             */
            public Builder withLogFilePrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._logFilePrefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoggingConfigurationProperty build() {
                return new LoggingConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $destinationBucketName = _destinationBucketName;
                    @javax.annotation.Nullable
                    private java.lang.Object $logFilePrefix = _logFilePrefix;

                    @Override
                    public java.lang.Object getDestinationBucketName() {
                        return this.$destinationBucketName;
                    }

                    @Override
                    public void setDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$destinationBucketName = value;
                    }

                    @Override
                    public void setDestinationBucketName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$destinationBucketName = value;
                    }

                    @Override
                    public java.lang.Object getLogFilePrefix() {
                        return this.$logFilePrefix;
                    }

                    @Override
                    public void setLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$logFilePrefix = value;
                    }

                    @Override
                    public void setLogFilePrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$logFilePrefix = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.LoggingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDestinationBucketName() {
                return this.jsiiGet("destinationBucketName", java.lang.Object.class);
            }

            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @Override
            public void setDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationBucketName", value);
            }

            /**
             * ``BucketResource.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @Override
            public void setDestinationBucketName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("destinationBucketName", value);
            }

            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLogFilePrefix() {
                return this.jsiiGet("logFilePrefix", java.lang.Object.class);
            }

            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @Override
            public void setLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("logFilePrefix", value);
            }

            /**
             * ``BucketResource.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @Override
            public void setLogFilePrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("logFilePrefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``BucketResource.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link MetricsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MetricsConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _id;
            @javax.annotation.Nullable
            private java.lang.Object _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value ``BucketResource.MetricsConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.MetricsConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final software.amazon.awscdk.Token value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MetricsConfigurationProperty build() {
                return new MetricsConfigurationProperty() {
                    private java.lang.Object $id = java.util.Objects.requireNonNull(_id, "id is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $prefix = _prefix;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(final java.lang.String value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public void setId(final software.amazon.awscdk.Token value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public java.lang.Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$prefix = value;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagFilters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.MetricsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            @Override
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            @Override
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            @Override
            public void setId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``BucketResource.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        java.lang.Object getStorageClass();
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        void setStorageClass(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        java.lang.Object getTransitionInDays();
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        void setTransitionInDays(final java.lang.Number value);
        /**
         * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        void setTransitionInDays(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionTransitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NoncurrentVersionTransitionProperty}
         */
        final class Builder {
            private java.lang.Object _storageClass;
            private java.lang.Object _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of StorageClass
             * @param value ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(final software.amazon.awscdk.Token value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(final java.lang.Number value) {
                this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(final software.amazon.awscdk.Token value) {
                this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NoncurrentVersionTransitionProperty build() {
                return new NoncurrentVersionTransitionProperty() {
                    private java.lang.Object $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    private java.lang.Object $transitionInDays = java.util.Objects.requireNonNull(_transitionInDays, "transitionInDays is required");

                    @Override
                    public java.lang.Object getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(final java.lang.String value) {
                        this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public void setStorageClass(final software.amazon.awscdk.Token value) {
                        this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public java.lang.Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(final java.lang.Number value) {
                        this.$transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                    }

                    @Override
                    public void setTransitionInDays(final software.amazon.awscdk.Token value) {
                        this.$transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            @Override
            public java.lang.Object getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.Object.class);
            }

            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            @Override
            public void setStorageClass(final java.lang.String value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }

            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            @Override
            public void setStorageClass(final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }

            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }

            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            public void setTransitionInDays(final java.lang.Number value) {
                this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
            }

            /**
             * ``BucketResource.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            public void setTransitionInDays(final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        java.lang.Object getLambdaConfigurations();
        /**
         * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        void setLambdaConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        void setLambdaConfigurations(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        java.lang.Object getQueueConfigurations();
        /**
         * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        void setQueueConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        void setQueueConfigurations(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        java.lang.Object getTopicConfigurations();
        /**
         * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        void setTopicConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        void setTopicConfigurations(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _lambdaConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _queueConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _topicConfigurations;

            /**
             * Sets the value of LambdaConfigurations
             * @param value ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @return {@code this}
             */
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of LambdaConfigurations
             * @param value ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @return {@code this}
             */
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @return {@code this}
             */
            public Builder withQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @return {@code this}
             */
            public Builder withQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @return {@code this}
             */
            public Builder withTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._topicConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @return {@code this}
             */
            public Builder withTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._topicConfigurations = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NotificationConfigurationProperty build() {
                return new NotificationConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $lambdaConfigurations = _lambdaConfigurations;
                    @javax.annotation.Nullable
                    private java.lang.Object $queueConfigurations = _queueConfigurations;
                    @javax.annotation.Nullable
                    private java.lang.Object $topicConfigurations = _topicConfigurations;

                    @Override
                    public java.lang.Object getLambdaConfigurations() {
                        return this.$lambdaConfigurations;
                    }

                    @Override
                    public void setLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public void setLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public java.lang.Object getQueueConfigurations() {
                        return this.$queueConfigurations;
                    }

                    @Override
                    public void setQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public void setQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public java.lang.Object getTopicConfigurations() {
                        return this.$topicConfigurations;
                    }

                    @Override
                    public void setTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$topicConfigurations = value;
                    }

                    @Override
                    public void setTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$topicConfigurations = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLambdaConfigurations() {
                return this.jsiiGet("lambdaConfigurations", java.lang.Object.class);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            public void setLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("lambdaConfigurations", value);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            public void setLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("lambdaConfigurations", value);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getQueueConfigurations() {
                return this.jsiiGet("queueConfigurations", java.lang.Object.class);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            public void setQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("queueConfigurations", value);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            public void setQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("queueConfigurations", value);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTopicConfigurations() {
                return this.jsiiGet("topicConfigurations", java.lang.Object.class);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            public void setTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("topicConfigurations", value);
            }

            /**
             * ``BucketResource.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            public void setTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("topicConfigurations", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        java.lang.Object getS3Key();
        /**
         * ``BucketResource.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        void setS3Key(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        void setS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value);

        /**
         * @return a {@link Builder} of {@link NotificationFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationFilterProperty}
         */
        final class Builder {
            private java.lang.Object _s3Key;

            /**
             * Sets the value of S3Key
             * @param value ``BucketResource.NotificationFilterProperty.S3Key``
             * @return {@code this}
             */
            public Builder withS3Key(final software.amazon.awscdk.Token value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value ``BucketResource.NotificationFilterProperty.S3Key``
             * @return {@code this}
             */
            public Builder withS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NotificationFilterProperty build() {
                return new NotificationFilterProperty() {
                    private java.lang.Object $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.Object getS3Key() {
                        return this.$s3Key;
                    }

                    @Override
                    public void setS3Key(final software.amazon.awscdk.Token value) {
                        this.$s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                    }

                    @Override
                    public void setS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value) {
                        this.$s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            public java.lang.Object getS3Key() {
                return this.jsiiGet("s3Key", java.lang.Object.class);
            }

            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            public void setS3Key(final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }

            /**
             * ``BucketResource.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            public void setS3Key(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        java.lang.Object getBlockPublicAcls();
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        void setBlockPublicAcls(final java.lang.Boolean value);
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        void setBlockPublicAcls(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        java.lang.Object getBlockPublicPolicy();
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        void setBlockPublicPolicy(final java.lang.Boolean value);
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        void setBlockPublicPolicy(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        java.lang.Object getIgnorePublicAcls();
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        void setIgnorePublicAcls(final java.lang.Boolean value);
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        void setIgnorePublicAcls(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        java.lang.Object getRestrictPublicBuckets();
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        void setRestrictPublicBuckets(final java.lang.Boolean value);
        /**
         * ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        void setRestrictPublicBuckets(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _ignorePublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _restrictPublicBuckets;

            /**
             * Sets the value of BlockPublicAcls
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @return {@code this}
             */
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicAcls
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @return {@code this}
             */
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @return {@code this}
             */
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @return {@code this}
             */
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @return {@code this}
             */
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @return {@code this}
             */
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @return {@code this}
             */
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._restrictPublicBuckets = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @return {@code this}
             */
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PublicAccessBlockConfigurationProperty build() {
                return new PublicAccessBlockConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $blockPublicAcls = _blockPublicAcls;
                    @javax.annotation.Nullable
                    private java.lang.Object $blockPublicPolicy = _blockPublicPolicy;
                    @javax.annotation.Nullable
                    private java.lang.Object $ignorePublicAcls = _ignorePublicAcls;
                    @javax.annotation.Nullable
                    private java.lang.Object $restrictPublicBuckets = _restrictPublicBuckets;

                    @Override
                    public java.lang.Object getBlockPublicAcls() {
                        return this.$blockPublicAcls;
                    }

                    @Override
                    public void setBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$blockPublicAcls = value;
                    }

                    @Override
                    public void setBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$blockPublicAcls = value;
                    }

                    @Override
                    public java.lang.Object getBlockPublicPolicy() {
                        return this.$blockPublicPolicy;
                    }

                    @Override
                    public void setBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$blockPublicPolicy = value;
                    }

                    @Override
                    public void setBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$blockPublicPolicy = value;
                    }

                    @Override
                    public java.lang.Object getIgnorePublicAcls() {
                        return this.$ignorePublicAcls;
                    }

                    @Override
                    public void setIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ignorePublicAcls = value;
                    }

                    @Override
                    public void setIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ignorePublicAcls = value;
                    }

                    @Override
                    public java.lang.Object getRestrictPublicBuckets() {
                        return this.$restrictPublicBuckets;
                    }

                    @Override
                    public void setRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$restrictPublicBuckets = value;
                    }

                    @Override
                    public void setRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$restrictPublicBuckets = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.PublicAccessBlockConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicAcls() {
                return this.jsiiGet("blockPublicAcls", java.lang.Object.class);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            public void setBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("blockPublicAcls", value);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            public void setBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockPublicAcls", value);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicPolicy() {
                return this.jsiiGet("blockPublicPolicy", java.lang.Object.class);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            public void setBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("blockPublicPolicy", value);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            public void setBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockPublicPolicy", value);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePublicAcls() {
                return this.jsiiGet("ignorePublicAcls", java.lang.Object.class);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            public void setIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignorePublicAcls", value);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            public void setIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ignorePublicAcls", value);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRestrictPublicBuckets() {
                return this.jsiiGet("restrictPublicBuckets", java.lang.Object.class);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            public void setRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("restrictPublicBuckets", value);
            }

            /**
             * ``BucketResource.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            public void setRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("restrictPublicBuckets", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        java.lang.Object getEvent();
        /**
         * ``BucketResource.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        void setEvent(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        java.lang.Object getQueue();
        /**
         * ``BucketResource.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        void setQueue(final java.lang.String value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        void setQueue(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``BucketResource.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);

        /**
         * @return a {@link Builder} of {@link QueueConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueueConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _event;
            private java.lang.Object _queue;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value ``BucketResource.QueueConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Event
             * @param value ``BucketResource.QueueConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final software.amazon.awscdk.Token value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Queue
             * @param value ``BucketResource.QueueConfigurationProperty.Queue``
             * @return {@code this}
             */
            public Builder withQueue(final java.lang.String value) {
                this._queue = java.util.Objects.requireNonNull(value, "queue is required");
                return this;
            }
            /**
             * Sets the value of Queue
             * @param value ``BucketResource.QueueConfigurationProperty.Queue``
             * @return {@code this}
             */
            public Builder withQueue(final software.amazon.awscdk.Token value) {
                this._queue = java.util.Objects.requireNonNull(value, "queue is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``BucketResource.QueueConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``BucketResource.QueueConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public QueueConfigurationProperty build() {
                return new QueueConfigurationProperty() {
                    private java.lang.Object $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private java.lang.Object $queue = java.util.Objects.requireNonNull(_queue, "queue is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.Object getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(final java.lang.String value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public void setEvent(final software.amazon.awscdk.Token value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public java.lang.Object getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public void setQueue(final java.lang.String value) {
                        this.$queue = java.util.Objects.requireNonNull(value, "queue is required");
                    }

                    @Override
                    public void setQueue(final software.amazon.awscdk.Token value) {
                        this.$queue = java.util.Objects.requireNonNull(value, "queue is required");
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                        this.$filter = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.QueueConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            @Override
            public java.lang.Object getEvent() {
                return this.jsiiGet("event", java.lang.Object.class);
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            @Override
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            @Override
            public void setEvent(final software.amazon.awscdk.Token value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            @Override
            public java.lang.Object getQueue() {
                return this.jsiiGet("queue", java.lang.Object.class);
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            @Override
            public void setQueue(final java.lang.String value) {
                this.jsiiSet("queue", java.util.Objects.requireNonNull(value, "queue is required"));
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            @Override
            public void setQueue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("queue", java.util.Objects.requireNonNull(value, "queue is required"));
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }

            /**
             * ``BucketResource.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        java.lang.Object getHostName();
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        void setHostName(final java.lang.String value);
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        void setHostName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        java.lang.Object getProtocol();
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        void setProtocol(final java.lang.String value);
        /**
         * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        void setProtocol(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link RedirectAllRequestsToProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectAllRequestsToProperty}
         */
        final class Builder {
            private java.lang.Object _hostName;
            @javax.annotation.Nullable
            private java.lang.Object _protocol;

            /**
             * Sets the value of HostName
             * @param value ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @return {@code this}
             */
            public Builder withHostName(final java.lang.String value) {
                this._hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                return this;
            }
            /**
             * Sets the value of HostName
             * @param value ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @return {@code this}
             */
            public Builder withHostName(final software.amazon.awscdk.Token value) {
                this._hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._protocol = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectAllRequestsToProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectAllRequestsToProperty build() {
                return new RedirectAllRequestsToProperty() {
                    private java.lang.Object $hostName = java.util.Objects.requireNonNull(_hostName, "hostName is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $protocol = _protocol;

                    @Override
                    public java.lang.Object getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(final java.lang.String value) {
                        this.$hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                    }

                    @Override
                    public void setHostName(final software.amazon.awscdk.Token value) {
                        this.$hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                    }

                    @Override
                    public java.lang.Object getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                        this.$protocol = value;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$protocol = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            @Override
            public java.lang.Object getHostName() {
                return this.jsiiGet("hostName", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            @Override
            public void setHostName(final java.lang.String value) {
                this.jsiiSet("hostName", java.util.Objects.requireNonNull(value, "hostName is required"));
            }

            /**
             * ``BucketResource.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            @Override
            public void setHostName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("hostName", java.util.Objects.requireNonNull(value, "hostName is required"));
            }

            /**
             * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getProtocol() {
                return this.jsiiGet("protocol", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("protocol", value);
            }

            /**
             * ``BucketResource.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("protocol", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        java.lang.Object getHostName();
        /**
         * ``BucketResource.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        void setHostName(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        void setHostName(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        java.lang.Object getHttpRedirectCode();
        /**
         * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        void setHttpRedirectCode(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        void setHttpRedirectCode(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        java.lang.Object getProtocol();
        /**
         * ``BucketResource.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        void setProtocol(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        void setProtocol(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        java.lang.Object getReplaceKeyPrefixWith();
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        void setReplaceKeyPrefixWith(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        void setReplaceKeyPrefixWith(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        java.lang.Object getReplaceKeyWith();
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        void setReplaceKeyWith(final java.lang.String value);
        /**
         * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        void setReplaceKeyWith(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link RedirectRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _hostName;
            @javax.annotation.Nullable
            private java.lang.Object _httpRedirectCode;
            @javax.annotation.Nullable
            private java.lang.Object _protocol;
            @javax.annotation.Nullable
            private java.lang.Object _replaceKeyPrefixWith;
            @javax.annotation.Nullable
            private java.lang.Object _replaceKeyWith;

            /**
             * Sets the value of HostName
             * @param value ``BucketResource.RedirectRuleProperty.HostName``
             * @return {@code this}
             */
            public Builder withHostName(@javax.annotation.Nullable final java.lang.String value) {
                this._hostName = value;
                return this;
            }
            /**
             * Sets the value of HostName
             * @param value ``BucketResource.RedirectRuleProperty.HostName``
             * @return {@code this}
             */
            public Builder withHostName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._hostName = value;
                return this;
            }
            /**
             * Sets the value of HttpRedirectCode
             * @param value ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @return {@code this}
             */
            public Builder withHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                this._httpRedirectCode = value;
                return this;
            }
            /**
             * Sets the value of HttpRedirectCode
             * @param value ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @return {@code this}
             */
            public Builder withHttpRedirectCode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._httpRedirectCode = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``BucketResource.RedirectRuleProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``BucketResource.RedirectRuleProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyPrefixWith
             * @param value ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @return {@code this}
             */
            public Builder withReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyPrefixWith
             * @param value ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @return {@code this}
             */
            public Builder withReplaceKeyPrefixWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyWith
             * @param value ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @return {@code this}
             */
            public Builder withReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyWith = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyWith
             * @param value ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @return {@code this}
             */
            public Builder withReplaceKeyWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._replaceKeyWith = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectRuleProperty build() {
                return new RedirectRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $hostName = _hostName;
                    @javax.annotation.Nullable
                    private java.lang.Object $httpRedirectCode = _httpRedirectCode;
                    @javax.annotation.Nullable
                    private java.lang.Object $protocol = _protocol;
                    @javax.annotation.Nullable
                    private java.lang.Object $replaceKeyPrefixWith = _replaceKeyPrefixWith;
                    @javax.annotation.Nullable
                    private java.lang.Object $replaceKeyWith = _replaceKeyWith;

                    @Override
                    public java.lang.Object getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$hostName = value;
                    }

                    @Override
                    public void setHostName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$hostName = value;
                    }

                    @Override
                    public java.lang.Object getHttpRedirectCode() {
                        return this.$httpRedirectCode;
                    }

                    @Override
                    public void setHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                        this.$httpRedirectCode = value;
                    }

                    @Override
                    public void setHttpRedirectCode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$httpRedirectCode = value;
                    }

                    @Override
                    public java.lang.Object getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                        this.$protocol = value;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$protocol = value;
                    }

                    @Override
                    public java.lang.Object getReplaceKeyPrefixWith() {
                        return this.$replaceKeyPrefixWith;
                    }

                    @Override
                    public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                        this.$replaceKeyPrefixWith = value;
                    }

                    @Override
                    public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$replaceKeyPrefixWith = value;
                    }

                    @Override
                    public java.lang.Object getReplaceKeyWith() {
                        return this.$replaceKeyWith;
                    }

                    @Override
                    public void setReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                        this.$replaceKeyWith = value;
                    }

                    @Override
                    public void setReplaceKeyWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$replaceKeyWith = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getHostName() {
                return this.jsiiGet("hostName", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @Override
            public void setHostName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("hostName", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @Override
            public void setHostName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("hostName", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getHttpRedirectCode() {
                return this.jsiiGet("httpRedirectCode", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @Override
            public void setHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpRedirectCode", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @Override
            public void setHttpRedirectCode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpRedirectCode", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getProtocol() {
                return this.jsiiGet("protocol", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("protocol", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("protocol", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getReplaceKeyPrefixWith() {
                return this.jsiiGet("replaceKeyPrefixWith", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @Override
            public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("replaceKeyPrefixWith", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @Override
            public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("replaceKeyPrefixWith", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getReplaceKeyWith() {
                return this.jsiiGet("replaceKeyWith", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @Override
            public void setReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("replaceKeyWith", value);
            }

            /**
             * ``BucketResource.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @Override
            public void setReplaceKeyWith(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("replaceKeyWith", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        java.lang.Object getRole();
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        void setRole(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        void setRole(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        java.lang.Object getRules();
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _role;
            private java.lang.Object _rules;

            /**
             * Sets the value of Role
             * @param value ``BucketResource.ReplicationConfigurationProperty.Role``
             * @return {@code this}
             */
            public Builder withRole(final java.lang.String value) {
                this._role = java.util.Objects.requireNonNull(value, "role is required");
                return this;
            }
            /**
             * Sets the value of Role
             * @param value ``BucketResource.ReplicationConfigurationProperty.Role``
             * @return {@code this}
             */
            public Builder withRole(final software.amazon.awscdk.Token value) {
                this._role = java.util.Objects.requireNonNull(value, "role is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationConfigurationProperty build() {
                return new ReplicationConfigurationProperty() {
                    private java.lang.Object $role = java.util.Objects.requireNonNull(_role, "role is required");
                    private java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRole() {
                        return this.$role;
                    }

                    @Override
                    public void setRole(final java.lang.String value) {
                        this.$role = java.util.Objects.requireNonNull(value, "role is required");
                    }

                    @Override
                    public void setRole(final software.amazon.awscdk.Token value) {
                        this.$role = java.util.Objects.requireNonNull(value, "role is required");
                    }

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(final software.amazon.awscdk.Token value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(final java.util.List<java.lang.Object> value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            @Override
            public java.lang.Object getRole() {
                return this.jsiiGet("role", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            @Override
            public void setRole(final java.lang.String value) {
                this.jsiiSet("role", java.util.Objects.requireNonNull(value, "role is required"));
            }

            /**
             * ``BucketResource.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            @Override
            public void setRole(final software.amazon.awscdk.Token value) {
                this.jsiiSet("role", java.util.Objects.requireNonNull(value, "role is required"));
            }

            /**
             * ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }

            /**
             * ``BucketResource.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        java.lang.Object getBucket();
        /**
         * ``BucketResource.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        void setBucket(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        java.lang.Object getAccessControlTranslation();
        /**
         * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        void setAccessControlTranslation(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        void setAccessControlTranslation(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        java.lang.Object getAccount();
        /**
         * ``BucketResource.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        void setAccount(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        void setAccount(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        java.lang.Object getEncryptionConfiguration();
        /**
         * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        void setEncryptionConfiguration(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        void setEncryptionConfiguration(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        java.lang.Object getStorageClass();
        /**
         * ``BucketResource.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        void setStorageClass(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        final class Builder {
            private java.lang.Object _bucket;
            @javax.annotation.Nullable
            private java.lang.Object _accessControlTranslation;
            @javax.annotation.Nullable
            private java.lang.Object _account;
            @javax.annotation.Nullable
            private java.lang.Object _encryptionConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _storageClass;

            /**
             * Sets the value of Bucket
             * @param value ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Bucket
             * @param value ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(final software.amazon.awscdk.Token value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @return {@code this}
             */
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @return {@code this}
             */
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of Account
             * @param value ``BucketResource.ReplicationDestinationProperty.Account``
             * @return {@code this}
             */
            public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
                this._account = value;
                return this;
            }
            /**
             * Sets the value of Account
             * @param value ``BucketResource.ReplicationDestinationProperty.Account``
             * @return {@code this}
             */
            public Builder withAccount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._account = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of StorageClass
             * @param value ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                this._storageClass = value;
                return this;
            }
            /**
             * Sets the value of StorageClass
             * @param value ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._storageClass = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationDestinationProperty build() {
                return new ReplicationDestinationProperty() {
                    private java.lang.Object $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $accessControlTranslation = _accessControlTranslation;
                    @javax.annotation.Nullable
                    private java.lang.Object $account = _account;
                    @javax.annotation.Nullable
                    private java.lang.Object $encryptionConfiguration = _encryptionConfiguration;
                    @javax.annotation.Nullable
                    private java.lang.Object $storageClass = _storageClass;

                    @Override
                    public java.lang.Object getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public void setBucket(final java.lang.String value) {
                        this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public void setBucket(final software.amazon.awscdk.Token value) {
                        this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public java.lang.Object getAccessControlTranslation() {
                        return this.$accessControlTranslation;
                    }

                    @Override
                    public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public java.lang.Object getAccount() {
                        return this.$account;
                    }

                    @Override
                    public void setAccount(@javax.annotation.Nullable final java.lang.String value) {
                        this.$account = value;
                    }

                    @Override
                    public void setAccount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$account = value;
                    }

                    @Override
                    public java.lang.Object getEncryptionConfiguration() {
                        return this.$encryptionConfiguration;
                    }

                    @Override
                    public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public java.lang.Object getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                        this.$storageClass = value;
                    }

                    @Override
                    public void setStorageClass(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$storageClass = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            @Override
            public java.lang.Object getBucket() {
                return this.jsiiGet("bucket", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            @Override
            public void setBucket(final java.lang.String value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            @Override
            public void setBucket(final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAccessControlTranslation() {
                return this.jsiiGet("accessControlTranslation", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("accessControlTranslation", value);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AccessControlTranslationProperty value) {
                this.jsiiSet("accessControlTranslation", value);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAccount() {
                return this.jsiiGet("account", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @Override
            public void setAccount(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("account", value);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @Override
            public void setAccount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("account", value);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncryptionConfiguration() {
                return this.jsiiGet("encryptionConfiguration", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encryptionConfiguration", value);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.EncryptionConfigurationProperty value) {
                this.jsiiSet("encryptionConfiguration", value);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @Override
            public void setStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("storageClass", value);
            }

            /**
             * ``BucketResource.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @Override
            public void setStorageClass(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClass", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        java.lang.Object getDestination();
        /**
         * ``BucketResource.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        void setStatus(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        java.lang.Object getSourceSelectionCriteria();
        /**
         * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        void setSourceSelectionCriteria(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        void setSourceSelectionCriteria(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value);

        /**
         * @return a {@link Builder} of {@link ReplicationRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationRuleProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.Object _prefix;
            private java.lang.Object _status;
            @javax.annotation.Nullable
            private java.lang.Object _id;
            @javax.annotation.Nullable
            private java.lang.Object _sourceSelectionCriteria;

            /**
             * Sets the value of Destination
             * @param value ``BucketResource.ReplicationRuleProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value ``BucketResource.ReplicationRuleProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.ReplicationRuleProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(final java.lang.String value) {
                this._prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.ReplicationRuleProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(final software.amazon.awscdk.Token value) {
                this._prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``BucketResource.ReplicationRuleProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``BucketResource.ReplicationRuleProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final software.amazon.awscdk.Token value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.ReplicationRuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.ReplicationRuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @return {@code this}
             */
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sourceSelectionCriteria = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @return {@code this}
             */
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationRuleProperty build() {
                return new ReplicationRuleProperty() {
                    private java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private java.lang.Object $prefix = java.util.Objects.requireNonNull(_prefix, "prefix is required");
                    private java.lang.Object $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $id = _id;
                    @javax.annotation.Nullable
                    private java.lang.Object $sourceSelectionCriteria = _sourceSelectionCriteria;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.Token value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public java.lang.Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(final java.lang.String value) {
                        this.$prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                    }

                    @Override
                    public void setPrefix(final software.amazon.awscdk.Token value) {
                        this.$prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                    }

                    @Override
                    public java.lang.Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(final software.amazon.awscdk.Token value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public java.lang.Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$id = value;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$id = value;
                    }

                    @Override
                    public java.lang.Object getSourceSelectionCriteria() {
                        return this.$sourceSelectionCriteria;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sourceSelectionCriteria = value;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value) {
                        this.$sourceSelectionCriteria = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ReplicationDestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            @Override
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            @Override
            public void setPrefix(final java.lang.String value) {
                this.jsiiSet("prefix", java.util.Objects.requireNonNull(value, "prefix is required"));
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            @Override
            public void setPrefix(final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", java.util.Objects.requireNonNull(value, "prefix is required"));
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            @Override
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            @Override
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSourceSelectionCriteria() {
                return this.jsiiGet("sourceSelectionCriteria", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSelectionCriteria", value);
            }

            /**
             * ``BucketResource.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty value) {
                this.jsiiSet("sourceSelectionCriteria", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        java.lang.Object getHttpErrorCodeReturnedEquals();
        /**
         * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        void setHttpErrorCodeReturnedEquals(final java.lang.String value);
        /**
         * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        void setHttpErrorCodeReturnedEquals(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        java.lang.Object getKeyPrefixEquals();
        /**
         * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        void setKeyPrefixEquals(final java.lang.String value);
        /**
         * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        void setKeyPrefixEquals(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link RoutingRuleConditionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleConditionProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _httpErrorCodeReturnedEquals;
            @javax.annotation.Nullable
            private java.lang.Object _keyPrefixEquals;

            /**
             * Sets the value of HttpErrorCodeReturnedEquals
             * @param value ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @return {@code this}
             */
            public Builder withHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }
            /**
             * Sets the value of HttpErrorCodeReturnedEquals
             * @param value ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @return {@code this}
             */
            public Builder withHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }
            /**
             * Sets the value of KeyPrefixEquals
             * @param value ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @return {@code this}
             */
            public Builder withKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._keyPrefixEquals = value;
                return this;
            }
            /**
             * Sets the value of KeyPrefixEquals
             * @param value ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @return {@code this}
             */
            public Builder withKeyPrefixEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._keyPrefixEquals = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RoutingRuleConditionProperty build() {
                return new RoutingRuleConditionProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $httpErrorCodeReturnedEquals = _httpErrorCodeReturnedEquals;
                    @javax.annotation.Nullable
                    private java.lang.Object $keyPrefixEquals = _keyPrefixEquals;

                    @Override
                    public java.lang.Object getHttpErrorCodeReturnedEquals() {
                        return this.$httpErrorCodeReturnedEquals;
                    }

                    @Override
                    public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                        this.$httpErrorCodeReturnedEquals = value;
                    }

                    @Override
                    public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$httpErrorCodeReturnedEquals = value;
                    }

                    @Override
                    public java.lang.Object getKeyPrefixEquals() {
                        return this.$keyPrefixEquals;
                    }

                    @Override
                    public void setKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                        this.$keyPrefixEquals = value;
                    }

                    @Override
                    public void setKeyPrefixEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$keyPrefixEquals = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getHttpErrorCodeReturnedEquals() {
                return this.jsiiGet("httpErrorCodeReturnedEquals", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @Override
            public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpErrorCodeReturnedEquals", value);
            }

            /**
             * ``BucketResource.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @Override
            public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpErrorCodeReturnedEquals", value);
            }

            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKeyPrefixEquals() {
                return this.jsiiGet("keyPrefixEquals", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @Override
            public void setKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("keyPrefixEquals", value);
            }

            /**
             * ``BucketResource.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @Override
            public void setKeyPrefixEquals(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyPrefixEquals", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        java.lang.Object getRedirectRule();
        /**
         * ``BucketResource.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        void setRedirectRule(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        void setRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value);
        /**
         * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        java.lang.Object getRoutingRuleCondition();
        /**
         * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        void setRoutingRuleCondition(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        void setRoutingRuleCondition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value);

        /**
         * @return a {@link Builder} of {@link RoutingRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleProperty}
         */
        final class Builder {
            private java.lang.Object _redirectRule;
            @javax.annotation.Nullable
            private java.lang.Object _routingRuleCondition;

            /**
             * Sets the value of RedirectRule
             * @param value ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @return {@code this}
             */
            public Builder withRedirectRule(final software.amazon.awscdk.Token value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RedirectRule
             * @param value ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @return {@code this}
             */
            public Builder withRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @return {@code this}
             */
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._routingRuleCondition = value;
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @return {@code this}
             */
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RoutingRuleProperty build() {
                return new RoutingRuleProperty() {
                    private java.lang.Object $redirectRule = java.util.Objects.requireNonNull(_redirectRule, "redirectRule is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $routingRuleCondition = _routingRuleCondition;

                    @Override
                    public java.lang.Object getRedirectRule() {
                        return this.$redirectRule;
                    }

                    @Override
                    public void setRedirectRule(final software.amazon.awscdk.Token value) {
                        this.$redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public void setRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value) {
                        this.$redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public java.lang.Object getRoutingRuleCondition() {
                        return this.$routingRuleCondition;
                    }

                    @Override
                    public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$routingRuleCondition = value;
                    }

                    @Override
                    public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value) {
                        this.$routingRuleCondition = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            public java.lang.Object getRedirectRule() {
                return this.jsiiGet("redirectRule", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            public void setRedirectRule(final software.amazon.awscdk.Token value) {
                this.jsiiSet("redirectRule", java.util.Objects.requireNonNull(value, "redirectRule is required"));
            }

            /**
             * ``BucketResource.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            public void setRedirectRule(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectRuleProperty value) {
                this.jsiiSet("redirectRule", java.util.Objects.requireNonNull(value, "redirectRule is required"));
            }

            /**
             * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRuleCondition() {
                return this.jsiiGet("routingRuleCondition", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("routingRuleCondition", value);
            }

            /**
             * ``BucketResource.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RoutingRuleConditionProperty value) {
                this.jsiiSet("routingRuleCondition", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        void setStatus(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        java.lang.Object getAbortIncompleteMultipartUpload();
        /**
         * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value);
        /**
         * ``BucketResource.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        java.lang.Object getExpirationDate();
        /**
         * ``BucketResource.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        void setExpirationDate(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        void setExpirationDate(final java.time.Instant value);
        /**
         * ``BucketResource.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        java.lang.Object getExpirationInDays();
        /**
         * ``BucketResource.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        void setExpirationInDays(final java.lang.Number value);
        /**
         * ``BucketResource.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        void setExpirationInDays(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        java.lang.Object getId();
        /**
         * ``BucketResource.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        void setId(final java.lang.String value);
        /**
         * ``BucketResource.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        void setId(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        java.lang.Object getNoncurrentVersionExpirationInDays();
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        void setNoncurrentVersionExpirationInDays(final java.lang.Number value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        void setNoncurrentVersionExpirationInDays(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        java.lang.Object getNoncurrentVersionTransition();
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        void setNoncurrentVersionTransition(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        void setNoncurrentVersionTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        java.lang.Object getNoncurrentVersionTransitions();
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        void setNoncurrentVersionTransitions(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        void setNoncurrentVersionTransitions(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        java.lang.Object getPrefix();
        /**
         * ``BucketResource.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``BucketResource.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        void setPrefix(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``BucketResource.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);
        /**
         * ``BucketResource.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        java.lang.Object getTransition();
        /**
         * ``BucketResource.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        void setTransition(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        void setTransition(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value);
        /**
         * ``BucketResource.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        java.lang.Object getTransitions();
        /**
         * ``BucketResource.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        void setTransitions(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        void setTransitions(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RuleProperty}
         */
        final class Builder {
            private java.lang.Object _status;
            @javax.annotation.Nullable
            private java.lang.Object _abortIncompleteMultipartUpload;
            @javax.annotation.Nullable
            private java.lang.Object _expirationDate;
            @javax.annotation.Nullable
            private java.lang.Object _expirationInDays;
            @javax.annotation.Nullable
            private java.lang.Object _id;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionExpirationInDays;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransition;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransitions;
            @javax.annotation.Nullable
            private java.lang.Object _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;
            @javax.annotation.Nullable
            private java.lang.Object _transition;
            @javax.annotation.Nullable
            private java.lang.Object _transitions;

            /**
             * Sets the value of Status
             * @param value ``BucketResource.RuleProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``BucketResource.RuleProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final software.amazon.awscdk.Token value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @return {@code this}
             */
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @return {@code this}
             */
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value ``BucketResource.RuleProperty.ExpirationDate``
             * @return {@code this}
             */
            public Builder withExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value ``BucketResource.RuleProperty.ExpirationDate``
             * @return {@code this}
             */
            public Builder withExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationInDays
             * @param value ``BucketResource.RuleProperty.ExpirationInDays``
             * @return {@code this}
             */
            public Builder withExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._expirationInDays = value;
                return this;
            }
            /**
             * Sets the value of ExpirationInDays
             * @param value ``BucketResource.RuleProperty.ExpirationInDays``
             * @return {@code this}
             */
            public Builder withExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._expirationInDays = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.RuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``BucketResource.RuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param value ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param value ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.RuleProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``BucketResource.RuleProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``BucketResource.RuleProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``BucketResource.RuleProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value ``BucketResource.RuleProperty.Transition``
             * @return {@code this}
             */
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value ``BucketResource.RuleProperty.Transition``
             * @return {@code this}
             */
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value ``BucketResource.RuleProperty.Transitions``
             * @return {@code this}
             */
            public Builder withTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitions = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value ``BucketResource.RuleProperty.Transitions``
             * @return {@code this}
             */
            public Builder withTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._transitions = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RuleProperty build() {
                return new RuleProperty() {
                    private java.lang.Object $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $abortIncompleteMultipartUpload = _abortIncompleteMultipartUpload;
                    @javax.annotation.Nullable
                    private java.lang.Object $expirationDate = _expirationDate;
                    @javax.annotation.Nullable
                    private java.lang.Object $expirationInDays = _expirationInDays;
                    @javax.annotation.Nullable
                    private java.lang.Object $id = _id;
                    @javax.annotation.Nullable
                    private java.lang.Object $noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                    @javax.annotation.Nullable
                    private java.lang.Object $noncurrentVersionTransition = _noncurrentVersionTransition;
                    @javax.annotation.Nullable
                    private java.lang.Object $noncurrentVersionTransitions = _noncurrentVersionTransitions;
                    @javax.annotation.Nullable
                    private java.lang.Object $prefix = _prefix;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagFilters = _tagFilters;
                    @javax.annotation.Nullable
                    private java.lang.Object $transition = _transition;
                    @javax.annotation.Nullable
                    private java.lang.Object $transitions = _transitions;

                    @Override
                    public java.lang.Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(final software.amazon.awscdk.Token value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public java.lang.Object getAbortIncompleteMultipartUpload() {
                        return this.$abortIncompleteMultipartUpload;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public java.lang.Object getExpirationDate() {
                        return this.$expirationDate;
                    }

                    @Override
                    public void setExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public java.lang.Object getExpirationInDays() {
                        return this.$expirationInDays;
                    }

                    @Override
                    public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public void setExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public java.lang.Object getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$id = value;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$id = value;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionExpirationInDays() {
                        return this.$noncurrentVersionExpirationInDays;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransition() {
                        return this.$noncurrentVersionTransition;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransitions() {
                        return this.$noncurrentVersionTransitions;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public java.lang.Object getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$prefix = value;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public java.lang.Object getTransition() {
                        return this.$transition;
                    }

                    @Override
                    public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transition = value;
                    }

                    @Override
                    public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value) {
                        this.$transition = value;
                    }

                    @Override
                    public java.lang.Object getTransitions() {
                        return this.$transitions;
                    }

                    @Override
                    public void setTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transitions = value;
                    }

                    @Override
                    public void setTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$transitions = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.RuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            @Override
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``BucketResource.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            @Override
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.jsiiGet("abortIncompleteMultipartUpload", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("abortIncompleteMultipartUpload", value);
            }

            /**
             * ``BucketResource.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.AbortIncompleteMultipartUploadProperty value) {
                this.jsiiSet("abortIncompleteMultipartUpload", value);
            }

            /**
             * ``BucketResource.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExpirationDate() {
                return this.jsiiGet("expirationDate", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            public void setExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("expirationDate", value);
            }

            /**
             * ``BucketResource.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                this.jsiiSet("expirationDate", value);
            }

            /**
             * ``BucketResource.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExpirationInDays() {
                return this.jsiiGet("expirationInDays", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("expirationInDays", value);
            }

            /**
             * ``BucketResource.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            public void setExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("expirationInDays", value);
            }

            /**
             * ``BucketResource.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getId() {
                return this.jsiiGet("id", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``BucketResource.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionExpirationInDays() {
                return this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("noncurrentVersionExpirationInDays", value);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionExpirationInDays", value);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransition() {
                return this.jsiiGet("noncurrentVersionTransition", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionTransition", value);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NoncurrentVersionTransitionProperty value) {
                this.jsiiSet("noncurrentVersionTransition", value);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransitions() {
                return this.jsiiGet("noncurrentVersionTransitions", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionTransitions", value);
            }

            /**
             * ``BucketResource.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("noncurrentVersionTransitions", value);
            }

            /**
             * ``BucketResource.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrefix() {
                return this.jsiiGet("prefix", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``BucketResource.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``BucketResource.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``BucketResource.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransition() {
                return this.jsiiGet("transition", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transition", value);
            }

            /**
             * ``BucketResource.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty value) {
                this.jsiiSet("transition", value);
            }

            /**
             * ``BucketResource.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitions() {
                return this.jsiiGet("transitions", java.lang.Object.class);
            }

            /**
             * ``BucketResource.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            public void setTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitions", value);
            }

            /**
             * ``BucketResource.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            public void setTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("transitions", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        java.lang.Object getRules();
        /**
         * ``BucketResource.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value ``BucketResource.S3KeyFilterProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``BucketResource.S3KeyFilterProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3KeyFilterProperty build() {
                return new S3KeyFilterProperty() {
                    private java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(final software.amazon.awscdk.Token value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(final java.util.List<java.lang.Object> value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.S3KeyFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }

            /**
             * ``BucketResource.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        java.lang.Object getSseAlgorithm();
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        void setSseAlgorithm(final java.lang.String value);
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        void setSseAlgorithm(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        java.lang.Object getKmsMasterKeyId();
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        void setKmsMasterKeyId(final java.lang.String value);
        /**
         * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        void setKmsMasterKeyId(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        final class Builder {
            private java.lang.Object _sseAlgorithm;
            @javax.annotation.Nullable
            private java.lang.Object _kmsMasterKeyId;

            /**
             * Sets the value of SseAlgorithm
             * @param value ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @return {@code this}
             */
            public Builder withSseAlgorithm(final java.lang.String value) {
                this._sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }
            /**
             * Sets the value of SseAlgorithm
             * @param value ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @return {@code this}
             */
            public Builder withSseAlgorithm(final software.amazon.awscdk.Token value) {
                this._sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }
            /**
             * Sets the value of KmsMasterKeyId
             * @param value ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @return {@code this}
             */
            public Builder withKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this._kmsMasterKeyId = value;
                return this;
            }
            /**
             * Sets the value of KmsMasterKeyId
             * @param value ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @return {@code this}
             */
            public Builder withKmsMasterKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ServerSideEncryptionByDefaultProperty build() {
                return new ServerSideEncryptionByDefaultProperty() {
                    private java.lang.Object $sseAlgorithm = java.util.Objects.requireNonNull(_sseAlgorithm, "sseAlgorithm is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $kmsMasterKeyId = _kmsMasterKeyId;

                    @Override
                    public java.lang.Object getSseAlgorithm() {
                        return this.$sseAlgorithm;
                    }

                    @Override
                    public void setSseAlgorithm(final java.lang.String value) {
                        this.$sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                    }

                    @Override
                    public void setSseAlgorithm(final software.amazon.awscdk.Token value) {
                        this.$sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                    }

                    @Override
                    public java.lang.Object getKmsMasterKeyId() {
                        return this.$kmsMasterKeyId;
                    }

                    @Override
                    public void setKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$kmsMasterKeyId = value;
                    }

                    @Override
                    public void setKmsMasterKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$kmsMasterKeyId = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            @Override
            public java.lang.Object getSseAlgorithm() {
                return this.jsiiGet("sseAlgorithm", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            @Override
            public void setSseAlgorithm(final java.lang.String value) {
                this.jsiiSet("sseAlgorithm", java.util.Objects.requireNonNull(value, "sseAlgorithm is required"));
            }

            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            @Override
            public void setSseAlgorithm(final software.amazon.awscdk.Token value) {
                this.jsiiSet("sseAlgorithm", java.util.Objects.requireNonNull(value, "sseAlgorithm is required"));
            }

            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKmsMasterKeyId() {
                return this.jsiiGet("kmsMasterKeyId", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @Override
            public void setKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kmsMasterKeyId", value);
            }

            /**
             * ``BucketResource.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @Override
            public void setKmsMasterKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kmsMasterKeyId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        java.lang.Object getServerSideEncryptionByDefault();
        /**
         * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        void setServerSideEncryptionByDefault(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        void setServerSideEncryptionByDefault(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value);

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _serverSideEncryptionByDefault;

            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ServerSideEncryptionRuleProperty build() {
                return new ServerSideEncryptionRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $serverSideEncryptionByDefault = _serverSideEncryptionByDefault;

                    @Override
                    public java.lang.Object getServerSideEncryptionByDefault() {
                        return this.$serverSideEncryptionByDefault;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$serverSideEncryptionByDefault = value;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value) {
                        this.$serverSideEncryptionByDefault = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getServerSideEncryptionByDefault() {
                return this.jsiiGet("serverSideEncryptionByDefault", java.lang.Object.class);
            }

            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("serverSideEncryptionByDefault", value);
            }

            /**
             * ``BucketResource.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.ServerSideEncryptionByDefaultProperty value) {
                this.jsiiSet("serverSideEncryptionByDefault", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        java.lang.Object getSseKmsEncryptedObjects();
        /**
         * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value);

        /**
         * @return a {@link Builder} of {@link SourceSelectionCriteriaProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceSelectionCriteriaProperty}
         */
        final class Builder {
            private java.lang.Object _sseKmsEncryptedObjects;

            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @return {@code this}
             */
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }
            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @return {@code this}
             */
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceSelectionCriteriaProperty build() {
                return new SourceSelectionCriteriaProperty() {
                    private java.lang.Object $sseKmsEncryptedObjects = java.util.Objects.requireNonNull(_sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");

                    @Override
                    public java.lang.Object getSseKmsEncryptedObjects() {
                        return this.$sseKmsEncryptedObjects;
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                        this.$sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value) {
                        this.$sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.SourceSelectionCriteriaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            public java.lang.Object getSseKmsEncryptedObjects() {
                return this.jsiiGet("sseKmsEncryptedObjects", java.lang.Object.class);
            }

            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                this.jsiiSet("sseKmsEncryptedObjects", java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required"));
            }

            /**
             * ``BucketResource.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty value) {
                this.jsiiSet("sseKmsEncryptedObjects", java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        void setStatus(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SseKmsEncryptedObjectsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SseKmsEncryptedObjectsProperty}
         */
        final class Builder {
            private java.lang.Object _status;

            /**
             * Sets the value of Status
             * @param value ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final software.amazon.awscdk.Token value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseKmsEncryptedObjectsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SseKmsEncryptedObjectsProperty build() {
                return new SseKmsEncryptedObjectsProperty() {
                    private java.lang.Object $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(final software.amazon.awscdk.Token value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.SseKmsEncryptedObjectsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            @Override
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }

            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``BucketResource.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            @Override
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        java.lang.Object getDataExport();
        /**
         * ``BucketResource.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        void setDataExport(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        void setDataExport(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value);

        /**
         * @return a {@link Builder} of {@link StorageClassAnalysisProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StorageClassAnalysisProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _dataExport;

            /**
             * Sets the value of DataExport
             * @param value ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @return {@code this}
             */
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._dataExport = value;
                return this;
            }
            /**
             * Sets the value of DataExport
             * @param value ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @return {@code this}
             */
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value) {
                this._dataExport = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageClassAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StorageClassAnalysisProperty build() {
                return new StorageClassAnalysisProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $dataExport = _dataExport;

                    @Override
                    public java.lang.Object getDataExport() {
                        return this.$dataExport;
                    }

                    @Override
                    public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$dataExport = value;
                    }

                    @Override
                    public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value) {
                        this.$dataExport = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.StorageClassAnalysisProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDataExport() {
                return this.jsiiGet("dataExport", java.lang.Object.class);
            }

            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("dataExport", value);
            }

            /**
             * ``BucketResource.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.DataExportProperty value) {
                this.jsiiSet("dataExport", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        java.lang.Object getKey();
        /**
         * ``BucketResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``BucketResource.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        java.lang.Object getValue();
        /**
         * ``BucketResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``BucketResource.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        final class Builder {
            private java.lang.Object _key;
            private java.lang.Object _value;

            /**
             * Sets the value of Key
             * @param value ``BucketResource.TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``BucketResource.TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``BucketResource.TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``BucketResource.TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagFilterProperty build() {
                return new TagFilterProperty() {
                    private java.lang.Object $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private java.lang.Object $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.Object getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(final java.lang.String value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public void setKey(final software.amazon.awscdk.Token value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public java.lang.Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(final java.lang.String value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public void setValue(final software.amazon.awscdk.Token value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            @Override
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            @Override
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``BucketResource.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            @Override
            public void setKey(final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``BucketResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            @Override
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            @Override
            public void setValue(final java.lang.String value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }

            /**
             * ``BucketResource.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            @Override
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        java.lang.Object getEvent();
        /**
         * ``BucketResource.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        void setEvent(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        java.lang.Object getTopic();
        /**
         * ``BucketResource.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        void setTopic(final java.lang.String value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        void setTopic(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``BucketResource.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value);

        /**
         * @return a {@link Builder} of {@link TopicConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TopicConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _event;
            private java.lang.Object _topic;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value ``BucketResource.TopicConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Event
             * @param value ``BucketResource.TopicConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final software.amazon.awscdk.Token value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Topic
             * @param value ``BucketResource.TopicConfigurationProperty.Topic``
             * @return {@code this}
             */
            public Builder withTopic(final java.lang.String value) {
                this._topic = java.util.Objects.requireNonNull(value, "topic is required");
                return this;
            }
            /**
             * Sets the value of Topic
             * @param value ``BucketResource.TopicConfigurationProperty.Topic``
             * @return {@code this}
             */
            public Builder withTopic(final software.amazon.awscdk.Token value) {
                this._topic = java.util.Objects.requireNonNull(value, "topic is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``BucketResource.TopicConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``BucketResource.TopicConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TopicConfigurationProperty build() {
                return new TopicConfigurationProperty() {
                    private java.lang.Object $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private java.lang.Object $topic = java.util.Objects.requireNonNull(_topic, "topic is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.Object getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(final java.lang.String value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public void setEvent(final software.amazon.awscdk.Token value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public java.lang.Object getTopic() {
                        return this.$topic;
                    }

                    @Override
                    public void setTopic(final java.lang.String value) {
                        this.$topic = java.util.Objects.requireNonNull(value, "topic is required");
                    }

                    @Override
                    public void setTopic(final software.amazon.awscdk.Token value) {
                        this.$topic = java.util.Objects.requireNonNull(value, "topic is required");
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                        this.$filter = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.TopicConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            @Override
            public java.lang.Object getEvent() {
                return this.jsiiGet("event", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            @Override
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            @Override
            public void setEvent(final software.amazon.awscdk.Token value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            @Override
            public java.lang.Object getTopic() {
                return this.jsiiGet("topic", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            @Override
            public void setTopic(final java.lang.String value) {
                this.jsiiSet("topic", java.util.Objects.requireNonNull(value, "topic is required"));
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            @Override
            public void setTopic(final software.amazon.awscdk.Token value) {
                this.jsiiSet("topic", java.util.Objects.requireNonNull(value, "topic is required"));
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }

            /**
             * ``BucketResource.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        java.lang.Object getStorageClass();
        /**
         * ``BucketResource.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``BucketResource.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        void setStorageClass(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        java.lang.Object getTransitionDate();
        /**
         * ``BucketResource.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        void setTransitionDate(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        void setTransitionDate(final java.time.Instant value);
        /**
         * ``BucketResource.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        java.lang.Object getTransitionInDays();
        /**
         * ``BucketResource.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        void setTransitionInDays(final java.lang.Number value);
        /**
         * ``BucketResource.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        void setTransitionInDays(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link TransitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TransitionProperty}
         */
        final class Builder {
            private java.lang.Object _storageClass;
            @javax.annotation.Nullable
            private java.lang.Object _transitionDate;
            @javax.annotation.Nullable
            private java.lang.Object _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value ``BucketResource.TransitionProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of StorageClass
             * @param value ``BucketResource.TransitionProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(final software.amazon.awscdk.Token value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value ``BucketResource.TransitionProperty.TransitionDate``
             * @return {@code this}
             */
            public Builder withTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value ``BucketResource.TransitionProperty.TransitionDate``
             * @return {@code this}
             */
            public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``BucketResource.TransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._transitionInDays = value;
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``BucketResource.TransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitionInDays = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TransitionProperty build() {
                return new TransitionProperty() {
                    private java.lang.Object $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $transitionDate = _transitionDate;
                    @javax.annotation.Nullable
                    private java.lang.Object $transitionInDays = _transitionInDays;

                    @Override
                    public java.lang.Object getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(final java.lang.String value) {
                        this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public void setStorageClass(final software.amazon.awscdk.Token value) {
                        this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public java.lang.Object getTransitionDate() {
                        return this.$transitionDate;
                    }

                    @Override
                    public void setTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public java.lang.Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$transitionInDays = value;
                    }

                    @Override
                    public void setTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transitionInDays = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.TransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            @Override
            public java.lang.Object getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            @Override
            public void setStorageClass(final java.lang.String value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }

            /**
             * ``BucketResource.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            @Override
            public void setStorageClass(final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }

            /**
             * ``BucketResource.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitionDate() {
                return this.jsiiGet("transitionDate", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            public void setTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionDate", value);
            }

            /**
             * ``BucketResource.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                this.jsiiSet("transitionDate", value);
            }

            /**
             * ``BucketResource.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }

            /**
             * ``BucketResource.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("transitionInDays", value);
            }

            /**
             * ``BucketResource.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            public void setTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionInDays", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        java.lang.Object getStatus();
        /**
         * ``BucketResource.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``BucketResource.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        void setStatus(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _status;

            /**
             * Sets the value of Status
             * @param value ``BucketResource.VersioningConfigurationProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``BucketResource.VersioningConfigurationProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final software.amazon.awscdk.Token value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VersioningConfigurationProperty build() {
                return new VersioningConfigurationProperty() {
                    private java.lang.Object $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(final software.amazon.awscdk.Token value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.VersioningConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            @Override
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }

            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``BucketResource.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            @Override
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        java.lang.Object getErrorDocument();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        void setErrorDocument(final java.lang.String value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        void setErrorDocument(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        java.lang.Object getIndexDocument();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        void setIndexDocument(final java.lang.String value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        void setIndexDocument(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        java.lang.Object getRedirectAllRequestsTo();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        void setRedirectAllRequestsTo(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        void setRedirectAllRequestsTo(final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        java.lang.Object getRoutingRules();
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        void setRoutingRules(final software.amazon.awscdk.Token value);
        /**
         * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        void setRoutingRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link WebsiteConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link WebsiteConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _errorDocument;
            @javax.annotation.Nullable
            private java.lang.Object _indexDocument;
            @javax.annotation.Nullable
            private java.lang.Object _redirectAllRequestsTo;
            @javax.annotation.Nullable
            private java.lang.Object _routingRules;

            /**
             * Sets the value of ErrorDocument
             * @param value ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @return {@code this}
             */
            public Builder withErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._errorDocument = value;
                return this;
            }
            /**
             * Sets the value of ErrorDocument
             * @param value ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @return {@code this}
             */
            public Builder withErrorDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._errorDocument = value;
                return this;
            }
            /**
             * Sets the value of IndexDocument
             * @param value ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @return {@code this}
             */
            public Builder withIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._indexDocument = value;
                return this;
            }
            /**
             * Sets the value of IndexDocument
             * @param value ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @return {@code this}
             */
            public Builder withIndexDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._indexDocument = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @return {@code this}
             */
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @return {@code this}
             */
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @return {@code this}
             */
            public Builder withRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._routingRules = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @return {@code this}
             */
            public Builder withRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._routingRules = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebsiteConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public WebsiteConfigurationProperty build() {
                return new WebsiteConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $errorDocument = _errorDocument;
                    @javax.annotation.Nullable
                    private java.lang.Object $indexDocument = _indexDocument;
                    @javax.annotation.Nullable
                    private java.lang.Object $redirectAllRequestsTo = _redirectAllRequestsTo;
                    @javax.annotation.Nullable
                    private java.lang.Object $routingRules = _routingRules;

                    @Override
                    public java.lang.Object getErrorDocument() {
                        return this.$errorDocument;
                    }

                    @Override
                    public void setErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                        this.$errorDocument = value;
                    }

                    @Override
                    public void setErrorDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$errorDocument = value;
                    }

                    @Override
                    public java.lang.Object getIndexDocument() {
                        return this.$indexDocument;
                    }

                    @Override
                    public void setIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                        this.$indexDocument = value;
                    }

                    @Override
                    public void setIndexDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$indexDocument = value;
                    }

                    @Override
                    public java.lang.Object getRedirectAllRequestsTo() {
                        return this.$redirectAllRequestsTo;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public java.lang.Object getRoutingRules() {
                        return this.$routingRules;
                    }

                    @Override
                    public void setRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$routingRules = value;
                    }

                    @Override
                    public void setRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$routingRules = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.cloudformation.BucketResource.WebsiteConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getErrorDocument() {
                return this.jsiiGet("errorDocument", java.lang.Object.class);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @Override
            public void setErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("errorDocument", value);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @Override
            public void setErrorDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("errorDocument", value);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIndexDocument() {
                return this.jsiiGet("indexDocument", java.lang.Object.class);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @Override
            public void setIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("indexDocument", value);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @Override
            public void setIndexDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("indexDocument", value);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRedirectAllRequestsTo() {
                return this.jsiiGet("redirectAllRequestsTo", java.lang.Object.class);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("redirectAllRequestsTo", value);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.cloudformation.BucketResource.RedirectAllRequestsToProperty value) {
                this.jsiiSet("redirectAllRequestsTo", value);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRules() {
                return this.jsiiGet("routingRules", java.lang.Object.class);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            public void setRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("routingRules", value);
            }

            /**
             * ``BucketResource.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            public void setRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("routingRules", value);
            }
        }
    }
}
