package software.amazon.awscdk.services.s3;

/**
 * Common properties for creating {@link PipelineDeployAction} -
 * either directly, through its constructor,
 * or through {@link IBucket#addToPipelineAsDeploy}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-04T14:54:39.114Z")
public interface CommonPipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * Should the deploy action extract the artifact before deploying to Amazon S3.
     * @default true
     */
    java.lang.Boolean getExtract();
    /**
     * Should the deploy action extract the artifact before deploying to Amazon S3.
     * @default true
     */
    void setExtract(final java.lang.Boolean value);
    /**
     * The inputArtifact to deploy to Amazon S3.
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * The inputArtifact to deploy to Amazon S3.
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value);
    /**
     * The key of the target object. This is required if extract is false.
     */
    java.lang.String getObjectKey();
    /**
     * The key of the target object. This is required if extract is false.
     */
    void setObjectKey(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link CommonPipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CommonPipelineDeployActionProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _extract;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.String _objectKey;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of Extract
         * @param value Should the deploy action extract the artifact before deploying to Amazon S3.
         * @return {@code this}
         */
        public Builder withExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._extract = value;
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The inputArtifact to deploy to Amazon S3.
         * @return {@code this}
         */
        public Builder withInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = value;
            return this;
        }
        /**
         * Sets the value of ObjectKey
         * @param value The key of the target object. This is required if extract is false.
         * @return {@code this}
         */
        public Builder withObjectKey(@javax.annotation.Nullable final java.lang.String value) {
            this._objectKey = value;
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonPipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CommonPipelineDeployActionProps build() {
            return new CommonPipelineDeployActionProps() {
                @javax.annotation.Nullable
                private java.lang.Boolean $extract = _extract;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = _inputArtifact;
                @javax.annotation.Nullable
                private java.lang.String $objectKey = _objectKey;
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;

                @Override
                public java.lang.Boolean getExtract() {
                    return this.$extract;
                }

                @Override
                public void setExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$extract = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = value;
                }

                @Override
                public java.lang.String getObjectKey() {
                    return this.$objectKey;
                }

                @Override
                public void setObjectKey(@javax.annotation.Nullable final java.lang.String value) {
                    this.$objectKey = value;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Should the deploy action extract the artifact before deploying to Amazon S3.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getExtract() {
            return this.jsiiGet("extract", java.lang.Boolean.class);
        }

        /**
         * Should the deploy action extract the artifact before deploying to Amazon S3.
         * @default true
         */
        @Override
        public void setExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("extract", value);
        }

        /**
         * The inputArtifact to deploy to Amazon S3.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The inputArtifact to deploy to Amazon S3.
         */
        @Override
        public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", value);
        }

        /**
         * The key of the target object. This is required if extract is false.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getObjectKey() {
            return this.jsiiGet("objectKey", java.lang.String.class);
        }

        /**
         * The key of the target object. This is required if extract is false.
         */
        @Override
        public void setObjectKey(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("objectKey", value);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }
    }
}
