package software.amazon.awscdk.services.s3;

/**
 * Construction properties of the {@link PipelineSourceAction S3 source Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-04T14:54:39.124Z")
public interface PipelineSourceActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps, software.amazon.awscdk.services.codepipeline.api.CommonActionConstructProps {
    /**
     * The Amazon S3 bucket that stores the source code
     */
    software.amazon.awscdk.services.s3.IBucket getBucket();
    /**
     * The Amazon S3 bucket that stores the source code
     */
    void setBucket(final software.amazon.awscdk.services.s3.IBucket value);

    /**
     * @return a {@link Builder} of {@link PipelineSourceActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineSourceActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.IBucket _bucket;
        private java.lang.String _bucketKey;
        @javax.annotation.Nullable
        private java.lang.String _outputArtifactName;
        @javax.annotation.Nullable
        private java.lang.Boolean _pollForSourceChanges;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of Bucket
         * @param value The Amazon S3 bucket that stores the source code
         * @return {@code this}
         */
        public Builder withBucket(final software.amazon.awscdk.services.s3.IBucket value) {
            this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
            return this;
        }
        /**
         * Sets the value of BucketKey
         * @param value The key within the S3 bucket that stores the source code.
         * @return {@code this}
         */
        public Builder withBucketKey(final java.lang.String value) {
            this._bucketKey = java.util.Objects.requireNonNull(value, "bucketKey is required");
            return this;
        }
        /**
         * Sets the value of OutputArtifactName
         * @param value The name of the source's output artifact. Output artifacts are used by CodePipeline as
inputs into other actions.
         * @return {@code this}
         */
        public Builder withOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this._outputArtifactName = value;
            return this;
        }
        /**
         * Sets the value of PollForSourceChanges
         * @param value Whether AWS CodePipeline should poll for source changes.
If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
as otherwise the CloudWatch Events will not be emitted.
         * @return {@code this}
         */
        public Builder withPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._pollForSourceChanges = value;
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineSourceActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineSourceActionProps build() {
            return new PipelineSourceActionProps() {
                private software.amazon.awscdk.services.s3.IBucket $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                private java.lang.String $bucketKey = java.util.Objects.requireNonNull(_bucketKey, "bucketKey is required");
                @javax.annotation.Nullable
                private java.lang.String $outputArtifactName = _outputArtifactName;
                @javax.annotation.Nullable
                private java.lang.Boolean $pollForSourceChanges = _pollForSourceChanges;
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public software.amazon.awscdk.services.s3.IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(final software.amazon.awscdk.services.s3.IBucket value) {
                    this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public java.lang.String getBucketKey() {
                    return this.$bucketKey;
                }

                @Override
                public void setBucketKey(final java.lang.String value) {
                    this.$bucketKey = java.util.Objects.requireNonNull(value, "bucketKey is required");
                }

                @Override
                public java.lang.String getOutputArtifactName() {
                    return this.$outputArtifactName;
                }

                @Override
                public void setOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$outputArtifactName = value;
                }

                @Override
                public java.lang.Boolean getPollForSourceChanges() {
                    return this.$pollForSourceChanges;
                }

                @Override
                public void setPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$pollForSourceChanges = value;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.PipelineSourceActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon S3 bucket that stores the source code
         */
        @Override
        public software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.IBucket.class);
        }

        /**
         * The Amazon S3 bucket that stores the source code
         */
        @Override
        public void setBucket(final software.amazon.awscdk.services.s3.IBucket value) {
            this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
        }

        /**
         * The key within the S3 bucket that stores the source code.
         * @example 'path/to/file.zip'
         */
        @Override
        public java.lang.String getBucketKey() {
            return this.jsiiGet("bucketKey", java.lang.String.class);
        }

        /**
         * The key within the S3 bucket that stores the source code.
         * @example 'path/to/file.zip'
         */
        @Override
        public void setBucketKey(final java.lang.String value) {
            this.jsiiSet("bucketKey", java.util.Objects.requireNonNull(value, "bucketKey is required"));
        }

        /**
         * The name of the source's output artifact. Output artifacts are used by CodePipeline as
         * inputs into other actions.
         * @default a name will be auto-generated
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOutputArtifactName() {
            return this.jsiiGet("outputArtifactName", java.lang.String.class);
        }

        /**
         * The name of the source's output artifact. Output artifacts are used by CodePipeline as
         * inputs into other actions.
         * @default a name will be auto-generated
         */
        @Override
        public void setOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("outputArtifactName", value);
        }

        /**
         * Whether AWS CodePipeline should poll for source changes.
         * If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
         * Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
         * as otherwise the CloudWatch Events will not be emitted.
         * @default true
         * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPollForSourceChanges() {
            return this.jsiiGet("pollForSourceChanges", java.lang.Boolean.class);
        }

        /**
         * Whether AWS CodePipeline should poll for source changes.
         * If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
         * Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
         * as otherwise the CloudWatch Events will not be emitted.
         * @default true
         * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
         */
        @Override
        public void setPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("pollForSourceChanges", value);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
