/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codepipeline.api.CommonActionConstructProps;
import software.amazon.awscdk.services.codepipeline.api.IStage;
import software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineSourceActionProps
extends JsiiSerializable,
CommonPipelineSourceActionProps,
CommonActionConstructProps {
    public IBucket getBucket();

    public void setBucket(IBucket var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        private String _bucketKey;
        @Nullable
        private String _outputArtifactName;
        @Nullable
        private Boolean _pollForSourceChanges;
        @Nullable
        private Number _runOrder;
        private IStage _stage;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withBucketKey(String value) {
            this._bucketKey = Objects.requireNonNull(value, "bucketKey is required");
            return this;
        }

        public Builder withOutputArtifactName(@Nullable String value) {
            this._outputArtifactName = value;
            return this;
        }

        public Builder withPollForSourceChanges(@Nullable Boolean value) {
            this._pollForSourceChanges = value;
            return this;
        }

        public Builder withRunOrder(@Nullable Number value) {
            this._runOrder = value;
            return this;
        }

        public Builder withStage(IStage value) {
            this._stage = Objects.requireNonNull(value, "stage is required");
            return this;
        }

        public PipelineSourceActionProps build() {
            return new PipelineSourceActionProps(){
                private IBucket $bucket;
                private String $bucketKey;
                @Nullable
                private String $outputArtifactName;
                @Nullable
                private Boolean $pollForSourceChanges;
                @Nullable
                private Number $runOrder;
                private IStage $stage;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$bucketKey = Objects.requireNonNull(_bucketKey, "bucketKey is required");
                    this.$outputArtifactName = _outputArtifactName;
                    this.$pollForSourceChanges = _pollForSourceChanges;
                    this.$runOrder = _runOrder;
                    this.$stage = Objects.requireNonNull(_stage, "stage is required");
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(IBucket value) {
                    this.$bucket = Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public String getBucketKey() {
                    return this.$bucketKey;
                }

                @Override
                public void setBucketKey(String value) {
                    this.$bucketKey = Objects.requireNonNull(value, "bucketKey is required");
                }

                @Override
                public String getOutputArtifactName() {
                    return this.$outputArtifactName;
                }

                @Override
                public void setOutputArtifactName(@Nullable String value) {
                    this.$outputArtifactName = value;
                }

                @Override
                public Boolean getPollForSourceChanges() {
                    return this.$pollForSourceChanges;
                }

                @Override
                public void setPollForSourceChanges(@Nullable Boolean value) {
                    this.$pollForSourceChanges = value;
                }

                public Number getRunOrder() {
                    return this.$runOrder;
                }

                public void setRunOrder(@Nullable Number value) {
                    this.$runOrder = value;
                }

                public IStage getStage() {
                    return this.$stage;
                }

                public void setStage(IStage value) {
                    this.$stage = Objects.requireNonNull(value, "stage is required");
                }
            };
        }
    }
}

