package software.amazon.awscdk.services.s3;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:11:04.673Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.Resource {
    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnBucket.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::S3::Bucket``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnBucket(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    /**
     * Creates a new ``AWS::S3::Bucket``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     */
    public CfnBucket(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformation_attribute Arn
     */
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute DomainName
     */
    public java.lang.String getBucketDomainName() {
        return this.jsiiGet("bucketDomainName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute DualStackDomainName
     */
    public java.lang.String getBucketDualStackDomainName() {
        return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
    }

    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute RegionalDomainName
     */
    public java.lang.String getBucketRegionalDomainName() {
        return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute WebsiteURL
     */
    public java.lang.String getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
    }

    public software.amazon.awscdk.services.s3.CfnBucketProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.s3.CfnBucketProps.class);
    }

    /**
     * The ``TagManager`` handles setting, removing and formatting tags
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. ``Tag`` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        java.lang.Object getDaysAfterInitiation();
        /**
         * ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        void setDaysAfterInitiation(final java.lang.Number value);
        /**
         * ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        void setDaysAfterInitiation(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        final class Builder {
            private java.lang.Object _daysAfterInitiation;

            /**
             * Sets the value of DaysAfterInitiation
             * @param value ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @return {@code this}
             */
            public Builder withDaysAfterInitiation(final java.lang.Number value) {
                this._daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }
            /**
             * Sets the value of DaysAfterInitiation
             * @param value ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @return {@code this}
             */
            public Builder withDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                this._daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AbortIncompleteMultipartUploadProperty build() {
                return new AbortIncompleteMultipartUploadProperty() {
                    private java.lang.Object $daysAfterInitiation = java.util.Objects.requireNonNull(_daysAfterInitiation, "daysAfterInitiation is required");

                    @Override
                    public java.lang.Object getDaysAfterInitiation() {
                        return this.$daysAfterInitiation;
                    }

                    @Override
                    public void setDaysAfterInitiation(final java.lang.Number value) {
                        this.$daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }

                    @Override
                    public void setDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                        this.$daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            public java.lang.Object getDaysAfterInitiation() {
                return this.jsiiGet("daysAfterInitiation", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            public void setDaysAfterInitiation(final java.lang.Number value) {
                this.jsiiSet("daysAfterInitiation", java.util.Objects.requireNonNull(value, "daysAfterInitiation is required"));
            }

            /**
             * ``CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            public void setDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                this.jsiiSet("daysAfterInitiation", java.util.Objects.requireNonNull(value, "daysAfterInitiation is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        java.lang.String getAccelerationStatus();
        /**
         * ``CfnBucket.AccelerateConfigurationProperty.AccelerationStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        void setAccelerationStatus(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link AccelerateConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccelerateConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _accelerationStatus;

            /**
             * Sets the value of AccelerationStatus
             * @param value ``CfnBucket.AccelerateConfigurationProperty.AccelerationStatus``
             * @return {@code this}
             */
            public Builder withAccelerationStatus(final java.lang.String value) {
                this._accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccelerateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccelerateConfigurationProperty build() {
                return new AccelerateConfigurationProperty() {
                    private java.lang.String $accelerationStatus = java.util.Objects.requireNonNull(_accelerationStatus, "accelerationStatus is required");

                    @Override
                    public java.lang.String getAccelerationStatus() {
                        return this.$accelerationStatus;
                    }

                    @Override
                    public void setAccelerationStatus(final java.lang.String value) {
                        this.$accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            @Override
            public java.lang.String getAccelerationStatus() {
                return this.jsiiGet("accelerationStatus", java.lang.String.class);
            }

            /**
             * ``CfnBucket.AccelerateConfigurationProperty.AccelerationStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            @Override
            public void setAccelerationStatus(final java.lang.String value) {
                this.jsiiSet("accelerationStatus", java.util.Objects.requireNonNull(value, "accelerationStatus is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        java.lang.String getOwner();
        /**
         * ``CfnBucket.AccessControlTranslationProperty.Owner``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        void setOwner(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link AccessControlTranslationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccessControlTranslationProperty}
         */
        final class Builder {
            private java.lang.String _owner;

            /**
             * Sets the value of Owner
             * @param value ``CfnBucket.AccessControlTranslationProperty.Owner``
             * @return {@code this}
             */
            public Builder withOwner(final java.lang.String value) {
                this._owner = java.util.Objects.requireNonNull(value, "owner is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlTranslationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccessControlTranslationProperty build() {
                return new AccessControlTranslationProperty() {
                    private java.lang.String $owner = java.util.Objects.requireNonNull(_owner, "owner is required");

                    @Override
                    public java.lang.String getOwner() {
                        return this.$owner;
                    }

                    @Override
                    public void setOwner(final java.lang.String value) {
                        this.$owner = java.util.Objects.requireNonNull(value, "owner is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            @Override
            public java.lang.String getOwner() {
                return this.jsiiGet("owner", java.lang.String.class);
            }

            /**
             * ``CfnBucket.AccessControlTranslationProperty.Owner``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            @Override
            public void setOwner(final java.lang.String value) {
                this.jsiiSet("owner", java.util.Objects.requireNonNull(value, "owner is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        java.lang.String getId();
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        java.lang.Object getStorageClassAnalysis();
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        void setStorageClassAnalysis(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty value);
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        java.lang.String getPrefix();
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _id;
            private java.lang.Object _storageClassAnalysis;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value ``CfnBucket.AnalyticsConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @return {@code this}
             */
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @return {@code this}
             */
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``CfnBucket.AnalyticsConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AnalyticsConfigurationProperty build() {
                return new AnalyticsConfigurationProperty() {
                    private java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private java.lang.Object $storageClassAnalysis = java.util.Objects.requireNonNull(_storageClassAnalysis, "storageClassAnalysis is required");
                    @javax.annotation.Nullable
                    private java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(final java.lang.String value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public java.lang.Object getStorageClassAnalysis() {
                        return this.$storageClassAnalysis;
                    }

                    @Override
                    public void setStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                        this.$storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty value) {
                        this.$storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagFilters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AnalyticsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            @Override
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            public java.lang.Object getStorageClassAnalysis() {
                return this.jsiiGet("storageClassAnalysis", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            public void setStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                this.jsiiSet("storageClassAnalysis", java.util.Objects.requireNonNull(value, "storageClassAnalysis is required"));
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            public void setStorageClassAnalysis(final software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty value) {
                this.jsiiSet("storageClassAnalysis", java.util.Objects.requireNonNull(value, "storageClassAnalysis is required"));
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``CfnBucket.AnalyticsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        java.lang.Object getServerSideEncryptionConfiguration();
        /**
         * ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        final class Builder {
            private java.lang.Object _serverSideEncryptionConfiguration;

            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BucketEncryptionProperty build() {
                return new BucketEncryptionProperty() {
                    private java.lang.Object $serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(_serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");

                    @Override
                    public java.lang.Object getServerSideEncryptionConfiguration() {
                        return this.$serverSideEncryptionConfiguration;
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                        this.$serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }

                    @Override
                    public void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                        this.$serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this.jsiiGet("serverSideEncryptionConfiguration", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            public void setServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this.jsiiSet("serverSideEncryptionConfiguration", java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required"));
            }

            /**
             * ``CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            public void setServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("serverSideEncryptionConfiguration", java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        java.lang.Object getCorsRules();
        /**
         * ``CfnBucket.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        void setCorsRules(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.CorsConfigurationProperty.CorsRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        void setCorsRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _corsRules;

            /**
             * Sets the value of CorsRules
             * @param value ``CfnBucket.CorsConfigurationProperty.CorsRules``
             * @return {@code this}
             */
            public Builder withCorsRules(final software.amazon.awscdk.Token value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }
            /**
             * Sets the value of CorsRules
             * @param value ``CfnBucket.CorsConfigurationProperty.CorsRules``
             * @return {@code this}
             */
            public Builder withCorsRules(final java.util.List<java.lang.Object> value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CorsConfigurationProperty build() {
                return new CorsConfigurationProperty() {
                    private java.lang.Object $corsRules = java.util.Objects.requireNonNull(_corsRules, "corsRules is required");

                    @Override
                    public java.lang.Object getCorsRules() {
                        return this.$corsRules;
                    }

                    @Override
                    public void setCorsRules(final software.amazon.awscdk.Token value) {
                        this.$corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                    }

                    @Override
                    public void setCorsRules(final java.util.List<java.lang.Object> value) {
                        this.$corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            public java.lang.Object getCorsRules() {
                return this.jsiiGet("corsRules", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            public void setCorsRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("corsRules", java.util.Objects.requireNonNull(value, "corsRules is required"));
            }

            /**
             * ``CfnBucket.CorsConfigurationProperty.CorsRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            public void setCorsRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("corsRules", java.util.Objects.requireNonNull(value, "corsRules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        java.lang.Object getAllowedMethods();
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        void setAllowedMethods(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedMethods``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        void setAllowedMethods(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        java.lang.Object getAllowedOrigins();
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        void setAllowedOrigins(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedOrigins``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        void setAllowedOrigins(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        java.lang.Object getAllowedHeaders();
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        void setAllowedHeaders(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.CorsRuleProperty.AllowedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        void setAllowedHeaders(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        java.lang.Object getExposedHeaders();
        /**
         * ``CfnBucket.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        void setExposedHeaders(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.CorsRuleProperty.ExposedHeaders``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        void setExposedHeaders(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        java.lang.String getId();
        /**
         * ``CfnBucket.CorsRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        void setId(final java.lang.String value);
        /**
         * ``CfnBucket.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        java.lang.Object getMaxAge();
        /**
         * ``CfnBucket.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        void setMaxAge(final java.lang.Number value);
        /**
         * ``CfnBucket.CorsRuleProperty.MaxAge``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        void setMaxAge(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsRuleProperty}
         */
        final class Builder {
            private java.lang.Object _allowedMethods;
            private java.lang.Object _allowedOrigins;
            @javax.annotation.Nullable
            private java.lang.Object _allowedHeaders;
            @javax.annotation.Nullable
            private java.lang.Object _exposedHeaders;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _maxAge;

            /**
             * Sets the value of AllowedMethods
             * @param value ``CfnBucket.CorsRuleProperty.AllowedMethods``
             * @return {@code this}
             */
            public Builder withAllowedMethods(final software.amazon.awscdk.Token value) {
                this._allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }
            /**
             * Sets the value of AllowedMethods
             * @param value ``CfnBucket.CorsRuleProperty.AllowedMethods``
             * @return {@code this}
             */
            public Builder withAllowedMethods(final java.util.List<java.lang.Object> value) {
                this._allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }
            /**
             * Sets the value of AllowedOrigins
             * @param value ``CfnBucket.CorsRuleProperty.AllowedOrigins``
             * @return {@code this}
             */
            public Builder withAllowedOrigins(final software.amazon.awscdk.Token value) {
                this._allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }
            /**
             * Sets the value of AllowedOrigins
             * @param value ``CfnBucket.CorsRuleProperty.AllowedOrigins``
             * @return {@code this}
             */
            public Builder withAllowedOrigins(final java.util.List<java.lang.Object> value) {
                this._allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }
            /**
             * Sets the value of AllowedHeaders
             * @param value ``CfnBucket.CorsRuleProperty.AllowedHeaders``
             * @return {@code this}
             */
            public Builder withAllowedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._allowedHeaders = value;
                return this;
            }
            /**
             * Sets the value of AllowedHeaders
             * @param value ``CfnBucket.CorsRuleProperty.AllowedHeaders``
             * @return {@code this}
             */
            public Builder withAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._allowedHeaders = value;
                return this;
            }
            /**
             * Sets the value of ExposedHeaders
             * @param value ``CfnBucket.CorsRuleProperty.ExposedHeaders``
             * @return {@code this}
             */
            public Builder withExposedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._exposedHeaders = value;
                return this;
            }
            /**
             * Sets the value of ExposedHeaders
             * @param value ``CfnBucket.CorsRuleProperty.ExposedHeaders``
             * @return {@code this}
             */
            public Builder withExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._exposedHeaders = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``CfnBucket.CorsRuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of MaxAge
             * @param value ``CfnBucket.CorsRuleProperty.MaxAge``
             * @return {@code this}
             */
            public Builder withMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxAge = value;
                return this;
            }
            /**
             * Sets the value of MaxAge
             * @param value ``CfnBucket.CorsRuleProperty.MaxAge``
             * @return {@code this}
             */
            public Builder withMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxAge = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CorsRuleProperty build() {
                return new CorsRuleProperty() {
                    private java.lang.Object $allowedMethods = java.util.Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                    private java.lang.Object $allowedOrigins = java.util.Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $allowedHeaders = _allowedHeaders;
                    @javax.annotation.Nullable
                    private java.lang.Object $exposedHeaders = _exposedHeaders;
                    @javax.annotation.Nullable
                    private java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxAge = _maxAge;

                    @Override
                    public java.lang.Object getAllowedMethods() {
                        return this.$allowedMethods;
                    }

                    @Override
                    public void setAllowedMethods(final software.amazon.awscdk.Token value) {
                        this.$allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public void setAllowedMethods(final java.util.List<java.lang.Object> value) {
                        this.$allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                    }

                    @Override
                    public java.lang.Object getAllowedOrigins() {
                        return this.$allowedOrigins;
                    }

                    @Override
                    public void setAllowedOrigins(final software.amazon.awscdk.Token value) {
                        this.$allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public void setAllowedOrigins(final java.util.List<java.lang.Object> value) {
                        this.$allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                    }

                    @Override
                    public java.lang.Object getAllowedHeaders() {
                        return this.$allowedHeaders;
                    }

                    @Override
                    public void setAllowedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public void setAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$allowedHeaders = value;
                    }

                    @Override
                    public java.lang.Object getExposedHeaders() {
                        return this.$exposedHeaders;
                    }

                    @Override
                    public void setExposedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public void setExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$exposedHeaders = value;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$id = value;
                    }

                    @Override
                    public java.lang.Object getMaxAge() {
                        return this.$maxAge;
                    }

                    @Override
                    public void setMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$maxAge = value;
                    }

                    @Override
                    public void setMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$maxAge = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.CorsRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            public java.lang.Object getAllowedMethods() {
                return this.jsiiGet("allowedMethods", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            public void setAllowedMethods(final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedMethods", java.util.Objects.requireNonNull(value, "allowedMethods is required"));
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedMethods``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            public void setAllowedMethods(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedMethods", java.util.Objects.requireNonNull(value, "allowedMethods is required"));
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            public java.lang.Object getAllowedOrigins() {
                return this.jsiiGet("allowedOrigins", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            public void setAllowedOrigins(final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedOrigins", java.util.Objects.requireNonNull(value, "allowedOrigins is required"));
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedOrigins``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            public void setAllowedOrigins(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedOrigins", java.util.Objects.requireNonNull(value, "allowedOrigins is required"));
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAllowedHeaders() {
                return this.jsiiGet("allowedHeaders", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            public void setAllowedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("allowedHeaders", value);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.AllowedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            public void setAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("allowedHeaders", value);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExposedHeaders() {
                return this.jsiiGet("exposedHeaders", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            public void setExposedHeaders(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("exposedHeaders", value);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.ExposedHeaders``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            public void setExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("exposedHeaders", value);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxAge() {
                return this.jsiiGet("maxAge", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            public void setMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxAge", value);
            }

            /**
             * ``CfnBucket.CorsRuleProperty.MaxAge``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            public void setMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxAge", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        java.lang.Object getDestination();
        /**
         * ``CfnBucket.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.DataExportProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value);
        /**
         * ``CfnBucket.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        java.lang.String getOutputSchemaVersion();
        /**
         * ``CfnBucket.DataExportProperty.OutputSchemaVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        void setOutputSchemaVersion(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DataExportProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.String _outputSchemaVersion;

            /**
             * Sets the value of Destination
             * @param value ``CfnBucket.DataExportProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value ``CfnBucket.DataExportProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of OutputSchemaVersion
             * @param value ``CfnBucket.DataExportProperty.OutputSchemaVersion``
             * @return {@code this}
             */
            public Builder withOutputSchemaVersion(final java.lang.String value) {
                this._outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DataExportProperty build() {
                return new DataExportProperty() {
                    private java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private java.lang.String $outputSchemaVersion = java.util.Objects.requireNonNull(_outputSchemaVersion, "outputSchemaVersion is required");

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.Token value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public java.lang.String getOutputSchemaVersion() {
                        return this.$outputSchemaVersion;
                    }

                    @Override
                    public void setOutputSchemaVersion(final java.lang.String value) {
                        this.$outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``CfnBucket.DataExportProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``CfnBucket.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            @Override
            public java.lang.String getOutputSchemaVersion() {
                return this.jsiiGet("outputSchemaVersion", java.lang.String.class);
            }

            /**
             * ``CfnBucket.DataExportProperty.OutputSchemaVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            @Override
            public void setOutputSchemaVersion(final java.lang.String value) {
                this.jsiiSet("outputSchemaVersion", java.util.Objects.requireNonNull(value, "outputSchemaVersion is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        java.lang.String getBucketArn();
        /**
         * ``CfnBucket.DestinationProperty.BucketArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        void setBucketArn(final java.lang.String value);
        /**
         * ``CfnBucket.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        java.lang.String getFormat();
        /**
         * ``CfnBucket.DestinationProperty.Format``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        void setFormat(final java.lang.String value);
        /**
         * ``CfnBucket.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        java.lang.String getBucketAccountId();
        /**
         * ``CfnBucket.DestinationProperty.BucketAccountId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        void setBucketAccountId(final java.lang.String value);
        /**
         * ``CfnBucket.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        java.lang.String getPrefix();
        /**
         * ``CfnBucket.DestinationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        void setPrefix(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DestinationProperty}
         */
        final class Builder {
            private java.lang.String _bucketArn;
            private java.lang.String _format;
            @javax.annotation.Nullable
            private java.lang.String _bucketAccountId;
            @javax.annotation.Nullable
            private java.lang.String _prefix;

            /**
             * Sets the value of BucketArn
             * @param value ``CfnBucket.DestinationProperty.BucketArn``
             * @return {@code this}
             */
            public Builder withBucketArn(final java.lang.String value) {
                this._bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }
            /**
             * Sets the value of Format
             * @param value ``CfnBucket.DestinationProperty.Format``
             * @return {@code this}
             */
            public Builder withFormat(final java.lang.String value) {
                this._format = java.util.Objects.requireNonNull(value, "format is required");
                return this;
            }
            /**
             * Sets the value of BucketAccountId
             * @param value ``CfnBucket.DestinationProperty.BucketAccountId``
             * @return {@code this}
             */
            public Builder withBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                this._bucketAccountId = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``CfnBucket.DestinationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DestinationProperty build() {
                return new DestinationProperty() {
                    private java.lang.String $bucketArn = java.util.Objects.requireNonNull(_bucketArn, "bucketArn is required");
                    private java.lang.String $format = java.util.Objects.requireNonNull(_format, "format is required");
                    @javax.annotation.Nullable
                    private java.lang.String $bucketAccountId = _bucketAccountId;
                    @javax.annotation.Nullable
                    private java.lang.String $prefix = _prefix;

                    @Override
                    public java.lang.String getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public void setBucketArn(final java.lang.String value) {
                        this.$bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                    }

                    @Override
                    public java.lang.String getFormat() {
                        return this.$format;
                    }

                    @Override
                    public void setFormat(final java.lang.String value) {
                        this.$format = java.util.Objects.requireNonNull(value, "format is required");
                    }

                    @Override
                    public java.lang.String getBucketAccountId() {
                        return this.$bucketAccountId;
                    }

                    @Override
                    public void setBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$bucketAccountId = value;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            @Override
            public java.lang.String getBucketArn() {
                return this.jsiiGet("bucketArn", java.lang.String.class);
            }

            /**
             * ``CfnBucket.DestinationProperty.BucketArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            @Override
            public void setBucketArn(final java.lang.String value) {
                this.jsiiSet("bucketArn", java.util.Objects.requireNonNull(value, "bucketArn is required"));
            }

            /**
             * ``CfnBucket.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            @Override
            public java.lang.String getFormat() {
                return this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * ``CfnBucket.DestinationProperty.Format``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            @Override
            public void setFormat(final java.lang.String value) {
                this.jsiiSet("format", java.util.Objects.requireNonNull(value, "format is required"));
            }

            /**
             * ``CfnBucket.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getBucketAccountId() {
                return this.jsiiGet("bucketAccountId", java.lang.String.class);
            }

            /**
             * ``CfnBucket.DestinationProperty.BucketAccountId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @Override
            public void setBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bucketAccountId", value);
            }

            /**
             * ``CfnBucket.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * ``CfnBucket.DestinationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        java.lang.String getReplicaKmsKeyId();
        /**
         * ``CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        void setReplicaKmsKeyId(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _replicaKmsKeyId;

            /**
             * Sets the value of ReplicaKmsKeyId
             * @param value ``CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @return {@code this}
             */
            public Builder withReplicaKmsKeyId(final java.lang.String value) {
                this._replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EncryptionConfigurationProperty build() {
                return new EncryptionConfigurationProperty() {
                    private java.lang.String $replicaKmsKeyId = java.util.Objects.requireNonNull(_replicaKmsKeyId, "replicaKmsKeyId is required");

                    @Override
                    public java.lang.String getReplicaKmsKeyId() {
                        return this.$replicaKmsKeyId;
                    }

                    @Override
                    public void setReplicaKmsKeyId(final java.lang.String value) {
                        this.$replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            @Override
            public java.lang.String getReplicaKmsKeyId() {
                return this.jsiiGet("replicaKmsKeyId", java.lang.String.class);
            }

            /**
             * ``CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            @Override
            public void setReplicaKmsKeyId(final java.lang.String value) {
                this.jsiiSet("replicaKmsKeyId", java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        java.lang.String getName();
        /**
         * ``CfnBucket.FilterRuleProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        void setName(final java.lang.String value);
        /**
         * ``CfnBucket.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        java.lang.String getValue();
        /**
         * ``CfnBucket.FilterRuleProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        void setValue(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FilterRuleProperty}
         */
        final class Builder {
            private java.lang.String _name;
            private java.lang.String _value;

            /**
             * Sets the value of Name
             * @param value ``CfnBucket.FilterRuleProperty.Name``
             * @return {@code this}
             */
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``CfnBucket.FilterRuleProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FilterRuleProperty build() {
                return new FilterRuleProperty() {
                    private java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private java.lang.String $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(final java.lang.String value) {
                        this.$name = java.util.Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(final java.lang.String value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.FilterRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            @Override
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * ``CfnBucket.FilterRuleProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            @Override
            public void setName(final java.lang.String value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }

            /**
             * ``CfnBucket.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            @Override
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * ``CfnBucket.FilterRuleProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            @Override
            public void setValue(final java.lang.String value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        java.lang.Object getDestination();
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        java.lang.String getId();
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        java.lang.String getIncludedObjectVersions();
        /**
         * ``CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        void setIncludedObjectVersions(final java.lang.String value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        java.lang.String getScheduleFrequency();
        /**
         * ``CfnBucket.InventoryConfigurationProperty.ScheduleFrequency``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        void setScheduleFrequency(final java.lang.String value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        java.lang.Object getOptionalFields();
        /**
         * ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        void setOptionalFields(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        void setOptionalFields(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        java.lang.String getPrefix();
        /**
         * ``CfnBucket.InventoryConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link InventoryConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InventoryConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.Object _enabled;
            private java.lang.String _id;
            private java.lang.String _includedObjectVersions;
            private java.lang.String _scheduleFrequency;
            @javax.annotation.Nullable
            private java.lang.Object _optionalFields;
            @javax.annotation.Nullable
            private java.lang.String _prefix;

            /**
             * Sets the value of Destination
             * @param value ``CfnBucket.InventoryConfigurationProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value ``CfnBucket.InventoryConfigurationProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnBucket.InventoryConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnBucket.InventoryConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``CfnBucket.InventoryConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of IncludedObjectVersions
             * @param value ``CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions``
             * @return {@code this}
             */
            public Builder withIncludedObjectVersions(final java.lang.String value) {
                this._includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }
            /**
             * Sets the value of ScheduleFrequency
             * @param value ``CfnBucket.InventoryConfigurationProperty.ScheduleFrequency``
             * @return {@code this}
             */
            public Builder withScheduleFrequency(final java.lang.String value) {
                this._scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }
            /**
             * Sets the value of OptionalFields
             * @param value ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
             * @return {@code this}
             */
            public Builder withOptionalFields(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._optionalFields = value;
                return this;
            }
            /**
             * Sets the value of OptionalFields
             * @param value ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
             * @return {@code this}
             */
            public Builder withOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._optionalFields = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``CfnBucket.InventoryConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InventoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InventoryConfigurationProperty build() {
                return new InventoryConfigurationProperty() {
                    private java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");
                    private java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private java.lang.String $includedObjectVersions = java.util.Objects.requireNonNull(_includedObjectVersions, "includedObjectVersions is required");
                    private java.lang.String $scheduleFrequency = java.util.Objects.requireNonNull(_scheduleFrequency, "scheduleFrequency is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $optionalFields = _optionalFields;
                    @javax.annotation.Nullable
                    private java.lang.String $prefix = _prefix;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.Token value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(final java.lang.Boolean value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public void setEnabled(final software.amazon.awscdk.Token value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(final java.lang.String value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public java.lang.String getIncludedObjectVersions() {
                        return this.$includedObjectVersions;
                    }

                    @Override
                    public void setIncludedObjectVersions(final java.lang.String value) {
                        this.$includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                    }

                    @Override
                    public java.lang.String getScheduleFrequency() {
                        return this.$scheduleFrequency;
                    }

                    @Override
                    public void setScheduleFrequency(final java.lang.String value) {
                        this.$scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                    }

                    @Override
                    public java.lang.Object getOptionalFields() {
                        return this.$optionalFields;
                    }

                    @Override
                    public void setOptionalFields(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public void setOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$optionalFields = value;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.InventoryConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            public void setEnabled(final java.lang.Boolean value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            @Override
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            @Override
            public java.lang.String getIncludedObjectVersions() {
                return this.jsiiGet("includedObjectVersions", java.lang.String.class);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            @Override
            public void setIncludedObjectVersions(final java.lang.String value) {
                this.jsiiSet("includedObjectVersions", java.util.Objects.requireNonNull(value, "includedObjectVersions is required"));
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            @Override
            public java.lang.String getScheduleFrequency() {
                return this.jsiiGet("scheduleFrequency", java.lang.String.class);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.ScheduleFrequency``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            @Override
            public void setScheduleFrequency(final java.lang.String value) {
                this.jsiiSet("scheduleFrequency", java.util.Objects.requireNonNull(value, "scheduleFrequency is required"));
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOptionalFields() {
                return this.jsiiGet("optionalFields", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            public void setOptionalFields(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("optionalFields", value);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.OptionalFields``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            public void setOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("optionalFields", value);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * ``CfnBucket.InventoryConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        java.lang.String getEvent();
        /**
         * ``CfnBucket.LambdaConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``CfnBucket.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        java.lang.String getFunction();
        /**
         * ``CfnBucket.LambdaConfigurationProperty.Function``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        void setFunction(final java.lang.String value);
        /**
         * ``CfnBucket.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``CfnBucket.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.LambdaConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value);

        /**
         * @return a {@link Builder} of {@link LambdaConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LambdaConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _function;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value ``CfnBucket.LambdaConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Function
             * @param value ``CfnBucket.LambdaConfigurationProperty.Function``
             * @return {@code this}
             */
            public Builder withFunction(final java.lang.String value) {
                this._function = java.util.Objects.requireNonNull(value, "function is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``CfnBucket.LambdaConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``CfnBucket.LambdaConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LambdaConfigurationProperty build() {
                return new LambdaConfigurationProperty() {
                    private java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private java.lang.String $function = java.util.Objects.requireNonNull(_function, "function is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(final java.lang.String value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public java.lang.String getFunction() {
                        return this.$function;
                    }

                    @Override
                    public void setFunction(final java.lang.String value) {
                        this.$function = java.util.Objects.requireNonNull(value, "function is required");
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                        this.$filter = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LambdaConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            @Override
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * ``CfnBucket.LambdaConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            @Override
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``CfnBucket.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            @Override
            public java.lang.String getFunction() {
                return this.jsiiGet("function", java.lang.String.class);
            }

            /**
             * ``CfnBucket.LambdaConfigurationProperty.Function``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            @Override
            public void setFunction(final java.lang.String value) {
                this.jsiiSet("function", java.util.Objects.requireNonNull(value, "function is required"));
            }

            /**
             * ``CfnBucket.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }

            /**
             * ``CfnBucket.LambdaConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        java.lang.Object getRules();
        /**
         * ``CfnBucket.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.LifecycleConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value ``CfnBucket.LifecycleConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``CfnBucket.LifecycleConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LifecycleConfigurationProperty build() {
                return new LifecycleConfigurationProperty() {
                    private java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(final software.amazon.awscdk.Token value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(final java.util.List<java.lang.Object> value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }

            /**
             * ``CfnBucket.LifecycleConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        java.lang.String getDestinationBucketName();
        /**
         * ``CfnBucket.LoggingConfigurationProperty.DestinationBucketName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        void setDestinationBucketName(final java.lang.String value);
        /**
         * ``CfnBucket.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        java.lang.String getLogFilePrefix();
        /**
         * ``CfnBucket.LoggingConfigurationProperty.LogFilePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        void setLogFilePrefix(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _destinationBucketName;
            @javax.annotation.Nullable
            private java.lang.String _logFilePrefix;

            /**
             * Sets the value of DestinationBucketName
             * @param value ``CfnBucket.LoggingConfigurationProperty.DestinationBucketName``
             * @return {@code this}
             */
            public Builder withDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationBucketName = value;
                return this;
            }
            /**
             * Sets the value of LogFilePrefix
             * @param value ``CfnBucket.LoggingConfigurationProperty.LogFilePrefix``
             * @return {@code this}
             */
            public Builder withLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._logFilePrefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoggingConfigurationProperty build() {
                return new LoggingConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $destinationBucketName = _destinationBucketName;
                    @javax.annotation.Nullable
                    private java.lang.String $logFilePrefix = _logFilePrefix;

                    @Override
                    public java.lang.String getDestinationBucketName() {
                        return this.$destinationBucketName;
                    }

                    @Override
                    public void setDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$destinationBucketName = value;
                    }

                    @Override
                    public java.lang.String getLogFilePrefix() {
                        return this.$logFilePrefix;
                    }

                    @Override
                    public void setLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$logFilePrefix = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDestinationBucketName() {
                return this.jsiiGet("destinationBucketName", java.lang.String.class);
            }

            /**
             * ``CfnBucket.LoggingConfigurationProperty.DestinationBucketName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @Override
            public void setDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationBucketName", value);
            }

            /**
             * ``CfnBucket.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLogFilePrefix() {
                return this.jsiiGet("logFilePrefix", java.lang.String.class);
            }

            /**
             * ``CfnBucket.LoggingConfigurationProperty.LogFilePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @Override
            public void setLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("logFilePrefix", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        java.lang.String getId();
        /**
         * ``CfnBucket.MetricsConfigurationProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        void setId(final java.lang.String value);
        /**
         * ``CfnBucket.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        java.lang.String getPrefix();
        /**
         * ``CfnBucket.MetricsConfigurationProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``CfnBucket.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``CfnBucket.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.MetricsConfigurationProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link MetricsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MetricsConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value ``CfnBucket.MetricsConfigurationProperty.Id``
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``CfnBucket.MetricsConfigurationProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``CfnBucket.MetricsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``CfnBucket.MetricsConfigurationProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MetricsConfigurationProperty build() {
                return new MetricsConfigurationProperty() {
                    private java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    @javax.annotation.Nullable
                    private java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(final java.lang.String value) {
                        this.$id = java.util.Objects.requireNonNull(value, "id is required");
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagFilters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.MetricsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * ``CfnBucket.MetricsConfigurationProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            @Override
            public void setId(final java.lang.String value) {
                this.jsiiSet("id", java.util.Objects.requireNonNull(value, "id is required"));
            }

            /**
             * ``CfnBucket.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * ``CfnBucket.MetricsConfigurationProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``CfnBucket.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``CfnBucket.MetricsConfigurationProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        java.lang.String getStorageClass();
        /**
         * ``CfnBucket.NoncurrentVersionTransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        java.lang.Object getTransitionInDays();
        /**
         * ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        void setTransitionInDays(final java.lang.Number value);
        /**
         * ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        void setTransitionInDays(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionTransitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NoncurrentVersionTransitionProperty}
         */
        final class Builder {
            private java.lang.String _storageClass;
            private java.lang.Object _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value ``CfnBucket.NoncurrentVersionTransitionProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(final java.lang.Number value) {
                this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(final software.amazon.awscdk.Token value) {
                this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NoncurrentVersionTransitionProperty build() {
                return new NoncurrentVersionTransitionProperty() {
                    private java.lang.String $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    private java.lang.Object $transitionInDays = java.util.Objects.requireNonNull(_transitionInDays, "transitionInDays is required");

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(final java.lang.String value) {
                        this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public java.lang.Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(final java.lang.Number value) {
                        this.$transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                    }

                    @Override
                    public void setTransitionInDays(final software.amazon.awscdk.Token value) {
                        this.$transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            @Override
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * ``CfnBucket.NoncurrentVersionTransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            @Override
            public void setStorageClass(final java.lang.String value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }

            /**
             * ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            public void setTransitionInDays(final java.lang.Number value) {
                this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
            }

            /**
             * ``CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            public void setTransitionInDays(final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionInDays", java.util.Objects.requireNonNull(value, "transitionInDays is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        java.lang.Object getLambdaConfigurations();
        /**
         * ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        void setLambdaConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        void setLambdaConfigurations(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        java.lang.Object getQueueConfigurations();
        /**
         * ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        void setQueueConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        void setQueueConfigurations(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        java.lang.Object getTopicConfigurations();
        /**
         * ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        void setTopicConfigurations(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        void setTopicConfigurations(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _lambdaConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _queueConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _topicConfigurations;

            /**
             * Sets the value of LambdaConfigurations
             * @param value ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
             * @return {@code this}
             */
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of LambdaConfigurations
             * @param value ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
             * @return {@code this}
             */
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
             * @return {@code this}
             */
            public Builder withQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
             * @return {@code this}
             */
            public Builder withQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
             * @return {@code this}
             */
            public Builder withTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._topicConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
             * @return {@code this}
             */
            public Builder withTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._topicConfigurations = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NotificationConfigurationProperty build() {
                return new NotificationConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $lambdaConfigurations = _lambdaConfigurations;
                    @javax.annotation.Nullable
                    private java.lang.Object $queueConfigurations = _queueConfigurations;
                    @javax.annotation.Nullable
                    private java.lang.Object $topicConfigurations = _topicConfigurations;

                    @Override
                    public java.lang.Object getLambdaConfigurations() {
                        return this.$lambdaConfigurations;
                    }

                    @Override
                    public void setLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public void setLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$lambdaConfigurations = value;
                    }

                    @Override
                    public java.lang.Object getQueueConfigurations() {
                        return this.$queueConfigurations;
                    }

                    @Override
                    public void setQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public void setQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$queueConfigurations = value;
                    }

                    @Override
                    public java.lang.Object getTopicConfigurations() {
                        return this.$topicConfigurations;
                    }

                    @Override
                    public void setTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$topicConfigurations = value;
                    }

                    @Override
                    public void setTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$topicConfigurations = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLambdaConfigurations() {
                return this.jsiiGet("lambdaConfigurations", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            public void setLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("lambdaConfigurations", value);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.LambdaConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            public void setLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("lambdaConfigurations", value);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getQueueConfigurations() {
                return this.jsiiGet("queueConfigurations", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            public void setQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("queueConfigurations", value);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.QueueConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            public void setQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("queueConfigurations", value);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTopicConfigurations() {
                return this.jsiiGet("topicConfigurations", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            public void setTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("topicConfigurations", value);
            }

            /**
             * ``CfnBucket.NotificationConfigurationProperty.TopicConfigurations``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            public void setTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("topicConfigurations", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        java.lang.Object getS3Key();
        /**
         * ``CfnBucket.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        void setS3Key(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.NotificationFilterProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        void setS3Key(final software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty value);

        /**
         * @return a {@link Builder} of {@link NotificationFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationFilterProperty}
         */
        final class Builder {
            private java.lang.Object _s3Key;

            /**
             * Sets the value of S3Key
             * @param value ``CfnBucket.NotificationFilterProperty.S3Key``
             * @return {@code this}
             */
            public Builder withS3Key(final software.amazon.awscdk.Token value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value ``CfnBucket.NotificationFilterProperty.S3Key``
             * @return {@code this}
             */
            public Builder withS3Key(final software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NotificationFilterProperty build() {
                return new NotificationFilterProperty() {
                    private java.lang.Object $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.Object getS3Key() {
                        return this.$s3Key;
                    }

                    @Override
                    public void setS3Key(final software.amazon.awscdk.Token value) {
                        this.$s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                    }

                    @Override
                    public void setS3Key(final software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty value) {
                        this.$s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            public java.lang.Object getS3Key() {
                return this.jsiiGet("s3Key", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            public void setS3Key(final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }

            /**
             * ``CfnBucket.NotificationFilterProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            public void setS3Key(final software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        java.lang.Object getBlockPublicAcls();
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        void setBlockPublicAcls(final java.lang.Boolean value);
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        void setBlockPublicAcls(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        java.lang.Object getBlockPublicPolicy();
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        void setBlockPublicPolicy(final java.lang.Boolean value);
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        void setBlockPublicPolicy(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        java.lang.Object getIgnorePublicAcls();
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        void setIgnorePublicAcls(final java.lang.Boolean value);
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        void setIgnorePublicAcls(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        java.lang.Object getRestrictPublicBuckets();
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        void setRestrictPublicBuckets(final java.lang.Boolean value);
        /**
         * ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        void setRestrictPublicBuckets(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _ignorePublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _restrictPublicBuckets;

            /**
             * Sets the value of BlockPublicAcls
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @return {@code this}
             */
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicAcls
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @return {@code this}
             */
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @return {@code this}
             */
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @return {@code this}
             */
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @return {@code this}
             */
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @return {@code this}
             */
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @return {@code this}
             */
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._restrictPublicBuckets = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @return {@code this}
             */
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PublicAccessBlockConfigurationProperty build() {
                return new PublicAccessBlockConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $blockPublicAcls = _blockPublicAcls;
                    @javax.annotation.Nullable
                    private java.lang.Object $blockPublicPolicy = _blockPublicPolicy;
                    @javax.annotation.Nullable
                    private java.lang.Object $ignorePublicAcls = _ignorePublicAcls;
                    @javax.annotation.Nullable
                    private java.lang.Object $restrictPublicBuckets = _restrictPublicBuckets;

                    @Override
                    public java.lang.Object getBlockPublicAcls() {
                        return this.$blockPublicAcls;
                    }

                    @Override
                    public void setBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$blockPublicAcls = value;
                    }

                    @Override
                    public void setBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$blockPublicAcls = value;
                    }

                    @Override
                    public java.lang.Object getBlockPublicPolicy() {
                        return this.$blockPublicPolicy;
                    }

                    @Override
                    public void setBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$blockPublicPolicy = value;
                    }

                    @Override
                    public void setBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$blockPublicPolicy = value;
                    }

                    @Override
                    public java.lang.Object getIgnorePublicAcls() {
                        return this.$ignorePublicAcls;
                    }

                    @Override
                    public void setIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ignorePublicAcls = value;
                    }

                    @Override
                    public void setIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ignorePublicAcls = value;
                    }

                    @Override
                    public java.lang.Object getRestrictPublicBuckets() {
                        return this.$restrictPublicBuckets;
                    }

                    @Override
                    public void setRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$restrictPublicBuckets = value;
                    }

                    @Override
                    public void setRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$restrictPublicBuckets = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicAcls() {
                return this.jsiiGet("blockPublicAcls", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            public void setBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("blockPublicAcls", value);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            public void setBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockPublicAcls", value);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicPolicy() {
                return this.jsiiGet("blockPublicPolicy", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            public void setBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("blockPublicPolicy", value);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            public void setBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockPublicPolicy", value);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePublicAcls() {
                return this.jsiiGet("ignorePublicAcls", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            public void setIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignorePublicAcls", value);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            public void setIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ignorePublicAcls", value);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRestrictPublicBuckets() {
                return this.jsiiGet("restrictPublicBuckets", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            public void setRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("restrictPublicBuckets", value);
            }

            /**
             * ``CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            public void setRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("restrictPublicBuckets", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        java.lang.String getEvent();
        /**
         * ``CfnBucket.QueueConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``CfnBucket.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        java.lang.String getQueue();
        /**
         * ``CfnBucket.QueueConfigurationProperty.Queue``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        void setQueue(final java.lang.String value);
        /**
         * ``CfnBucket.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``CfnBucket.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.QueueConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value);

        /**
         * @return a {@link Builder} of {@link QueueConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueueConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _queue;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value ``CfnBucket.QueueConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Queue
             * @param value ``CfnBucket.QueueConfigurationProperty.Queue``
             * @return {@code this}
             */
            public Builder withQueue(final java.lang.String value) {
                this._queue = java.util.Objects.requireNonNull(value, "queue is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``CfnBucket.QueueConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``CfnBucket.QueueConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public QueueConfigurationProperty build() {
                return new QueueConfigurationProperty() {
                    private java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private java.lang.String $queue = java.util.Objects.requireNonNull(_queue, "queue is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(final java.lang.String value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public java.lang.String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public void setQueue(final java.lang.String value) {
                        this.$queue = java.util.Objects.requireNonNull(value, "queue is required");
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                        this.$filter = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.QueueConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            @Override
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * ``CfnBucket.QueueConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            @Override
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``CfnBucket.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            @Override
            public java.lang.String getQueue() {
                return this.jsiiGet("queue", java.lang.String.class);
            }

            /**
             * ``CfnBucket.QueueConfigurationProperty.Queue``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            @Override
            public void setQueue(final java.lang.String value) {
                this.jsiiSet("queue", java.util.Objects.requireNonNull(value, "queue is required"));
            }

            /**
             * ``CfnBucket.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }

            /**
             * ``CfnBucket.QueueConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        java.lang.String getHostName();
        /**
         * ``CfnBucket.RedirectAllRequestsToProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        void setHostName(final java.lang.String value);
        /**
         * ``CfnBucket.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        java.lang.String getProtocol();
        /**
         * ``CfnBucket.RedirectAllRequestsToProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        void setProtocol(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link RedirectAllRequestsToProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectAllRequestsToProperty}
         */
        final class Builder {
            private java.lang.String _hostName;
            @javax.annotation.Nullable
            private java.lang.String _protocol;

            /**
             * Sets the value of HostName
             * @param value ``CfnBucket.RedirectAllRequestsToProperty.HostName``
             * @return {@code this}
             */
            public Builder withHostName(final java.lang.String value) {
                this._hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``CfnBucket.RedirectAllRequestsToProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectAllRequestsToProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectAllRequestsToProperty build() {
                return new RedirectAllRequestsToProperty() {
                    private java.lang.String $hostName = java.util.Objects.requireNonNull(_hostName, "hostName is required");
                    @javax.annotation.Nullable
                    private java.lang.String $protocol = _protocol;

                    @Override
                    public java.lang.String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(final java.lang.String value) {
                        this.$hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                        this.$protocol = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            @Override
            public java.lang.String getHostName() {
                return this.jsiiGet("hostName", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RedirectAllRequestsToProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            @Override
            public void setHostName(final java.lang.String value) {
                this.jsiiSet("hostName", java.util.Objects.requireNonNull(value, "hostName is required"));
            }

            /**
             * ``CfnBucket.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RedirectAllRequestsToProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("protocol", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        java.lang.String getHostName();
        /**
         * ``CfnBucket.RedirectRuleProperty.HostName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        void setHostName(final java.lang.String value);
        /**
         * ``CfnBucket.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        java.lang.String getHttpRedirectCode();
        /**
         * ``CfnBucket.RedirectRuleProperty.HttpRedirectCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        void setHttpRedirectCode(final java.lang.String value);
        /**
         * ``CfnBucket.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        java.lang.String getProtocol();
        /**
         * ``CfnBucket.RedirectRuleProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        void setProtocol(final java.lang.String value);
        /**
         * ``CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        java.lang.String getReplaceKeyPrefixWith();
        /**
         * ``CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        void setReplaceKeyPrefixWith(final java.lang.String value);
        /**
         * ``CfnBucket.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        java.lang.String getReplaceKeyWith();
        /**
         * ``CfnBucket.RedirectRuleProperty.ReplaceKeyWith``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        void setReplaceKeyWith(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link RedirectRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _hostName;
            @javax.annotation.Nullable
            private java.lang.String _httpRedirectCode;
            @javax.annotation.Nullable
            private java.lang.String _protocol;
            @javax.annotation.Nullable
            private java.lang.String _replaceKeyPrefixWith;
            @javax.annotation.Nullable
            private java.lang.String _replaceKeyWith;

            /**
             * Sets the value of HostName
             * @param value ``CfnBucket.RedirectRuleProperty.HostName``
             * @return {@code this}
             */
            public Builder withHostName(@javax.annotation.Nullable final java.lang.String value) {
                this._hostName = value;
                return this;
            }
            /**
             * Sets the value of HttpRedirectCode
             * @param value ``CfnBucket.RedirectRuleProperty.HttpRedirectCode``
             * @return {@code this}
             */
            public Builder withHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                this._httpRedirectCode = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``CfnBucket.RedirectRuleProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyPrefixWith
             * @param value ``CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @return {@code this}
             */
            public Builder withReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyWith
             * @param value ``CfnBucket.RedirectRuleProperty.ReplaceKeyWith``
             * @return {@code this}
             */
            public Builder withReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyWith = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectRuleProperty build() {
                return new RedirectRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $hostName = _hostName;
                    @javax.annotation.Nullable
                    private java.lang.String $httpRedirectCode = _httpRedirectCode;
                    @javax.annotation.Nullable
                    private java.lang.String $protocol = _protocol;
                    @javax.annotation.Nullable
                    private java.lang.String $replaceKeyPrefixWith = _replaceKeyPrefixWith;
                    @javax.annotation.Nullable
                    private java.lang.String $replaceKeyWith = _replaceKeyWith;

                    @Override
                    public java.lang.String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public void setHostName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$hostName = value;
                    }

                    @Override
                    public java.lang.String getHttpRedirectCode() {
                        return this.$httpRedirectCode;
                    }

                    @Override
                    public void setHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                        this.$httpRedirectCode = value;
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                        this.$protocol = value;
                    }

                    @Override
                    public java.lang.String getReplaceKeyPrefixWith() {
                        return this.$replaceKeyPrefixWith;
                    }

                    @Override
                    public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                        this.$replaceKeyPrefixWith = value;
                    }

                    @Override
                    public java.lang.String getReplaceKeyWith() {
                        return this.$replaceKeyWith;
                    }

                    @Override
                    public void setReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                        this.$replaceKeyWith = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHostName() {
                return this.jsiiGet("hostName", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.HostName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @Override
            public void setHostName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("hostName", value);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHttpRedirectCode() {
                return this.jsiiGet("httpRedirectCode", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.HttpRedirectCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @Override
            public void setHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpRedirectCode", value);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("protocol", value);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getReplaceKeyPrefixWith() {
                return this.jsiiGet("replaceKeyPrefixWith", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @Override
            public void setReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("replaceKeyPrefixWith", value);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getReplaceKeyWith() {
                return this.jsiiGet("replaceKeyWith", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RedirectRuleProperty.ReplaceKeyWith``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @Override
            public void setReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("replaceKeyWith", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        java.lang.String getRole();
        /**
         * ``CfnBucket.ReplicationConfigurationProperty.Role``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        void setRole(final java.lang.String value);
        /**
         * ``CfnBucket.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        java.lang.Object getRules();
        /**
         * ``CfnBucket.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.ReplicationConfigurationProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _role;
            private java.lang.Object _rules;

            /**
             * Sets the value of Role
             * @param value ``CfnBucket.ReplicationConfigurationProperty.Role``
             * @return {@code this}
             */
            public Builder withRole(final java.lang.String value) {
                this._role = java.util.Objects.requireNonNull(value, "role is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``CfnBucket.ReplicationConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``CfnBucket.ReplicationConfigurationProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationConfigurationProperty build() {
                return new ReplicationConfigurationProperty() {
                    private java.lang.String $role = java.util.Objects.requireNonNull(_role, "role is required");
                    private java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.String getRole() {
                        return this.$role;
                    }

                    @Override
                    public void setRole(final java.lang.String value) {
                        this.$role = java.util.Objects.requireNonNull(value, "role is required");
                    }

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(final software.amazon.awscdk.Token value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(final java.util.List<java.lang.Object> value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            @Override
            public java.lang.String getRole() {
                return this.jsiiGet("role", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ReplicationConfigurationProperty.Role``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            @Override
            public void setRole(final java.lang.String value) {
                this.jsiiSet("role", java.util.Objects.requireNonNull(value, "role is required"));
            }

            /**
             * ``CfnBucket.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }

            /**
             * ``CfnBucket.ReplicationConfigurationProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        java.lang.String getBucket();
        /**
         * ``CfnBucket.ReplicationDestinationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        java.lang.Object getAccessControlTranslation();
        /**
         * ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        void setAccessControlTranslation(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        void setAccessControlTranslation(final software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty value);
        /**
         * ``CfnBucket.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        java.lang.String getAccount();
        /**
         * ``CfnBucket.ReplicationDestinationProperty.Account``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        void setAccount(final java.lang.String value);
        /**
         * ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        java.lang.Object getEncryptionConfiguration();
        /**
         * ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        void setEncryptionConfiguration(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        void setEncryptionConfiguration(final software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty value);
        /**
         * ``CfnBucket.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        java.lang.String getStorageClass();
        /**
         * ``CfnBucket.ReplicationDestinationProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        void setStorageClass(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        final class Builder {
            private java.lang.String _bucket;
            @javax.annotation.Nullable
            private java.lang.Object _accessControlTranslation;
            @javax.annotation.Nullable
            private java.lang.String _account;
            @javax.annotation.Nullable
            private java.lang.Object _encryptionConfiguration;
            @javax.annotation.Nullable
            private java.lang.String _storageClass;

            /**
             * Sets the value of Bucket
             * @param value ``CfnBucket.ReplicationDestinationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
             * @return {@code this}
             */
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
             * @return {@code this}
             */
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of Account
             * @param value ``CfnBucket.ReplicationDestinationProperty.Account``
             * @return {@code this}
             */
            public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
                this._account = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
             * @return {@code this}
             */
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of StorageClass
             * @param value ``CfnBucket.ReplicationDestinationProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                this._storageClass = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationDestinationProperty build() {
                return new ReplicationDestinationProperty() {
                    private java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $accessControlTranslation = _accessControlTranslation;
                    @javax.annotation.Nullable
                    private java.lang.String $account = _account;
                    @javax.annotation.Nullable
                    private java.lang.Object $encryptionConfiguration = _encryptionConfiguration;
                    @javax.annotation.Nullable
                    private java.lang.String $storageClass = _storageClass;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public void setBucket(final java.lang.String value) {
                        this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public java.lang.Object getAccessControlTranslation() {
                        return this.$accessControlTranslation;
                    }

                    @Override
                    public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty value) {
                        this.$accessControlTranslation = value;
                    }

                    @Override
                    public java.lang.String getAccount() {
                        return this.$account;
                    }

                    @Override
                    public void setAccount(@javax.annotation.Nullable final java.lang.String value) {
                        this.$account = value;
                    }

                    @Override
                    public java.lang.Object getEncryptionConfiguration() {
                        return this.$encryptionConfiguration;
                    }

                    @Override
                    public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty value) {
                        this.$encryptionConfiguration = value;
                    }

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                        this.$storageClass = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            @Override
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            @Override
            public void setBucket(final java.lang.String value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAccessControlTranslation() {
                return this.jsiiGet("accessControlTranslation", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("accessControlTranslation", value);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.AccessControlTranslation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            public void setAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty value) {
                this.jsiiSet("accessControlTranslation", value);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAccount() {
                return this.jsiiGet("account", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.Account``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @Override
            public void setAccount(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("account", value);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncryptionConfiguration() {
                return this.jsiiGet("encryptionConfiguration", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encryptionConfiguration", value);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            public void setEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty value) {
                this.jsiiSet("encryptionConfiguration", value);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ReplicationDestinationProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @Override
            public void setStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("storageClass", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        java.lang.Object getDestination();
        /**
         * ``CfnBucket.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        void setDestination(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.ReplicationRuleProperty.Destination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty value);
        /**
         * ``CfnBucket.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        java.lang.String getPrefix();
        /**
         * ``CfnBucket.ReplicationRuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``CfnBucket.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        java.lang.String getStatus();
        /**
         * ``CfnBucket.ReplicationRuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``CfnBucket.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        java.lang.String getId();
        /**
         * ``CfnBucket.ReplicationRuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        void setId(final java.lang.String value);
        /**
         * ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        java.lang.Object getSourceSelectionCriteria();
        /**
         * ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        void setSourceSelectionCriteria(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        void setSourceSelectionCriteria(final software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty value);

        /**
         * @return a {@link Builder} of {@link ReplicationRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationRuleProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.String _prefix;
            private java.lang.String _status;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _sourceSelectionCriteria;

            /**
             * Sets the value of Destination
             * @param value ``CfnBucket.ReplicationRuleProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value ``CfnBucket.ReplicationRuleProperty.Destination``
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``CfnBucket.ReplicationRuleProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(final java.lang.String value) {
                this._prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``CfnBucket.ReplicationRuleProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``CfnBucket.ReplicationRuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
             * @return {@code this}
             */
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sourceSelectionCriteria = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
             * @return {@code this}
             */
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationRuleProperty build() {
                return new ReplicationRuleProperty() {
                    private java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private java.lang.String $prefix = java.util.Objects.requireNonNull(_prefix, "prefix is required");
                    private java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private java.lang.Object $sourceSelectionCriteria = _sourceSelectionCriteria;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.Token value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty value) {
                        this.$destination = java.util.Objects.requireNonNull(value, "destination is required");
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(final java.lang.String value) {
                        this.$prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                    }

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$id = value;
                    }

                    @Override
                    public java.lang.Object getSourceSelectionCriteria() {
                        return this.$sourceSelectionCriteria;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sourceSelectionCriteria = value;
                    }

                    @Override
                    public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty value) {
                        this.$sourceSelectionCriteria = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.Token value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Destination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            public void setDestination(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty value) {
                this.jsiiSet("destination", java.util.Objects.requireNonNull(value, "destination is required"));
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            @Override
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            @Override
            public void setPrefix(final java.lang.String value) {
                this.jsiiSet("prefix", java.util.Objects.requireNonNull(value, "prefix is required"));
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSourceSelectionCriteria() {
                return this.jsiiGet("sourceSelectionCriteria", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSelectionCriteria", value);
            }

            /**
             * ``CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            public void setSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty value) {
                this.jsiiSet("sourceSelectionCriteria", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        java.lang.String getHttpErrorCodeReturnedEquals();
        /**
         * ``CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        void setHttpErrorCodeReturnedEquals(final java.lang.String value);
        /**
         * ``CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        java.lang.String getKeyPrefixEquals();
        /**
         * ``CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        void setKeyPrefixEquals(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link RoutingRuleConditionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleConditionProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _httpErrorCodeReturnedEquals;
            @javax.annotation.Nullable
            private java.lang.String _keyPrefixEquals;

            /**
             * Sets the value of HttpErrorCodeReturnedEquals
             * @param value ``CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @return {@code this}
             */
            public Builder withHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }
            /**
             * Sets the value of KeyPrefixEquals
             * @param value ``CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @return {@code this}
             */
            public Builder withKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._keyPrefixEquals = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RoutingRuleConditionProperty build() {
                return new RoutingRuleConditionProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $httpErrorCodeReturnedEquals = _httpErrorCodeReturnedEquals;
                    @javax.annotation.Nullable
                    private java.lang.String $keyPrefixEquals = _keyPrefixEquals;

                    @Override
                    public java.lang.String getHttpErrorCodeReturnedEquals() {
                        return this.$httpErrorCodeReturnedEquals;
                    }

                    @Override
                    public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                        this.$httpErrorCodeReturnedEquals = value;
                    }

                    @Override
                    public java.lang.String getKeyPrefixEquals() {
                        return this.$keyPrefixEquals;
                    }

                    @Override
                    public void setKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                        this.$keyPrefixEquals = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHttpErrorCodeReturnedEquals() {
                return this.jsiiGet("httpErrorCodeReturnedEquals", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @Override
            public void setHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpErrorCodeReturnedEquals", value);
            }

            /**
             * ``CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKeyPrefixEquals() {
                return this.jsiiGet("keyPrefixEquals", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @Override
            public void setKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("keyPrefixEquals", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        java.lang.Object getRedirectRule();
        /**
         * ``CfnBucket.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        void setRedirectRule(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RoutingRuleProperty.RedirectRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        void setRedirectRule(final software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty value);
        /**
         * ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        java.lang.Object getRoutingRuleCondition();
        /**
         * ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        void setRoutingRuleCondition(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        void setRoutingRuleCondition(final software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty value);

        /**
         * @return a {@link Builder} of {@link RoutingRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleProperty}
         */
        final class Builder {
            private java.lang.Object _redirectRule;
            @javax.annotation.Nullable
            private java.lang.Object _routingRuleCondition;

            /**
             * Sets the value of RedirectRule
             * @param value ``CfnBucket.RoutingRuleProperty.RedirectRule``
             * @return {@code this}
             */
            public Builder withRedirectRule(final software.amazon.awscdk.Token value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RedirectRule
             * @param value ``CfnBucket.RoutingRuleProperty.RedirectRule``
             * @return {@code this}
             */
            public Builder withRedirectRule(final software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
             * @return {@code this}
             */
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._routingRuleCondition = value;
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
             * @return {@code this}
             */
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RoutingRuleProperty build() {
                return new RoutingRuleProperty() {
                    private java.lang.Object $redirectRule = java.util.Objects.requireNonNull(_redirectRule, "redirectRule is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $routingRuleCondition = _routingRuleCondition;

                    @Override
                    public java.lang.Object getRedirectRule() {
                        return this.$redirectRule;
                    }

                    @Override
                    public void setRedirectRule(final software.amazon.awscdk.Token value) {
                        this.$redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public void setRedirectRule(final software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty value) {
                        this.$redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                    }

                    @Override
                    public java.lang.Object getRoutingRuleCondition() {
                        return this.$routingRuleCondition;
                    }

                    @Override
                    public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$routingRuleCondition = value;
                    }

                    @Override
                    public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty value) {
                        this.$routingRuleCondition = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            public java.lang.Object getRedirectRule() {
                return this.jsiiGet("redirectRule", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            public void setRedirectRule(final software.amazon.awscdk.Token value) {
                this.jsiiSet("redirectRule", java.util.Objects.requireNonNull(value, "redirectRule is required"));
            }

            /**
             * ``CfnBucket.RoutingRuleProperty.RedirectRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            public void setRedirectRule(final software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty value) {
                this.jsiiSet("redirectRule", java.util.Objects.requireNonNull(value, "redirectRule is required"));
            }

            /**
             * ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRuleCondition() {
                return this.jsiiGet("routingRuleCondition", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("routingRuleCondition", value);
            }

            /**
             * ``CfnBucket.RoutingRuleProperty.RoutingRuleCondition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            public void setRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty value) {
                this.jsiiSet("routingRuleCondition", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        java.lang.String getStatus();
        /**
         * ``CfnBucket.RuleProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        java.lang.Object getAbortIncompleteMultipartUpload();
        /**
         * ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        void setAbortIncompleteMultipartUpload(final software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty value);
        /**
         * ``CfnBucket.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        java.lang.Object getExpirationDate();
        /**
         * ``CfnBucket.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        void setExpirationDate(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.ExpirationDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        void setExpirationDate(final java.time.Instant value);
        /**
         * ``CfnBucket.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        java.lang.Object getExpirationInDays();
        /**
         * ``CfnBucket.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        void setExpirationInDays(final java.lang.Number value);
        /**
         * ``CfnBucket.RuleProperty.ExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        void setExpirationInDays(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        java.lang.String getId();
        /**
         * ``CfnBucket.RuleProperty.Id``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        void setId(final java.lang.String value);
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        java.lang.Object getNoncurrentVersionExpirationInDays();
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        void setNoncurrentVersionExpirationInDays(final java.lang.Number value);
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        void setNoncurrentVersionExpirationInDays(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        java.lang.Object getNoncurrentVersionTransition();
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        void setNoncurrentVersionTransition(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        void setNoncurrentVersionTransition(final software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty value);
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        java.lang.Object getNoncurrentVersionTransitions();
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        void setNoncurrentVersionTransitions(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        void setNoncurrentVersionTransitions(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        java.lang.String getPrefix();
        /**
         * ``CfnBucket.RuleProperty.Prefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        void setPrefix(final java.lang.String value);
        /**
         * ``CfnBucket.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * ``CfnBucket.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        void setTagFilters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.TagFilters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        void setTagFilters(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnBucket.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        java.lang.Object getTransition();
        /**
         * ``CfnBucket.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        void setTransition(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.Transition``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        void setTransition(final software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty value);
        /**
         * ``CfnBucket.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        java.lang.Object getTransitions();
        /**
         * ``CfnBucket.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        void setTransitions(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.RuleProperty.Transitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        void setTransitions(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RuleProperty}
         */
        final class Builder {
            private java.lang.String _status;
            @javax.annotation.Nullable
            private java.lang.Object _abortIncompleteMultipartUpload;
            @javax.annotation.Nullable
            private java.lang.Object _expirationDate;
            @javax.annotation.Nullable
            private java.lang.Object _expirationInDays;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionExpirationInDays;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransition;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransitions;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;
            @javax.annotation.Nullable
            private java.lang.Object _transition;
            @javax.annotation.Nullable
            private java.lang.Object _transitions;

            /**
             * Sets the value of Status
             * @param value ``CfnBucket.RuleProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
             * @return {@code this}
             */
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
             * @return {@code this}
             */
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value ``CfnBucket.RuleProperty.ExpirationDate``
             * @return {@code this}
             */
            public Builder withExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value ``CfnBucket.RuleProperty.ExpirationDate``
             * @return {@code this}
             */
            public Builder withExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationInDays
             * @param value ``CfnBucket.RuleProperty.ExpirationInDays``
             * @return {@code this}
             */
            public Builder withExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._expirationInDays = value;
                return this;
            }
            /**
             * Sets the value of ExpirationInDays
             * @param value ``CfnBucket.RuleProperty.ExpirationInDays``
             * @return {@code this}
             */
            public Builder withExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._expirationInDays = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value ``CfnBucket.RuleProperty.Id``
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param value ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param value ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value ``CfnBucket.RuleProperty.Prefix``
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``CfnBucket.RuleProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value ``CfnBucket.RuleProperty.TagFilters``
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value ``CfnBucket.RuleProperty.Transition``
             * @return {@code this}
             */
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value ``CfnBucket.RuleProperty.Transition``
             * @return {@code this}
             */
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value ``CfnBucket.RuleProperty.Transitions``
             * @return {@code this}
             */
            public Builder withTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitions = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value ``CfnBucket.RuleProperty.Transitions``
             * @return {@code this}
             */
            public Builder withTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._transitions = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RuleProperty build() {
                return new RuleProperty() {
                    private java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $abortIncompleteMultipartUpload = _abortIncompleteMultipartUpload;
                    @javax.annotation.Nullable
                    private java.lang.Object $expirationDate = _expirationDate;
                    @javax.annotation.Nullable
                    private java.lang.Object $expirationInDays = _expirationInDays;
                    @javax.annotation.Nullable
                    private java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private java.lang.Object $noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                    @javax.annotation.Nullable
                    private java.lang.Object $noncurrentVersionTransition = _noncurrentVersionTransition;
                    @javax.annotation.Nullable
                    private java.lang.Object $noncurrentVersionTransitions = _noncurrentVersionTransitions;
                    @javax.annotation.Nullable
                    private java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagFilters = _tagFilters;
                    @javax.annotation.Nullable
                    private java.lang.Object $transition = _transition;
                    @javax.annotation.Nullable
                    private java.lang.Object $transitions = _transitions;

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public java.lang.Object getAbortIncompleteMultipartUpload() {
                        return this.$abortIncompleteMultipartUpload;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty value) {
                        this.$abortIncompleteMultipartUpload = value;
                    }

                    @Override
                    public java.lang.Object getExpirationDate() {
                        return this.$expirationDate;
                    }

                    @Override
                    public void setExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                        this.$expirationDate = value;
                    }

                    @Override
                    public java.lang.Object getExpirationInDays() {
                        return this.$expirationInDays;
                    }

                    @Override
                    public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public void setExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$expirationInDays = value;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public void setId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$id = value;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionExpirationInDays() {
                        return this.$noncurrentVersionExpirationInDays;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noncurrentVersionExpirationInDays = value;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransition() {
                        return this.$noncurrentVersionTransition;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty value) {
                        this.$noncurrentVersionTransition = value;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransitions() {
                        return this.$noncurrentVersionTransitions;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$noncurrentVersionTransitions = value;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                        this.$prefix = value;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagFilters = value;
                    }

                    @Override
                    public java.lang.Object getTransition() {
                        return this.$transition;
                    }

                    @Override
                    public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transition = value;
                    }

                    @Override
                    public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty value) {
                        this.$transition = value;
                    }

                    @Override
                    public java.lang.Object getTransitions() {
                        return this.$transitions;
                    }

                    @Override
                    public void setTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transitions = value;
                    }

                    @Override
                    public void setTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$transitions = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RuleProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.jsiiGet("abortIncompleteMultipartUpload", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("abortIncompleteMultipartUpload", value);
            }

            /**
             * ``CfnBucket.RuleProperty.AbortIncompleteMultipartUpload``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            public void setAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty value) {
                this.jsiiSet("abortIncompleteMultipartUpload", value);
            }

            /**
             * ``CfnBucket.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExpirationDate() {
                return this.jsiiGet("expirationDate", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            public void setExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("expirationDate", value);
            }

            /**
             * ``CfnBucket.RuleProperty.ExpirationDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            public void setExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                this.jsiiSet("expirationDate", value);
            }

            /**
             * ``CfnBucket.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExpirationInDays() {
                return this.jsiiGet("expirationInDays", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            public void setExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("expirationInDays", value);
            }

            /**
             * ``CfnBucket.RuleProperty.ExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            public void setExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("expirationInDays", value);
            }

            /**
             * ``CfnBucket.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RuleProperty.Id``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @Override
            public void setId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("id", value);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionExpirationInDays() {
                return this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("noncurrentVersionExpirationInDays", value);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            public void setNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionExpirationInDays", value);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransition() {
                return this.jsiiGet("noncurrentVersionTransition", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionTransition", value);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionTransition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            public void setNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty value) {
                this.jsiiSet("noncurrentVersionTransition", value);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransitions() {
                return this.jsiiGet("noncurrentVersionTransitions", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noncurrentVersionTransitions", value);
            }

            /**
             * ``CfnBucket.RuleProperty.NoncurrentVersionTransitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            public void setNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("noncurrentVersionTransitions", value);
            }

            /**
             * ``CfnBucket.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * ``CfnBucket.RuleProperty.Prefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @Override
            public void setPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("prefix", value);
            }

            /**
             * ``CfnBucket.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``CfnBucket.RuleProperty.TagFilters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            public void setTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagFilters", value);
            }

            /**
             * ``CfnBucket.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransition() {
                return this.jsiiGet("transition", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transition", value);
            }

            /**
             * ``CfnBucket.RuleProperty.Transition``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            public void setTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty value) {
                this.jsiiSet("transition", value);
            }

            /**
             * ``CfnBucket.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitions() {
                return this.jsiiGet("transitions", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            public void setTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitions", value);
            }

            /**
             * ``CfnBucket.RuleProperty.Transitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            public void setTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("transitions", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        java.lang.Object getRules();
        /**
         * ``CfnBucket.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        void setRules(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.S3KeyFilterProperty.Rules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        void setRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value ``CfnBucket.S3KeyFilterProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value ``CfnBucket.S3KeyFilterProperty.Rules``
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3KeyFilterProperty build() {
                return new S3KeyFilterProperty() {
                    private java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    @Override
                    public void setRules(final software.amazon.awscdk.Token value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                    @Override
                    public void setRules(final java.util.List<java.lang.Object> value) {
                        this.$rules = java.util.Objects.requireNonNull(value, "rules is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            public void setRules(final software.amazon.awscdk.Token value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }

            /**
             * ``CfnBucket.S3KeyFilterProperty.Rules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            public void setRules(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("rules", java.util.Objects.requireNonNull(value, "rules is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        java.lang.String getSseAlgorithm();
        /**
         * ``CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        void setSseAlgorithm(final java.lang.String value);
        /**
         * ``CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        java.lang.String getKmsMasterKeyId();
        /**
         * ``CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        void setKmsMasterKeyId(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        final class Builder {
            private java.lang.String _sseAlgorithm;
            @javax.annotation.Nullable
            private java.lang.String _kmsMasterKeyId;

            /**
             * Sets the value of SseAlgorithm
             * @param value ``CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @return {@code this}
             */
            public Builder withSseAlgorithm(final java.lang.String value) {
                this._sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }
            /**
             * Sets the value of KmsMasterKeyId
             * @param value ``CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @return {@code this}
             */
            public Builder withKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ServerSideEncryptionByDefaultProperty build() {
                return new ServerSideEncryptionByDefaultProperty() {
                    private java.lang.String $sseAlgorithm = java.util.Objects.requireNonNull(_sseAlgorithm, "sseAlgorithm is required");
                    @javax.annotation.Nullable
                    private java.lang.String $kmsMasterKeyId = _kmsMasterKeyId;

                    @Override
                    public java.lang.String getSseAlgorithm() {
                        return this.$sseAlgorithm;
                    }

                    @Override
                    public void setSseAlgorithm(final java.lang.String value) {
                        this.$sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                    }

                    @Override
                    public java.lang.String getKmsMasterKeyId() {
                        return this.$kmsMasterKeyId;
                    }

                    @Override
                    public void setKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$kmsMasterKeyId = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            @Override
            public java.lang.String getSseAlgorithm() {
                return this.jsiiGet("sseAlgorithm", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            @Override
            public void setSseAlgorithm(final java.lang.String value) {
                this.jsiiSet("sseAlgorithm", java.util.Objects.requireNonNull(value, "sseAlgorithm is required"));
            }

            /**
             * ``CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKmsMasterKeyId() {
                return this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
            }

            /**
             * ``CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @Override
            public void setKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kmsMasterKeyId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        java.lang.Object getServerSideEncryptionByDefault();
        /**
         * ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        void setServerSideEncryptionByDefault(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        void setServerSideEncryptionByDefault(final software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty value);

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _serverSideEncryptionByDefault;

            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @return {@code this}
             */
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ServerSideEncryptionRuleProperty build() {
                return new ServerSideEncryptionRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $serverSideEncryptionByDefault = _serverSideEncryptionByDefault;

                    @Override
                    public java.lang.Object getServerSideEncryptionByDefault() {
                        return this.$serverSideEncryptionByDefault;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$serverSideEncryptionByDefault = value;
                    }

                    @Override
                    public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty value) {
                        this.$serverSideEncryptionByDefault = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getServerSideEncryptionByDefault() {
                return this.jsiiGet("serverSideEncryptionByDefault", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("serverSideEncryptionByDefault", value);
            }

            /**
             * ``CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            public void setServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty value) {
                this.jsiiSet("serverSideEncryptionByDefault", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        java.lang.Object getSseKmsEncryptedObjects();
        /**
         * ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty value);

        /**
         * @return a {@link Builder} of {@link SourceSelectionCriteriaProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceSelectionCriteriaProperty}
         */
        final class Builder {
            private java.lang.Object _sseKmsEncryptedObjects;

            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @return {@code this}
             */
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }
            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @return {@code this}
             */
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceSelectionCriteriaProperty build() {
                return new SourceSelectionCriteriaProperty() {
                    private java.lang.Object $sseKmsEncryptedObjects = java.util.Objects.requireNonNull(_sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");

                    @Override
                    public java.lang.Object getSseKmsEncryptedObjects() {
                        return this.$sseKmsEncryptedObjects;
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                        this.$sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }

                    @Override
                    public void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty value) {
                        this.$sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            public java.lang.Object getSseKmsEncryptedObjects() {
                return this.jsiiGet("sseKmsEncryptedObjects", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                this.jsiiSet("sseKmsEncryptedObjects", java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required"));
            }

            /**
             * ``CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            public void setSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty value) {
                this.jsiiSet("sseKmsEncryptedObjects", java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        java.lang.String getStatus();
        /**
         * ``CfnBucket.SseKmsEncryptedObjectsProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        void setStatus(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link SseKmsEncryptedObjectsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SseKmsEncryptedObjectsProperty}
         */
        final class Builder {
            private java.lang.String _status;

            /**
             * Sets the value of Status
             * @param value ``CfnBucket.SseKmsEncryptedObjectsProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseKmsEncryptedObjectsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SseKmsEncryptedObjectsProperty build() {
                return new SseKmsEncryptedObjectsProperty() {
                    private java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * ``CfnBucket.SseKmsEncryptedObjectsProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        java.lang.Object getDataExport();
        /**
         * ``CfnBucket.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        void setDataExport(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.StorageClassAnalysisProperty.DataExport``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        void setDataExport(final software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty value);

        /**
         * @return a {@link Builder} of {@link StorageClassAnalysisProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StorageClassAnalysisProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _dataExport;

            /**
             * Sets the value of DataExport
             * @param value ``CfnBucket.StorageClassAnalysisProperty.DataExport``
             * @return {@code this}
             */
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._dataExport = value;
                return this;
            }
            /**
             * Sets the value of DataExport
             * @param value ``CfnBucket.StorageClassAnalysisProperty.DataExport``
             * @return {@code this}
             */
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty value) {
                this._dataExport = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageClassAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StorageClassAnalysisProperty build() {
                return new StorageClassAnalysisProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $dataExport = _dataExport;

                    @Override
                    public java.lang.Object getDataExport() {
                        return this.$dataExport;
                    }

                    @Override
                    public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$dataExport = value;
                    }

                    @Override
                    public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty value) {
                        this.$dataExport = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDataExport() {
                return this.jsiiGet("dataExport", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("dataExport", value);
            }

            /**
             * ``CfnBucket.StorageClassAnalysisProperty.DataExport``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            public void setDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty value) {
                this.jsiiSet("dataExport", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        java.lang.String getKey();
        /**
         * ``CfnBucket.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``CfnBucket.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        java.lang.String getValue();
        /**
         * ``CfnBucket.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        void setValue(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        final class Builder {
            private java.lang.String _key;
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value ``CfnBucket.TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``CfnBucket.TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagFilterProperty build() {
                return new TagFilterProperty() {
                    private java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private java.lang.String $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(final java.lang.String value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(final java.lang.String value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * ``CfnBucket.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            @Override
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``CfnBucket.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            @Override
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * ``CfnBucket.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            @Override
            public void setValue(final java.lang.String value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        java.lang.String getEvent();
        /**
         * ``CfnBucket.TopicConfigurationProperty.Event``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        void setEvent(final java.lang.String value);
        /**
         * ``CfnBucket.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        java.lang.String getTopic();
        /**
         * ``CfnBucket.TopicConfigurationProperty.Topic``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        void setTopic(final java.lang.String value);
        /**
         * ``CfnBucket.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        java.lang.Object getFilter();
        /**
         * ``CfnBucket.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        void setFilter(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.TopicConfigurationProperty.Filter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        void setFilter(final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value);

        /**
         * @return a {@link Builder} of {@link TopicConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TopicConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _topic;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value ``CfnBucket.TopicConfigurationProperty.Event``
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Topic
             * @param value ``CfnBucket.TopicConfigurationProperty.Topic``
             * @return {@code this}
             */
            public Builder withTopic(final java.lang.String value) {
                this._topic = java.util.Objects.requireNonNull(value, "topic is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``CfnBucket.TopicConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value ``CfnBucket.TopicConfigurationProperty.Filter``
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TopicConfigurationProperty build() {
                return new TopicConfigurationProperty() {
                    private java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private java.lang.String $topic = java.util.Objects.requireNonNull(_topic, "topic is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public void setEvent(final java.lang.String value) {
                        this.$event = java.util.Objects.requireNonNull(value, "event is required");
                    }

                    @Override
                    public java.lang.String getTopic() {
                        return this.$topic;
                    }

                    @Override
                    public void setTopic(final java.lang.String value) {
                        this.$topic = java.util.Objects.requireNonNull(value, "topic is required");
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$filter = value;
                    }

                    @Override
                    public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                        this.$filter = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TopicConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            @Override
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * ``CfnBucket.TopicConfigurationProperty.Event``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            @Override
            public void setEvent(final java.lang.String value) {
                this.jsiiSet("event", java.util.Objects.requireNonNull(value, "event is required"));
            }

            /**
             * ``CfnBucket.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            @Override
            public java.lang.String getTopic() {
                return this.jsiiGet("topic", java.lang.String.class);
            }

            /**
             * ``CfnBucket.TopicConfigurationProperty.Topic``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            @Override
            public void setTopic(final java.lang.String value) {
                this.jsiiSet("topic", java.util.Objects.requireNonNull(value, "topic is required"));
            }

            /**
             * ``CfnBucket.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("filter", value);
            }

            /**
             * ``CfnBucket.TopicConfigurationProperty.Filter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            public void setFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this.jsiiSet("filter", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        java.lang.String getStorageClass();
        /**
         * ``CfnBucket.TransitionProperty.StorageClass``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        void setStorageClass(final java.lang.String value);
        /**
         * ``CfnBucket.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        java.lang.Object getTransitionDate();
        /**
         * ``CfnBucket.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        void setTransitionDate(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.TransitionProperty.TransitionDate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        void setTransitionDate(final java.time.Instant value);
        /**
         * ``CfnBucket.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        java.lang.Object getTransitionInDays();
        /**
         * ``CfnBucket.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        void setTransitionInDays(final java.lang.Number value);
        /**
         * ``CfnBucket.TransitionProperty.TransitionInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        void setTransitionInDays(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link TransitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TransitionProperty}
         */
        final class Builder {
            private java.lang.String _storageClass;
            @javax.annotation.Nullable
            private java.lang.Object _transitionDate;
            @javax.annotation.Nullable
            private java.lang.Object _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value ``CfnBucket.TransitionProperty.StorageClass``
             * @return {@code this}
             */
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value ``CfnBucket.TransitionProperty.TransitionDate``
             * @return {@code this}
             */
            public Builder withTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value ``CfnBucket.TransitionProperty.TransitionDate``
             * @return {@code this}
             */
            public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``CfnBucket.TransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._transitionInDays = value;
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value ``CfnBucket.TransitionProperty.TransitionInDays``
             * @return {@code this}
             */
            public Builder withTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitionInDays = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TransitionProperty build() {
                return new TransitionProperty() {
                    private java.lang.String $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $transitionDate = _transitionDate;
                    @javax.annotation.Nullable
                    private java.lang.Object $transitionInDays = _transitionInDays;

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public void setStorageClass(final java.lang.String value) {
                        this.$storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                    }

                    @Override
                    public java.lang.Object getTransitionDate() {
                        return this.$transitionDate;
                    }

                    @Override
                    public void setTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                        this.$transitionDate = value;
                    }

                    @Override
                    public java.lang.Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    @Override
                    public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$transitionInDays = value;
                    }

                    @Override
                    public void setTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$transitionInDays = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            @Override
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * ``CfnBucket.TransitionProperty.StorageClass``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            @Override
            public void setStorageClass(final java.lang.String value) {
                this.jsiiSet("storageClass", java.util.Objects.requireNonNull(value, "storageClass is required"));
            }

            /**
             * ``CfnBucket.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitionDate() {
                return this.jsiiGet("transitionDate", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            public void setTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionDate", value);
            }

            /**
             * ``CfnBucket.TransitionProperty.TransitionDate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            public void setTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                this.jsiiSet("transitionDate", value);
            }

            /**
             * ``CfnBucket.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            public void setTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("transitionInDays", value);
            }

            /**
             * ``CfnBucket.TransitionProperty.TransitionInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            public void setTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("transitionInDays", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        java.lang.String getStatus();
        /**
         * ``CfnBucket.VersioningConfigurationProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        void setStatus(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _status;

            /**
             * Sets the value of Status
             * @param value ``CfnBucket.VersioningConfigurationProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VersioningConfigurationProperty build() {
                return new VersioningConfigurationProperty() {
                    private java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * ``CfnBucket.VersioningConfigurationProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        java.lang.String getErrorDocument();
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.ErrorDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        void setErrorDocument(final java.lang.String value);
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        java.lang.String getIndexDocument();
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.IndexDocument``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        void setIndexDocument(final java.lang.String value);
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        java.lang.Object getRedirectAllRequestsTo();
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        void setRedirectAllRequestsTo(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        void setRedirectAllRequestsTo(final software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty value);
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        java.lang.Object getRoutingRules();
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        void setRoutingRules(final software.amazon.awscdk.Token value);
        /**
         * ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        void setRoutingRules(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link WebsiteConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link WebsiteConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _errorDocument;
            @javax.annotation.Nullable
            private java.lang.String _indexDocument;
            @javax.annotation.Nullable
            private java.lang.Object _redirectAllRequestsTo;
            @javax.annotation.Nullable
            private java.lang.Object _routingRules;

            /**
             * Sets the value of ErrorDocument
             * @param value ``CfnBucket.WebsiteConfigurationProperty.ErrorDocument``
             * @return {@code this}
             */
            public Builder withErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._errorDocument = value;
                return this;
            }
            /**
             * Sets the value of IndexDocument
             * @param value ``CfnBucket.WebsiteConfigurationProperty.IndexDocument``
             * @return {@code this}
             */
            public Builder withIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._indexDocument = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @return {@code this}
             */
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @return {@code this}
             */
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
             * @return {@code this}
             */
            public Builder withRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._routingRules = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
             * @return {@code this}
             */
            public Builder withRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._routingRules = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebsiteConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public WebsiteConfigurationProperty build() {
                return new WebsiteConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $errorDocument = _errorDocument;
                    @javax.annotation.Nullable
                    private java.lang.String $indexDocument = _indexDocument;
                    @javax.annotation.Nullable
                    private java.lang.Object $redirectAllRequestsTo = _redirectAllRequestsTo;
                    @javax.annotation.Nullable
                    private java.lang.Object $routingRules = _routingRules;

                    @Override
                    public java.lang.String getErrorDocument() {
                        return this.$errorDocument;
                    }

                    @Override
                    public void setErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                        this.$errorDocument = value;
                    }

                    @Override
                    public java.lang.String getIndexDocument() {
                        return this.$indexDocument;
                    }

                    @Override
                    public void setIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                        this.$indexDocument = value;
                    }

                    @Override
                    public java.lang.Object getRedirectAllRequestsTo() {
                        return this.$redirectAllRequestsTo;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty value) {
                        this.$redirectAllRequestsTo = value;
                    }

                    @Override
                    public java.lang.Object getRoutingRules() {
                        return this.$routingRules;
                    }

                    @Override
                    public void setRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$routingRules = value;
                    }

                    @Override
                    public void setRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$routingRules = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getErrorDocument() {
                return this.jsiiGet("errorDocument", java.lang.String.class);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.ErrorDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @Override
            public void setErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("errorDocument", value);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getIndexDocument() {
                return this.jsiiGet("indexDocument", java.lang.String.class);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.IndexDocument``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @Override
            public void setIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("indexDocument", value);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRedirectAllRequestsTo() {
                return this.jsiiGet("redirectAllRequestsTo", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("redirectAllRequestsTo", value);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            public void setRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty value) {
                this.jsiiSet("redirectAllRequestsTo", value);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRules() {
                return this.jsiiGet("routingRules", java.lang.Object.class);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            public void setRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("routingRules", value);
            }

            /**
             * ``CfnBucket.WebsiteConfigurationProperty.RoutingRules``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            public void setRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("routingRules", value);
            }
        }
    }
}
