package software.amazon.awscdk.services.s3;

/**
 * Construction properties of the {@link PipelineDeployAction S3 deploy Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:11:04.761Z")
public interface PipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps {
    /**
     * The Amazon S3 bucket that is the deploy target.
     */
    software.amazon.awscdk.services.s3.IBucket getBucket();
    /**
     * The Amazon S3 bucket that is the deploy target.
     */
    void setBucket(final software.amazon.awscdk.services.s3.IBucket value);

    /**
     * @return a {@link Builder} of {@link PipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineDeployActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.IBucket _bucket;
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.Boolean _extract;
        @javax.annotation.Nullable
        private java.lang.String _objectKey;
        private java.lang.String _actionName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of Bucket
         * @param value The Amazon S3 bucket that is the deploy target.
         * @return {@code this}
         */
        public Builder withBucket(final software.amazon.awscdk.services.s3.IBucket value) {
            this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The inputArtifact to deploy to Amazon S3.
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of Extract
         * @param value Should the deploy action extract the artifact before deploying to Amazon S3.
         * @return {@code this}
         */
        public Builder withExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._extract = value;
            return this;
        }
        /**
         * Sets the value of ObjectKey
         * @param value The key of the target object. This is required if extract is false.
         * @return {@code this}
         */
        public Builder withObjectKey(@javax.annotation.Nullable final java.lang.String value) {
            this._objectKey = value;
            return this;
        }
        /**
         * Sets the value of ActionName
         * @param value The physical, human-readable name of the Action.
Not that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        public Builder withActionName(final java.lang.String value) {
            this._actionName = java.util.Objects.requireNonNull(value, "actionName is required");
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps() {
                private software.amazon.awscdk.services.s3.IBucket $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $extract = _extract;
                @javax.annotation.Nullable
                private java.lang.String $objectKey = _objectKey;
                private java.lang.String $actionName = java.util.Objects.requireNonNull(_actionName, "actionName is required");
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;

                @Override
                public software.amazon.awscdk.services.s3.IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(final software.amazon.awscdk.services.s3.IBucket value) {
                    this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
                }

                @Override
                public java.lang.Boolean getExtract() {
                    return this.$extract;
                }

                @Override
                public void setExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$extract = value;
                }

                @Override
                public java.lang.String getObjectKey() {
                    return this.$objectKey;
                }

                @Override
                public void setObjectKey(@javax.annotation.Nullable final java.lang.String value) {
                    this.$objectKey = value;
                }

                @Override
                public java.lang.String getActionName() {
                    return this.$actionName;
                }

                @Override
                public void setActionName(final java.lang.String value) {
                    this.$actionName = java.util.Objects.requireNonNull(value, "actionName is required");
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.PipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon S3 bucket that is the deploy target.
         */
        @Override
        public software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.IBucket.class);
        }

        /**
         * The Amazon S3 bucket that is the deploy target.
         */
        @Override
        public void setBucket(final software.amazon.awscdk.services.s3.IBucket value) {
            this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
        }

        /**
         * The inputArtifact to deploy to Amazon S3.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The inputArtifact to deploy to Amazon S3.
         */
        @Override
        public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", java.util.Objects.requireNonNull(value, "inputArtifact is required"));
        }

        /**
         * Should the deploy action extract the artifact before deploying to Amazon S3.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getExtract() {
            return this.jsiiGet("extract", java.lang.Boolean.class);
        }

        /**
         * Should the deploy action extract the artifact before deploying to Amazon S3.
         * @default true
         */
        @Override
        public void setExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("extract", value);
        }

        /**
         * The key of the target object. This is required if extract is false.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getObjectKey() {
            return this.jsiiGet("objectKey", java.lang.String.class);
        }

        /**
         * The key of the target object. This is required if extract is false.
         */
        @Override
        public void setObjectKey(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("objectKey", value);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public java.lang.String getActionName() {
            return this.jsiiGet("actionName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public void setActionName(final java.lang.String value) {
            this.jsiiSet("actionName", java.util.Objects.requireNonNull(value, "actionName is required"));
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }
    }
}
