package software.amazon.awscdk.services.s3;

/**
 * Common properties for creating {@link PipelineSourceAction} -
 * either directly, through its constructor,
 * or through {@link IBucket#toCodePipelineSourceAction}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-07T22:16:15.494Z")
public interface CommonPipelineSourceActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * The key within the S3 bucket that stores the source code.
     * @example 'path/to/file.zip'
     */
    java.lang.String getBucketKey();
    /**
     * The key within the S3 bucket that stores the source code.
     * @example 'path/to/file.zip'
     */
    void setBucketKey(final java.lang.String value);
    /**
     * The name of the source's output artifact. Output artifacts are used by CodePipeline as
     * inputs into other actions.
     * @default a name will be auto-generated
     */
    java.lang.String getOutputArtifactName();
    /**
     * The name of the source's output artifact. Output artifacts are used by CodePipeline as
     * inputs into other actions.
     * @default a name will be auto-generated
     */
    void setOutputArtifactName(final java.lang.String value);
    /**
     * Whether AWS CodePipeline should poll for source changes.
     * If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
     * Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
     * as otherwise the CloudWatch Events will not be emitted.
     * @default true
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
     */
    java.lang.Boolean getPollForSourceChanges();
    /**
     * Whether AWS CodePipeline should poll for source changes.
     * If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
     * Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
     * as otherwise the CloudWatch Events will not be emitted.
     * @default true
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
     */
    void setPollForSourceChanges(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link CommonPipelineSourceActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CommonPipelineSourceActionProps}
     */
    final class Builder {
        private java.lang.String _bucketKey;
        @javax.annotation.Nullable
        private java.lang.String _outputArtifactName;
        @javax.annotation.Nullable
        private java.lang.Boolean _pollForSourceChanges;
        private java.lang.String _actionName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of BucketKey
         * @param value The key within the S3 bucket that stores the source code.
         * @return {@code this}
         */
        public Builder withBucketKey(final java.lang.String value) {
            this._bucketKey = java.util.Objects.requireNonNull(value, "bucketKey is required");
            return this;
        }
        /**
         * Sets the value of OutputArtifactName
         * @param value The name of the source's output artifact. Output artifacts are used by CodePipeline as
inputs into other actions.
         * @return {@code this}
         */
        public Builder withOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this._outputArtifactName = value;
            return this;
        }
        /**
         * Sets the value of PollForSourceChanges
         * @param value Whether AWS CodePipeline should poll for source changes.
If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
as otherwise the CloudWatch Events will not be emitted.
         * @return {@code this}
         */
        public Builder withPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._pollForSourceChanges = value;
            return this;
        }
        /**
         * Sets the value of ActionName
         * @param value The physical, human-readable name of the Action.
Not that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        public Builder withActionName(final java.lang.String value) {
            this._actionName = java.util.Objects.requireNonNull(value, "actionName is required");
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonPipelineSourceActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CommonPipelineSourceActionProps build() {
            return new CommonPipelineSourceActionProps() {
                private java.lang.String $bucketKey = java.util.Objects.requireNonNull(_bucketKey, "bucketKey is required");
                @javax.annotation.Nullable
                private java.lang.String $outputArtifactName = _outputArtifactName;
                @javax.annotation.Nullable
                private java.lang.Boolean $pollForSourceChanges = _pollForSourceChanges;
                private java.lang.String $actionName = java.util.Objects.requireNonNull(_actionName, "actionName is required");
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;

                @Override
                public java.lang.String getBucketKey() {
                    return this.$bucketKey;
                }

                @Override
                public void setBucketKey(final java.lang.String value) {
                    this.$bucketKey = java.util.Objects.requireNonNull(value, "bucketKey is required");
                }

                @Override
                public java.lang.String getOutputArtifactName() {
                    return this.$outputArtifactName;
                }

                @Override
                public void setOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$outputArtifactName = value;
                }

                @Override
                public java.lang.Boolean getPollForSourceChanges() {
                    return this.$pollForSourceChanges;
                }

                @Override
                public void setPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$pollForSourceChanges = value;
                }

                @Override
                public java.lang.String getActionName() {
                    return this.$actionName;
                }

                @Override
                public void setActionName(final java.lang.String value) {
                    this.$actionName = java.util.Objects.requireNonNull(value, "actionName is required");
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The key within the S3 bucket that stores the source code.
         * @example 'path/to/file.zip'
         */
        @Override
        public java.lang.String getBucketKey() {
            return this.jsiiGet("bucketKey", java.lang.String.class);
        }

        /**
         * The key within the S3 bucket that stores the source code.
         * @example 'path/to/file.zip'
         */
        @Override
        public void setBucketKey(final java.lang.String value) {
            this.jsiiSet("bucketKey", java.util.Objects.requireNonNull(value, "bucketKey is required"));
        }

        /**
         * The name of the source's output artifact. Output artifacts are used by CodePipeline as
         * inputs into other actions.
         * @default a name will be auto-generated
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOutputArtifactName() {
            return this.jsiiGet("outputArtifactName", java.lang.String.class);
        }

        /**
         * The name of the source's output artifact. Output artifacts are used by CodePipeline as
         * inputs into other actions.
         * @default a name will be auto-generated
         */
        @Override
        public void setOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("outputArtifactName", value);
        }

        /**
         * Whether AWS CodePipeline should poll for source changes.
         * If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
         * Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
         * as otherwise the CloudWatch Events will not be emitted.
         * @default true
         * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPollForSourceChanges() {
            return this.jsiiGet("pollForSourceChanges", java.lang.Boolean.class);
        }

        /**
         * Whether AWS CodePipeline should poll for source changes.
         * If this is `false`, the Pipeline will use CloudWatch Events to detect source changes instead.
         * Note that if this is `false`, you need to make sure to include the source Bucket in a CloudTrail Trail,
         * as otherwise the CloudWatch Events will not be emitted.
         * @default true
         * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
         */
        @Override
        public void setPollForSourceChanges(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("pollForSourceChanges", value);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public java.lang.String getActionName() {
            return this.jsiiGet("actionName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public void setActionName(final java.lang.String value) {
            this.jsiiSet("actionName", java.util.Objects.requireNonNull(value, "actionName is required"));
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }
    }
}
