package software.amazon.awscdk.services.s3;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-07T22:16:15.495Z")
public interface IBucket extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IConstruct {
    /**
     * The ARN of the bucket.
     */
    java.lang.String getBucketArn();
    /**
     * The name of the bucket.
     */
    java.lang.String getBucketName();
    /**
     * The https:// URL of this bucket.
     * @example https://s3.us-west-1.amazonaws.com/onlybucket Similar to calling `urlForObject` with no object key.
     */
    java.lang.String getBucketUrl();
    /**
     * The domain of the bucket.
     */
    java.lang.String getDomainName();
    /**
     * Optional KMS encryption key associated with this bucket.
     */
    software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey();
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    software.amazon.awscdk.services.s3.BucketPolicy getPolicy();
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    void setPolicy(final software.amazon.awscdk.services.s3.BucketPolicy value);
    /**
     * Adds a statement to the resource policy for a principal (i.e.
     * account/role/service) to perform actions on this bucket and/or it's
     * contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for
     * this bucket or objects.
     */
    void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement permission);
    /**
     * Returns an ARN that represents all objects within the bucket that match
     * the key pattern specified. To represent all keys, specify ``"*"``.
     * 
     * If you specify multiple components for keyPattern, they will be concatenated::
     * 
     *    arnForObjects('home/', team, '/', user, '/*')
     */
    java.lang.String arnForObjects(final java.lang.String... keyPattern);
    /**
     * Exports this bucket from the stack.
     */
    software.amazon.awscdk.services.s3.BucketImportProps export();
    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects
     * in this bucket.
     * @param identity The principal
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
     */
    void grantDelete(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects
     * in this bucket.
     * @param identity The principal
     */
    void grantDelete(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects
     * in this bucket.
     */
    void grantDelete();
    /**
     * Allows unrestricted access to objects from this bucket.
     * 
     * IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.
     * 
     * Without arguments, this method will grant read ("s3:GetObject") access to
     * all objects ("*") in the bucket.
     * 
     * The method returns the `iam.PolicyStatement` object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:
     * 
     *      const statement = bucket.grantPublicAccess();
     *      statement.addCondition('IpAddress', { "aws:SourceIp": "54.240.143.0/24" });
     * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
     * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
     * @param allowedActions the set of S3 actions to allow. Default is "s3:GetObject".
     */
    software.amazon.awscdk.services.iam.PolicyStatement grantPublicAccess(@javax.annotation.Nullable final java.lang.String keyPrefix, final java.lang.String... allowedActions);
    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * @param identity The principal
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
     */
    void grantPut(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * @param identity The principal
     */
    void grantPut(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     */
    void grantPut();
    /**
     * Grant read permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * @param identity The principal
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
     */
    void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grant read permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * @param identity The principal
     */
    void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grant read permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     */
    void grantRead();
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * @param identity The principal
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
     */
    void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * @param identity The principal
     */
    void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    void grantReadWrite();
    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * @param identity The principal
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
     */
    void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * @param identity The principal
     */
    void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     */
    void grantWrite();
    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     * @return a new {@link events.EventRule} instance
     * @param name the logical ID of the newly created Event Rule
     * @param target the optional target of the Event Rule
     * @param path the optional path inside the Bucket that will be watched for changes
     */
    software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final java.lang.String path);
    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     * @return a new {@link events.EventRule} instance
     * @param name the logical ID of the newly created Event Rule
     * @param target the optional target of the Event Rule
     */
    software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target);
    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     * @return a new {@link events.EventRule} instance
     * @param name the logical ID of the newly created Event Rule
     */
    software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name);
    /**
     * Convenience method for creating a new {@link PipelineDeployAction}.
     * @return the newly created {@link PipelineDeployAction}
     * @param props the construction properties of the new Action
     */
    software.amazon.awscdk.services.s3.PipelineDeployAction toCodePipelineDeployAction(final software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps props);
    /**
     * Convenience method for creating a new {@link PipelineSourceAction}.
     * @return the newly created {@link PipelineSourceAction}
     * @param props the construction properties of the new Action
     */
    software.amazon.awscdk.services.s3.PipelineSourceAction toCodePipelineSourceAction(final software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps props);
    /**
     * The https URL of an S3 object. For example:
     * @example https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * @return an ObjectS3Url token
     * @param key The S3 key of the object. If not specified, the URL of the
bucket is returned.
     */
    java.lang.String urlForObject(@javax.annotation.Nullable final java.lang.String key);
    /**
     * The https URL of an S3 object. For example:
     * @example https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * @return an ObjectS3Url token
     */
    java.lang.String urlForObject();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.IBucket {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the bucket.
         */
        @Override
        public java.lang.String getBucketArn() {
            return this.jsiiGet("bucketArn", java.lang.String.class);
        }

        /**
         * The name of the bucket.
         */
        @Override
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The https:// URL of this bucket.
         * @example https://s3.us-west-1.amazonaws.com/onlybucket Similar to calling `urlForObject` with no object key.
         */
        @Override
        public java.lang.String getBucketUrl() {
            return this.jsiiGet("bucketUrl", java.lang.String.class);
        }

        /**
         * The domain of the bucket.
         */
        @Override
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Optional KMS encryption key associated with this bucket.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
        }

        /**
         * The resource policy assoicated with this bucket.
         * 
         * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
            return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
        }

        /**
         * The resource policy assoicated with this bucket.
         * 
         * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        public void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
            this.jsiiSet("policy", value);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Adds a statement to the resource policy for a principal (i.e.
         * account/role/service) to perform actions on this bucket and/or it's
         * contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for
         * this bucket or objects.
         */
        @Override
        public void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement permission) {
            this.jsiiCall("addToResourcePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(permission, "permission is required")).toArray());
        }

        /**
         * Returns an ARN that represents all objects within the bucket that match
         * the key pattern specified. To represent all keys, specify ``"*"``.
         * 
         * If you specify multiple components for keyPattern, they will be concatenated::
         * 
         *    arnForObjects('home/', team, '/', user, '/*')
         */
        @Override
        public java.lang.String arnForObjects(final java.lang.String... keyPattern) {
            return this.jsiiCall("arnForObjects", java.lang.String.class, java.util.Arrays.stream(java.util.Objects.requireNonNull(keyPattern, "keyPattern is required")).toArray());
        }

        /**
         * Exports this bucket from the stack.
         */
        @Override
        public software.amazon.awscdk.services.s3.BucketImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.s3.BucketImportProps.class);
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM pricipal for objects
         * in this bucket.
         * @param identity The principal
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
         */
        @Override
        public void grantDelete(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            this.jsiiCall("grantDelete", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(identity), java.util.stream.Stream.of(objectsKeyPattern)).toArray());
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM pricipal for objects
         * in this bucket.
         * @param identity The principal
         */
        @Override
        public void grantDelete(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantDelete", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM pricipal for objects
         * in this bucket.
         */
        @Override
        public void grantDelete() {
            this.jsiiCall("grantDelete", Void.class);
        }

        /**
         * Allows unrestricted access to objects from this bucket.
         * 
         * IMPORTANT: This permission allows anyone to perform actions on S3 objects
         * in this bucket, which is useful for when you configure your bucket as a
         * website and want everyone to be able to read objects in the bucket without
         * needing to authenticate.
         * 
         * Without arguments, this method will grant read ("s3:GetObject") access to
         * all objects ("*") in the bucket.
         * 
         * The method returns the `iam.PolicyStatement` object, which can then be modified
         * as needed. For example, you can add a condition that will restrict access only
         * to an IPv4 range like this:
         * 
         *      const statement = bucket.grantPublicAccess();
         *      statement.addCondition('IpAddress', { "aws:SourceIp": "54.240.143.0/24" });
         * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
         * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
         * @param allowedActions the set of S3 actions to allow. Default is "s3:GetObject".
         */
        @Override
        public software.amazon.awscdk.services.iam.PolicyStatement grantPublicAccess(@javax.annotation.Nullable final java.lang.String keyPrefix, final java.lang.String... allowedActions) {
            return this.jsiiCall("grantPublicAccess", software.amazon.awscdk.services.iam.PolicyStatement.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(keyPrefix), java.util.Arrays.stream(java.util.Objects.requireNonNull(allowedActions, "allowedActions is required"))).toArray());
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * @param identity The principal
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
         */
        @Override
        public void grantPut(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            this.jsiiCall("grantPut", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(identity), java.util.stream.Stream.of(objectsKeyPattern)).toArray());
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * @param identity The principal
         */
        @Override
        public void grantPut(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantPut", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         */
        @Override
        public void grantPut() {
            this.jsiiCall("grantPut", Void.class);
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM
         * principal (Role/Group/User).
         * 
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * @param identity The principal
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
         */
        @Override
        public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(identity), java.util.stream.Stream.of(objectsKeyPattern)).toArray());
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM
         * principal (Role/Group/User).
         * 
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * @param identity The principal
         */
        @Override
        public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM
         * principal (Role/Group/User).
         * 
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         */
        @Override
        public void grantRead() {
            this.jsiiCall("grantRead", Void.class);
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * @param identity The principal
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
         */
        @Override
        public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(identity), java.util.stream.Stream.of(objectsKeyPattern)).toArray());
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * @param identity The principal
         */
        @Override
        public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         */
        @Override
        public void grantReadWrite() {
            this.jsiiCall("grantReadWrite", Void.class);
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * @param identity The principal
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*')
         */
        @Override
        public void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            this.jsiiCall("grantWrite", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(identity), java.util.stream.Stream.of(objectsKeyPattern)).toArray());
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * @param identity The principal
         */
        @Override
        public void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         */
        @Override
        public void grantWrite() {
            this.jsiiCall("grantWrite", Void.class);
        }

        /**
         * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
         * @return a new {@link events.EventRule} instance
         * @param name the logical ID of the newly created Event Rule
         * @param target the optional target of the Event Rule
         * @param path the optional path inside the Bucket that will be watched for changes
         */
        @Override
        public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final java.lang.String path) {
            return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(path)).toArray());
        }

        /**
         * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
         * @return a new {@link events.EventRule} instance
         * @param name the logical ID of the newly created Event Rule
         * @param target the optional target of the Event Rule
         */
        @Override
        public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
            return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)).toArray());
        }

        /**
         * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
         * @return a new {@link events.EventRule} instance
         * @param name the logical ID of the newly created Event Rule
         */
        @Override
        public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name) {
            return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
        }

        /**
         * Convenience method for creating a new {@link PipelineDeployAction}.
         * @return the newly created {@link PipelineDeployAction}
         * @param props the construction properties of the new Action
         */
        @Override
        public software.amazon.awscdk.services.s3.PipelineDeployAction toCodePipelineDeployAction(final software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps props) {
            return this.jsiiCall("toCodePipelineDeployAction", software.amazon.awscdk.services.s3.PipelineDeployAction.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
        }

        /**
         * Convenience method for creating a new {@link PipelineSourceAction}.
         * @return the newly created {@link PipelineSourceAction}
         * @param props the construction properties of the new Action
         */
        @Override
        public software.amazon.awscdk.services.s3.PipelineSourceAction toCodePipelineSourceAction(final software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps props) {
            return this.jsiiCall("toCodePipelineSourceAction", software.amazon.awscdk.services.s3.PipelineSourceAction.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
        }

        /**
         * The https URL of an S3 object. For example:
         * @example https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
         * @return an ObjectS3Url token
         * @param key The S3 key of the object. If not specified, the URL of the
bucket is returned.
         */
        @Override
        public java.lang.String urlForObject(@javax.annotation.Nullable final java.lang.String key) {
            return this.jsiiCall("urlForObject", java.lang.String.class, java.util.stream.Stream.of(key).toArray());
        }

        /**
         * The https URL of an S3 object. For example:
         * @example https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
         * @return an ObjectS3Url token
         */
        @Override
        public java.lang.String urlForObject() {
            return this.jsiiCall("urlForObject", java.lang.String.class);
        }
    }
}
