package software.amazon.awscdk.services.s3;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T12:58:45.893Z")
public interface BlockPublicAccessOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether to block public ACLs
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    java.lang.Boolean getBlockPublicAcls();
    /**
     * Whether to block public ACLs
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    void setBlockPublicAcls(final java.lang.Boolean value);
    /**
     * Whether to block public policy
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    java.lang.Boolean getBlockPublicPolicy();
    /**
     * Whether to block public policy
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    void setBlockPublicPolicy(final java.lang.Boolean value);
    /**
     * Whether to ignore public ACLs
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    java.lang.Boolean getIgnorePublicAcls();
    /**
     * Whether to ignore public ACLs
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    void setIgnorePublicAcls(final java.lang.Boolean value);
    /**
     * Whether to restrict public access
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    java.lang.Boolean getRestrictPublicBuckets();
    /**
     * Whether to restrict public access
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
     */
    void setRestrictPublicBuckets(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link BlockPublicAccessOptions}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BlockPublicAccessOptions}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _blockPublicAcls;
        @javax.annotation.Nullable
        private java.lang.Boolean _blockPublicPolicy;
        @javax.annotation.Nullable
        private java.lang.Boolean _ignorePublicAcls;
        @javax.annotation.Nullable
        private java.lang.Boolean _restrictPublicBuckets;

        /**
         * Sets the value of BlockPublicAcls
         * @param value Whether to block public ACLs
         * @return {@code this}
         */
        public Builder withBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._blockPublicAcls = value;
            return this;
        }
        /**
         * Sets the value of BlockPublicPolicy
         * @param value Whether to block public policy
         * @return {@code this}
         */
        public Builder withBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._blockPublicPolicy = value;
            return this;
        }
        /**
         * Sets the value of IgnorePublicAcls
         * @param value Whether to ignore public ACLs
         * @return {@code this}
         */
        public Builder withIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ignorePublicAcls = value;
            return this;
        }
        /**
         * Sets the value of RestrictPublicBuckets
         * @param value Whether to restrict public access
         * @return {@code this}
         */
        public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._restrictPublicBuckets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BlockPublicAccessOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BlockPublicAccessOptions build() {
            return new BlockPublicAccessOptions() {
                @javax.annotation.Nullable
                private java.lang.Boolean $blockPublicAcls = _blockPublicAcls;
                @javax.annotation.Nullable
                private java.lang.Boolean $blockPublicPolicy = _blockPublicPolicy;
                @javax.annotation.Nullable
                private java.lang.Boolean $ignorePublicAcls = _ignorePublicAcls;
                @javax.annotation.Nullable
                private java.lang.Boolean $restrictPublicBuckets = _restrictPublicBuckets;

                @Override
                public java.lang.Boolean getBlockPublicAcls() {
                    return this.$blockPublicAcls;
                }

                @Override
                public void setBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$blockPublicAcls = value;
                }

                @Override
                public java.lang.Boolean getBlockPublicPolicy() {
                    return this.$blockPublicPolicy;
                }

                @Override
                public void setBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$blockPublicPolicy = value;
                }

                @Override
                public java.lang.Boolean getIgnorePublicAcls() {
                    return this.$ignorePublicAcls;
                }

                @Override
                public void setIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$ignorePublicAcls = value;
                }

                @Override
                public java.lang.Boolean getRestrictPublicBuckets() {
                    return this.$restrictPublicBuckets;
                }

                @Override
                public void setRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$restrictPublicBuckets = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BlockPublicAccessOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Whether to block public ACLs
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getBlockPublicAcls() {
            return this.jsiiGet("blockPublicAcls", java.lang.Boolean.class);
        }

        /**
         * Whether to block public ACLs
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        public void setBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("blockPublicAcls", value);
        }

        /**
         * Whether to block public policy
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getBlockPublicPolicy() {
            return this.jsiiGet("blockPublicPolicy", java.lang.Boolean.class);
        }

        /**
         * Whether to block public policy
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        public void setBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("blockPublicPolicy", value);
        }

        /**
         * Whether to ignore public ACLs
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getIgnorePublicAcls() {
            return this.jsiiGet("ignorePublicAcls", java.lang.Boolean.class);
        }

        /**
         * Whether to ignore public ACLs
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        public void setIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("ignorePublicAcls", value);
        }

        /**
         * Whether to restrict public access
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getRestrictPublicBuckets() {
            return this.jsiiGet("restrictPublicBuckets", java.lang.Boolean.class);
        }

        /**
         * Whether to restrict public access
         * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-options
         */
        @Override
        public void setRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("restrictPublicBuckets", value);
        }
    }
}
