package software.amazon.awscdk.services.s3;

/**
 * A reference to a bucket. The easiest way to instantiate is to call
 * `bucket.export()`. Then, the consumer can use `Bucket.import(this, ref)` and
 * get a `Bucket`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T12:58:45.907Z")
public interface BucketImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the bucket. At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    java.lang.String getBucketArn();
    /**
     * The ARN of the bucket. At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    void setBucketArn(final java.lang.String value);
    /**
     * The domain name of the bucket.
     * @default Inferred from bucket name
     */
    java.lang.String getBucketDomainName();
    /**
     * The domain name of the bucket.
     * @default Inferred from bucket name
     */
    void setBucketDomainName(final java.lang.String value);
    /**
     * The name of the bucket. If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    java.lang.String getBucketName();
    /**
     * The name of the bucket. If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    void setBucketName(final java.lang.String value);
    /**
     * The format of the website URL of the bucket. This should be true for
     * regions launched since 2014.
     * @default false
     */
    java.lang.Boolean getBucketWebsiteNewUrlFormat();
    /**
     * The format of the website URL of the bucket. This should be true for
     * regions launched since 2014.
     * @default false
     */
    void setBucketWebsiteNewUrlFormat(final java.lang.Boolean value);
    /**
     * The website URL of the bucket (if static web hosting is enabled).
     * @default Inferred from bucket name
     */
    java.lang.String getBucketWebsiteUrl();
    /**
     * The website URL of the bucket (if static web hosting is enabled).
     * @default Inferred from bucket name
     */
    void setBucketWebsiteUrl(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link BucketImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketImportProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _bucketArn;
        @javax.annotation.Nullable
        private java.lang.String _bucketDomainName;
        @javax.annotation.Nullable
        private java.lang.String _bucketName;
        @javax.annotation.Nullable
        private java.lang.Boolean _bucketWebsiteNewUrlFormat;
        @javax.annotation.Nullable
        private java.lang.String _bucketWebsiteUrl;

        /**
         * Sets the value of BucketArn
         * @param value The ARN of the bucket. At least one of bucketArn or bucketName must be
defined in order to initialize a bucket ref.
         * @return {@code this}
         */
        public Builder withBucketArn(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketArn = value;
            return this;
        }
        /**
         * Sets the value of BucketDomainName
         * @param value The domain name of the bucket.
         * @return {@code this}
         */
        public Builder withBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketDomainName = value;
            return this;
        }
        /**
         * Sets the value of BucketName
         * @param value The name of the bucket. If the underlying value of ARN is a string, the
name will be parsed from the ARN. Otherwise, the name is optional, but
some features that require the bucket name such as auto-creating a bucket
policy, won't work.
         * @return {@code this}
         */
        public Builder withBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketName = value;
            return this;
        }
        /**
         * Sets the value of BucketWebsiteNewUrlFormat
         * @param value The format of the website URL of the bucket. This should be true for
regions launched since 2014.
         * @return {@code this}
         */
        public Builder withBucketWebsiteNewUrlFormat(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._bucketWebsiteNewUrlFormat = value;
            return this;
        }
        /**
         * Sets the value of BucketWebsiteUrl
         * @param value The website URL of the bucket (if static web hosting is enabled).
         * @return {@code this}
         */
        public Builder withBucketWebsiteUrl(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketWebsiteUrl = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketImportProps build() {
            return new BucketImportProps() {
                @javax.annotation.Nullable
                private java.lang.String $bucketArn = _bucketArn;
                @javax.annotation.Nullable
                private java.lang.String $bucketDomainName = _bucketDomainName;
                @javax.annotation.Nullable
                private java.lang.String $bucketName = _bucketName;
                @javax.annotation.Nullable
                private java.lang.Boolean $bucketWebsiteNewUrlFormat = _bucketWebsiteNewUrlFormat;
                @javax.annotation.Nullable
                private java.lang.String $bucketWebsiteUrl = _bucketWebsiteUrl;

                @Override
                public java.lang.String getBucketArn() {
                    return this.$bucketArn;
                }

                @Override
                public void setBucketArn(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketArn = value;
                }

                @Override
                public java.lang.String getBucketDomainName() {
                    return this.$bucketDomainName;
                }

                @Override
                public void setBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketDomainName = value;
                }

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketName = value;
                }

                @Override
                public java.lang.Boolean getBucketWebsiteNewUrlFormat() {
                    return this.$bucketWebsiteNewUrlFormat;
                }

                @Override
                public void setBucketWebsiteNewUrlFormat(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$bucketWebsiteNewUrlFormat = value;
                }

                @Override
                public java.lang.String getBucketWebsiteUrl() {
                    return this.$bucketWebsiteUrl;
                }

                @Override
                public void setBucketWebsiteUrl(@javax.annotation.Nullable final java.lang.String value) {
                    this.$bucketWebsiteUrl = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketArn() {
            return this.jsiiGet("bucketArn", java.lang.String.class);
        }

        /**
         * The ARN of the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        @Override
        public void setBucketArn(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketArn", value);
        }

        /**
         * The domain name of the bucket.
         * @default Inferred from bucket name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketDomainName() {
            return this.jsiiGet("bucketDomainName", java.lang.String.class);
        }

        /**
         * The domain name of the bucket.
         * @default Inferred from bucket name
         */
        @Override
        public void setBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketDomainName", value);
        }

        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        @Override
        public void setBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketName", value);
        }

        /**
         * The format of the website URL of the bucket. This should be true for
         * regions launched since 2014.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getBucketWebsiteNewUrlFormat() {
            return this.jsiiGet("bucketWebsiteNewUrlFormat", java.lang.Boolean.class);
        }

        /**
         * The format of the website URL of the bucket. This should be true for
         * regions launched since 2014.
         * @default false
         */
        @Override
        public void setBucketWebsiteNewUrlFormat(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("bucketWebsiteNewUrlFormat", value);
        }

        /**
         * The website URL of the bucket (if static web hosting is enabled).
         * @default Inferred from bucket name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketWebsiteUrl() {
            return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
        }

        /**
         * The website URL of the bucket (if static web hosting is enabled).
         * @default Inferred from bucket name
         */
        @Override
        public void setBucketWebsiteUrl(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("bucketWebsiteUrl", value);
        }
    }
}
