package software.amazon.awscdk.services.s3;

/**
 * An S3 bucket with associated policy objects
 * 
 * This bucket does not yet have all features that exposed by the underlying
 * BucketResource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:36:36.814Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Bucket")
public class Bucket extends software.amazon.awscdk.services.s3.BucketBase {
    protected Bucket(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Bucket(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    public Bucket(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    /**
     * Creates a Bucket construct that represents an external bucket.
     * @param id The construct's name.
     * @param props A `BucketAttributes` object. Can be obtained from a call to
`bucket.export()` or manually created.
     */
    public static software.amazon.awscdk.services.s3.IBucket import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.BucketImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "import", software.amazon.awscdk.services.s3.IBucket.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Add a lifecycle rule to the bucket
     * @param rule The rule to add
     */
    public void addLifecycleRule(final software.amazon.awscdk.services.s3.LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(rule, "rule is required")).toArray());
    }

    /**
     * Exports this bucket from the stack.
     */
    @Override
    public software.amazon.awscdk.services.s3.BucketImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.s3.BucketImportProps.class);
    }

    /**
     * Adds a bucket notification event destination.
     * @example bucket.onEvent(EventType.OnObjectCreated, myLambda, 'home/myusername/*')
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
     * @param event The event to trigger the notification
     * @param dest The notification destination (Lambda, SNS Topic or SQS Queue)
     * @param filters S3 object key filter rules to determine which objects
trigger this event. Each filter must include a `prefix` and/or `suffix`
that will be matched against the s3 object key. Refer to the S3 Developer Guide
for details about allowed filter rules.
     */
    public void onEvent(final software.amazon.awscdk.services.s3.EventType event, final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onEvent", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(event, "event is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(dest, "dest is required"))), java.util.Arrays.stream(java.util.Objects.requireNonNull(filters, "filters is required"))).toArray());
    }

    /**
     * Subscribes a destination to receive notificatins when an object is
     * created in the bucket. This is identical to calling
     * `onEvent(EventType.ObjectCreated)`.
     * @param dest The notification destination (see onEvent)
     * @param filters Filters (see onEvent)
     */
    public void onObjectCreated(final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onObjectCreated", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(dest, "dest is required")), java.util.Arrays.stream(java.util.Objects.requireNonNull(filters, "filters is required"))).toArray());
    }

    /**
     * Subscribes a destination to receive notificatins when an object is
     * removed from the bucket. This is identical to calling
     * `onEvent(EventType.ObjectRemoved)`.
     * @param dest The notification destination (see onEvent)
     * @param filters Filters (see onEvent)
     */
    public void onObjectRemoved(final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onObjectRemoved", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(dest, "dest is required")), java.util.Arrays.stream(java.util.Objects.requireNonNull(filters, "filters is required"))).toArray());
    }

    /**
     * The ARN of the bucket.
     */
    @Override
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     * The name of the bucket.
     */
    @Override
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    public java.lang.String getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
    }

    /**
     * The domain of the bucket.
     */
    @Override
    public java.lang.String getDomainName() {
        return this.jsiiGet("domainName", java.lang.String.class);
    }

    public java.lang.String getDualstackDomainName() {
        return this.jsiiGet("dualstackDomainName", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    @Override
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon
     * the first call to `addToResourcePolicy`.
     */
    @Override
    protected void setAutoCreatePolicy(final java.lang.Boolean value) {
        this.jsiiSet("autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    /**
     * Whether to disallow public access
     */
    @Override
    @javax.annotation.Nullable
    protected java.lang.Boolean getDisallowPublicAccess() {
        return this.jsiiGet("disallowPublicAccess", java.lang.Boolean.class);
    }

    /**
     * Whether to disallow public access
     */
    @Override
    protected void setDisallowPublicAccess(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("disallowPublicAccess", value);
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @Override
    public void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
        this.jsiiSet("policy", value);
    }
}
