package software.amazon.awscdk.services.s3;

/**
 * A reference to a bucket. The easiest way to instantiate is to call
 * `bucket.export()`. Then, the consumer can use `Bucket.import(this, ref)` and
 * get a `Bucket`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:36:36.824Z")
public interface BucketImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the bucket. At least one of bucketArn or bucketName must be
     * defined in order to initialize a bucket ref.
     */
    java.lang.String getBucketArn();
    /**
     * The domain name of the bucket.
     * @default Inferred from bucket name
     */
    java.lang.String getBucketDomainName();
    /**
     * The name of the bucket. If the underlying value of ARN is a string, the
     * name will be parsed from the ARN. Otherwise, the name is optional, but
     * some features that require the bucket name such as auto-creating a bucket
     * policy, won't work.
     */
    java.lang.String getBucketName();
    /**
     * The format of the website URL of the bucket. This should be true for
     * regions launched since 2014.
     * @default false
     */
    java.lang.Boolean getBucketWebsiteNewUrlFormat();
    /**
     * The website URL of the bucket (if static web hosting is enabled).
     * @default Inferred from bucket name
     */
    java.lang.String getBucketWebsiteUrl();

    /**
     * @return a {@link Builder} of {@link BucketImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketImportProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _bucketArn;
        @javax.annotation.Nullable
        private java.lang.String _bucketDomainName;
        @javax.annotation.Nullable
        private java.lang.String _bucketName;
        @javax.annotation.Nullable
        private java.lang.Boolean _bucketWebsiteNewUrlFormat;
        @javax.annotation.Nullable
        private java.lang.String _bucketWebsiteUrl;

        /**
         * Sets the value of BucketArn
         * @param value The ARN of the bucket. At least one of bucketArn or bucketName must be
defined in order to initialize a bucket ref.
         * @return {@code this}
         */
        public Builder withBucketArn(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketArn = value;
            return this;
        }
        /**
         * Sets the value of BucketDomainName
         * @param value The domain name of the bucket.
         * @return {@code this}
         */
        public Builder withBucketDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketDomainName = value;
            return this;
        }
        /**
         * Sets the value of BucketName
         * @param value The name of the bucket. If the underlying value of ARN is a string, the
name will be parsed from the ARN. Otherwise, the name is optional, but
some features that require the bucket name such as auto-creating a bucket
policy, won't work.
         * @return {@code this}
         */
        public Builder withBucketName(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketName = value;
            return this;
        }
        /**
         * Sets the value of BucketWebsiteNewUrlFormat
         * @param value The format of the website URL of the bucket. This should be true for
regions launched since 2014.
         * @return {@code this}
         */
        public Builder withBucketWebsiteNewUrlFormat(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._bucketWebsiteNewUrlFormat = value;
            return this;
        }
        /**
         * Sets the value of BucketWebsiteUrl
         * @param value The website URL of the bucket (if static web hosting is enabled).
         * @return {@code this}
         */
        public Builder withBucketWebsiteUrl(@javax.annotation.Nullable final java.lang.String value) {
            this._bucketWebsiteUrl = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketImportProps build() {
            return new BucketImportProps() {
                @javax.annotation.Nullable
                private final java.lang.String $bucketArn = _bucketArn;
                @javax.annotation.Nullable
                private final java.lang.String $bucketDomainName = _bucketDomainName;
                @javax.annotation.Nullable
                private final java.lang.String $bucketName = _bucketName;
                @javax.annotation.Nullable
                private final java.lang.Boolean $bucketWebsiteNewUrlFormat = _bucketWebsiteNewUrlFormat;
                @javax.annotation.Nullable
                private final java.lang.String $bucketWebsiteUrl = _bucketWebsiteUrl;

                @Override
                public java.lang.String getBucketArn() {
                    return this.$bucketArn;
                }

                @Override
                public java.lang.String getBucketDomainName() {
                    return this.$bucketDomainName;
                }

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public java.lang.Boolean getBucketWebsiteNewUrlFormat() {
                    return this.$bucketWebsiteNewUrlFormat;
                }

                @Override
                public java.lang.String getBucketWebsiteUrl() {
                    return this.$bucketWebsiteUrl;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                    obj.set("bucketDomainName", om.valueToTree(this.getBucketDomainName()));
                    obj.set("bucketName", om.valueToTree(this.getBucketName()));
                    obj.set("bucketWebsiteNewUrlFormat", om.valueToTree(this.getBucketWebsiteNewUrlFormat()));
                    obj.set("bucketWebsiteUrl", om.valueToTree(this.getBucketWebsiteUrl()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the bucket. At least one of bucketArn or bucketName must be
         * defined in order to initialize a bucket ref.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketArn() {
            return this.jsiiGet("bucketArn", java.lang.String.class);
        }

        /**
         * The domain name of the bucket.
         * @default Inferred from bucket name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketDomainName() {
            return this.jsiiGet("bucketDomainName", java.lang.String.class);
        }

        /**
         * The name of the bucket. If the underlying value of ARN is a string, the
         * name will be parsed from the ARN. Otherwise, the name is optional, but
         * some features that require the bucket name such as auto-creating a bucket
         * policy, won't work.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The format of the website URL of the bucket. This should be true for
         * regions launched since 2014.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getBucketWebsiteNewUrlFormat() {
            return this.jsiiGet("bucketWebsiteNewUrlFormat", java.lang.Boolean.class);
        }

        /**
         * The website URL of the bucket (if static web hosting is enabled).
         * @default Inferred from bucket name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getBucketWebsiteUrl() {
            return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
        }
    }
}
