package software.amazon.awscdk.services.s3;

/**
 * Common properties for creating {@link PipelineDeployAction} -
 * either directly, through its constructor,
 * or through {@link IBucket#toCodePipelineDeployAction}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:36:36.874Z")
public interface CommonPipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * The inputArtifact to deploy to Amazon S3.
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * Should the deploy action extract the artifact before deploying to Amazon S3.
     * @default true
     */
    java.lang.Boolean getExtract();
    /**
     * The key of the target object. This is required if extract is false.
     */
    java.lang.String getObjectKey();

    /**
     * @return a {@link Builder} of {@link CommonPipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CommonPipelineDeployActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.Boolean _extract;
        @javax.annotation.Nullable
        private java.lang.String _objectKey;
        private java.lang.String _actionName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of InputArtifact
         * @param value The inputArtifact to deploy to Amazon S3.
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of Extract
         * @param value Should the deploy action extract the artifact before deploying to Amazon S3.
         * @return {@code this}
         */
        public Builder withExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._extract = value;
            return this;
        }
        /**
         * Sets the value of ObjectKey
         * @param value The key of the target object. This is required if extract is false.
         * @return {@code this}
         */
        public Builder withObjectKey(@javax.annotation.Nullable final java.lang.String value) {
            this._objectKey = value;
            return this;
        }
        /**
         * Sets the value of ActionName
         * @param value The physical, human-readable name of the Action.
Not that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        public Builder withActionName(final java.lang.String value) {
            this._actionName = java.util.Objects.requireNonNull(value, "actionName is required");
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonPipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CommonPipelineDeployActionProps build() {
            return new CommonPipelineDeployActionProps() {
                private final software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $extract = _extract;
                @javax.annotation.Nullable
                private final java.lang.String $objectKey = _objectKey;
                private final java.lang.String $actionName = java.util.Objects.requireNonNull(_actionName, "actionName is required");
                @javax.annotation.Nullable
                private final java.lang.Number $runOrder = _runOrder;

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public java.lang.Boolean getExtract() {
                    return this.$extract;
                }

                @Override
                public java.lang.String getObjectKey() {
                    return this.$objectKey;
                }

                @Override
                public java.lang.String getActionName() {
                    return this.$actionName;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("inputArtifact", om.valueToTree(this.getInputArtifact()));
                    obj.set("extract", om.valueToTree(this.getExtract()));
                    obj.set("objectKey", om.valueToTree(this.getObjectKey()));
                    obj.set("actionName", om.valueToTree(this.getActionName()));
                    obj.set("runOrder", om.valueToTree(this.getRunOrder()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The inputArtifact to deploy to Amazon S3.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * Should the deploy action extract the artifact before deploying to Amazon S3.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getExtract() {
            return this.jsiiGet("extract", java.lang.Boolean.class);
        }

        /**
         * The key of the target object. This is required if extract is false.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getObjectKey() {
            return this.jsiiGet("objectKey", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public java.lang.String getActionName() {
            return this.jsiiGet("actionName", java.lang.String.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }
    }
}
