package software.amazon.awscdk.services.s3;

/**
 * Construction properties of the {@link PipelineDeployAction S3 deploy Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:36:36.891Z")
public interface PipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps {
    /**
     * The Amazon S3 bucket that is the deploy target.
     */
    software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * @return a {@link Builder} of {@link PipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineDeployActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.IBucket _bucket;
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.Boolean _extract;
        @javax.annotation.Nullable
        private java.lang.String _objectKey;
        private java.lang.String _actionName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of Bucket
         * @param value The Amazon S3 bucket that is the deploy target.
         * @return {@code this}
         */
        public Builder withBucket(final software.amazon.awscdk.services.s3.IBucket value) {
            this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The inputArtifact to deploy to Amazon S3.
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of Extract
         * @param value Should the deploy action extract the artifact before deploying to Amazon S3.
         * @return {@code this}
         */
        public Builder withExtract(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._extract = value;
            return this;
        }
        /**
         * Sets the value of ObjectKey
         * @param value The key of the target object. This is required if extract is false.
         * @return {@code this}
         */
        public Builder withObjectKey(@javax.annotation.Nullable final java.lang.String value) {
            this._objectKey = value;
            return this;
        }
        /**
         * Sets the value of ActionName
         * @param value The physical, human-readable name of the Action.
Not that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        public Builder withActionName(final java.lang.String value) {
            this._actionName = java.util.Objects.requireNonNull(value, "actionName is required");
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps() {
                private final software.amazon.awscdk.services.s3.IBucket $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                private final software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $extract = _extract;
                @javax.annotation.Nullable
                private final java.lang.String $objectKey = _objectKey;
                private final java.lang.String $actionName = java.util.Objects.requireNonNull(_actionName, "actionName is required");
                @javax.annotation.Nullable
                private final java.lang.Number $runOrder = _runOrder;

                @Override
                public software.amazon.awscdk.services.s3.IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public java.lang.Boolean getExtract() {
                    return this.$extract;
                }

                @Override
                public java.lang.String getObjectKey() {
                    return this.$objectKey;
                }

                @Override
                public java.lang.String getActionName() {
                    return this.$actionName;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("bucket", om.valueToTree(this.getBucket()));
                    obj.set("inputArtifact", om.valueToTree(this.getInputArtifact()));
                    obj.set("extract", om.valueToTree(this.getExtract()));
                    obj.set("objectKey", om.valueToTree(this.getObjectKey()));
                    obj.set("actionName", om.valueToTree(this.getActionName()));
                    obj.set("runOrder", om.valueToTree(this.getRunOrder()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.PipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon S3 bucket that is the deploy target.
         */
        @Override
        public software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.IBucket.class);
        }

        /**
         * The inputArtifact to deploy to Amazon S3.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * Should the deploy action extract the artifact before deploying to Amazon S3.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getExtract() {
            return this.jsiiGet("extract", java.lang.Boolean.class);
        }

        /**
         * The key of the target object. This is required if extract is false.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getObjectKey() {
            return this.jsiiGet("objectKey", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public java.lang.String getActionName() {
            return this.jsiiGet("actionName", java.lang.String.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }
    }
}
