/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codepipeline.api.Artifact;
import software.amazon.awscdk.services.s3.CommonPipelineDeployActionProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineDeployActionProps
extends JsiiSerializable,
CommonPipelineDeployActionProps {
    public IBucket getBucket();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        private Artifact _inputArtifact;
        @Nullable
        private Boolean _extract;
        @Nullable
        private String _objectKey;
        private String _actionName;
        @Nullable
        private Number _runOrder;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withInputArtifact(Artifact value) {
            this._inputArtifact = Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }

        public Builder withExtract(@Nullable Boolean value) {
            this._extract = value;
            return this;
        }

        public Builder withObjectKey(@Nullable String value) {
            this._objectKey = value;
            return this;
        }

        public Builder withActionName(String value) {
            this._actionName = Objects.requireNonNull(value, "actionName is required");
            return this;
        }

        public Builder withRunOrder(@Nullable Number value) {
            this._runOrder = value;
            return this;
        }

        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps(){
                private final IBucket $bucket;
                private final Artifact $inputArtifact;
                @Nullable
                private final Boolean $extract;
                @Nullable
                private final String $objectKey;
                private final String $actionName;
                @Nullable
                private final Number $runOrder;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$inputArtifact = Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                    this.$extract = _extract;
                    this.$objectKey = _objectKey;
                    this.$actionName = Objects.requireNonNull(_actionName, "actionName is required");
                    this.$runOrder = _runOrder;
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public Boolean getExtract() {
                    return this.$extract;
                }

                @Override
                public String getObjectKey() {
                    return this.$objectKey;
                }

                public String getActionName() {
                    return this.$actionName;
                }

                public Number getRunOrder() {
                    return this.$runOrder;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("bucket", om.valueToTree((Object)this.getBucket()));
                    obj.set("inputArtifact", om.valueToTree((Object)this.getInputArtifact()));
                    obj.set("extract", om.valueToTree((Object)this.getExtract()));
                    obj.set("objectKey", om.valueToTree((Object)this.getObjectKey()));
                    obj.set("actionName", om.valueToTree((Object)this.getActionName()));
                    obj.set("runOrder", om.valueToTree((Object)this.getRunOrder()));
                    return obj;
                }
            };
        }
    }
}

