/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.s3.CommonPipelineSourceActionProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineSourceActionProps
extends JsiiSerializable,
CommonPipelineSourceActionProps {
    public IBucket getBucket();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _bucket;
        private String _bucketKey;
        @Nullable
        private String _outputArtifactName;
        @Nullable
        private Boolean _pollForSourceChanges;
        private String _actionName;
        @Nullable
        private Number _runOrder;

        public Builder withBucket(IBucket value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withBucketKey(String value) {
            this._bucketKey = Objects.requireNonNull(value, "bucketKey is required");
            return this;
        }

        public Builder withOutputArtifactName(@Nullable String value) {
            this._outputArtifactName = value;
            return this;
        }

        public Builder withPollForSourceChanges(@Nullable Boolean value) {
            this._pollForSourceChanges = value;
            return this;
        }

        public Builder withActionName(String value) {
            this._actionName = Objects.requireNonNull(value, "actionName is required");
            return this;
        }

        public Builder withRunOrder(@Nullable Number value) {
            this._runOrder = value;
            return this;
        }

        public PipelineSourceActionProps build() {
            return new PipelineSourceActionProps(){
                private final IBucket $bucket;
                private final String $bucketKey;
                @Nullable
                private final String $outputArtifactName;
                @Nullable
                private final Boolean $pollForSourceChanges;
                private final String $actionName;
                @Nullable
                private final Number $runOrder;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$bucketKey = Objects.requireNonNull(_bucketKey, "bucketKey is required");
                    this.$outputArtifactName = _outputArtifactName;
                    this.$pollForSourceChanges = _pollForSourceChanges;
                    this.$actionName = Objects.requireNonNull(_actionName, "actionName is required");
                    this.$runOrder = _runOrder;
                }

                @Override
                public IBucket getBucket() {
                    return this.$bucket;
                }

                @Override
                public String getBucketKey() {
                    return this.$bucketKey;
                }

                @Override
                public String getOutputArtifactName() {
                    return this.$outputArtifactName;
                }

                @Override
                public Boolean getPollForSourceChanges() {
                    return this.$pollForSourceChanges;
                }

                public String getActionName() {
                    return this.$actionName;
                }

                public Number getRunOrder() {
                    return this.$runOrder;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("bucket", om.valueToTree((Object)this.getBucket()));
                    obj.set("bucketKey", om.valueToTree((Object)this.getBucketKey()));
                    obj.set("outputArtifactName", om.valueToTree((Object)this.getOutputArtifactName()));
                    obj.set("pollForSourceChanges", om.valueToTree((Object)this.getPollForSourceChanges()));
                    obj.set("actionName", om.valueToTree((Object)this.getActionName()));
                    obj.set("runOrder", om.valueToTree((Object)this.getRunOrder()));
                    return obj;
                }
            };
        }
    }
}

