package software.amazon.awscdk.services.s3;

/**
 * Describes when an object transitions to a specified storage class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:05:55.780Z")
public interface Transition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     */
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * @default No transition date.
     */
    java.time.Instant getTransitionDate();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * @default No transition count.
     */
    java.lang.Number getTransitionInDays();

    /**
     * @return a {@link Builder} of {@link Transition}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Transition}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.StorageClass _storageClass;
        @javax.annotation.Nullable
        private java.time.Instant _transitionDate;
        @javax.annotation.Nullable
        private java.lang.Number _transitionInDays;

        /**
         * Sets the value of StorageClass
         * @param value The storage class to which you want the object to transition.
         * @return {@code this}
         */
        public Builder withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
            return this;
        }
        /**
         * Sets the value of TransitionDate
         * @param value Indicates when objects are transitioned to the specified storage class.

The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @return {@code this}
         */
        public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
            this._transitionDate = value;
            return this;
        }
        /**
         * Sets the value of TransitionInDays
         * @param value Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        public Builder withTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this._transitionInDays = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Transition}
         * @throws NullPointerException if any required attribute was not provided
         */
        public Transition build() {
            return new Transition() {
                private final software.amazon.awscdk.services.s3.StorageClass $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                @javax.annotation.Nullable
                private final java.time.Instant $transitionDate = _transitionDate;
                @javax.annotation.Nullable
                private final java.lang.Number $transitionInDays = _transitionInDays;

                @Override
                public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public java.time.Instant getTransitionDate() {
                    return this.$transitionDate;
                }

                @Override
                public java.lang.Number getTransitionInDays() {
                    return this.$transitionInDays;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                    obj.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                    obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.Transition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The storage class to which you want the object to transition.
         */
        @Override
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }

        /**
         * Indicates when objects are transitioned to the specified storage class.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * @default No transition date.
         */
        @Override
        @javax.annotation.Nullable
        public java.time.Instant getTransitionDate() {
            return this.jsiiGet("transitionDate", java.time.Instant.class);
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @default No transition count.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getTransitionInDays() {
            return this.jsiiGet("transitionInDays", java.lang.Number.class);
        }
    }
}
