package software.amazon.awscdk.services.s3;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:45.552Z")
public interface BucketPolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The Amazon S3 bucket that the policy applies to.
     */
    software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * @return a {@link Builder} of {@link BucketPolicyProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketPolicyProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.s3.IBucket _bucket;

        /**
         * Sets the value of Bucket
         * @param value The Amazon S3 bucket that the policy applies to.
         * @return {@code this}
         */
        public Builder withBucket(final software.amazon.awscdk.services.s3.IBucket value) {
            this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BucketPolicyProps build() {
            return new BucketPolicyProps() {
                private final software.amazon.awscdk.services.s3.IBucket $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");

                @Override
                public software.amazon.awscdk.services.s3.IBucket getBucket() {
                    return this.$bucket;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("bucket", om.valueToTree(this.getBucket()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketPolicyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The Amazon S3 bucket that the policy applies to.
         */
        @Override
        public software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.jsiiGet("bucket", software.amazon.awscdk.services.s3.IBucket.class);
        }
    }
}
