package software.amazon.awscdk.services.s3;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:45.617Z")
public interface IBucket extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource {
    /**
     * The ARN of the bucket.
     */
    java.lang.String getBucketArn();
    /**
     * The name of the bucket.
     */
    java.lang.String getBucketName();
    /**
     * The https:// URL of this bucket.
     * 
     * Example:
     * 
     * https://s3.us-west-1.amazonaws.com/onlybucket
     * Similar to calling `urlForObject` with no object key.
     */
    java.lang.String getBucketUrl();
    /**
     * The domain of the bucket.
     */
    java.lang.String getDomainName();
    /**
     * Optional KMS encryption key associated with this bucket.
     */
    software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey();
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    software.amazon.awscdk.services.s3.BucketPolicy getPolicy();
    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    void setPolicy(final software.amazon.awscdk.services.s3.BucketPolicy value);
    /**
     * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or it's contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
     */
    void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement permission);
    /**
     * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
     * 
     * To represent all keys, specify ``"*"``.
     * 
     * If you specify multiple components for keyPattern, they will be concatenated::
     * 
     *    arnForObjects('home/', team, '/', user, '/*')
     */
    java.lang.String arnForObjects(final java.lang.String... keyPattern);
    /**
     * Exports this bucket from the stack.
     */
    software.amazon.awscdk.services.s3.BucketImportProps export();
    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal.
     */
    software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity);
    /**
     * Allows unrestricted access to objects from this bucket.
     * 
     * IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.
     * 
     * Without arguments, this method will grant read ("s3:GetObject") access to
     * all objects ("*") in the bucket.
     * 
     * The method returns the `iam.PolicyStatement` object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:
     * 
     *      const statement = bucket.grantPublicAccess();
     *      statement.addCondition('IpAddress', { "aws:SourceIp": "54.240.143.0/24" });
     * 
     * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
     * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
     * @param allowedActions the set of S3 actions to allow.
     */
    software.amazon.awscdk.services.iam.Grant grantPublicAccess(@javax.annotation.Nullable final java.lang.String keyPrefix, final java.lang.String... allowedActions);
    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity);
    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity);
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * 
     * @param identity The principal.
     */
    software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity);
    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern);
    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity);
    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     * 
     * @return a new {@link events.EventRule} instance
     * @param name the logical ID of the newly created Event Rule.
     * @param target the optional target of the Event Rule.
     * @param path the optional path inside the Bucket that will be watched for changes.
     */
    software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final java.lang.String path);
    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     * 
     * @return a new {@link events.EventRule} instance
     * @param name the logical ID of the newly created Event Rule.
     * @param target the optional target of the Event Rule.
     */
    software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target);
    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     * 
     * @return a new {@link events.EventRule} instance
     * @param name the logical ID of the newly created Event Rule.
     */
    software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name);
    /**
     * The https URL of an S3 object.
     * 
     * For example:
     * 
     * Example:
     * 
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * 
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    java.lang.String urlForObject(@javax.annotation.Nullable final java.lang.String key);
    /**
     * The https URL of an S3 object.
     * 
     * For example:
     * 
     * Example:
     * 
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * 
     * @return an ObjectS3Url token
     */
    java.lang.String urlForObject();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.IBucket {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the bucket.
         */
        @Override
        public java.lang.String getBucketArn() {
            return this.jsiiGet("bucketArn", java.lang.String.class);
        }

        /**
         * The name of the bucket.
         */
        @Override
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The https:// URL of this bucket.
         * 
         * Example:
         * 
         * https://s3.us-west-1.amazonaws.com/onlybucket
         * Similar to calling `urlForObject` with no object key.
         */
        @Override
        public java.lang.String getBucketUrl() {
            return this.jsiiGet("bucketUrl", java.lang.String.class);
        }

        /**
         * The domain of the bucket.
         */
        @Override
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Optional KMS encryption key associated with this bucket.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
        }

        /**
         * The resource policy assoicated with this bucket.
         * 
         * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
            return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
        }

        /**
         * The resource policy assoicated with this bucket.
         * 
         * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
         * first call to addToResourcePolicy(s).
         */
        @Override
        public void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
            this.jsiiSet("policy", value);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable.
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or it's contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
         */
        @Override
        public void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement permission) {
            this.jsiiCall("addToResourcePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(permission, "permission is required") });
        }

        /**
         * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
         * 
         * To represent all keys, specify ``"*"``.
         * 
         * If you specify multiple components for keyPattern, they will be concatenated::
         * 
         *    arnForObjects('home/', team, '/', user, '/*')
         */
        @Override
        public java.lang.String arnForObjects(final java.lang.String... keyPattern) {
            return this.jsiiCall("arnForObjects", java.lang.String.class, java.util.Arrays.<Object>stream(keyPattern).toArray(Object[]::new));
        }

        /**
         * Exports this bucket from the stack.
         */
        @Override
        public software.amazon.awscdk.services.s3.BucketImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.s3.BucketImportProps.class);
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
         * 
         * @param identity The principal.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
         * 
         * @param identity The principal.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Allows unrestricted access to objects from this bucket.
         * 
         * IMPORTANT: This permission allows anyone to perform actions on S3 objects
         * in this bucket, which is useful for when you configure your bucket as a
         * website and want everyone to be able to read objects in the bucket without
         * needing to authenticate.
         * 
         * Without arguments, this method will grant read ("s3:GetObject") access to
         * all objects ("*") in the bucket.
         * 
         * The method returns the `iam.PolicyStatement` object, which can then be modified
         * as needed. For example, you can add a condition that will restrict access only
         * to an IPv4 range like this:
         * 
         *      const statement = bucket.grantPublicAccess();
         *      statement.addCondition('IpAddress', { "aws:SourceIp": "54.240.143.0/24" });
         * 
         * @return The `iam.PolicyStatement` object, which can be used to apply e.g. conditions.
         * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
         * @param allowedActions the set of S3 actions to allow.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantPublicAccess(@javax.annotation.Nullable final java.lang.String keyPrefix, final java.lang.String... allowedActions) {
            return this.jsiiCall("grantPublicAccess", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * 
         * @param identity The principal.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * 
         * @param identity The principal.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * 
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * 
         * @param identity The principal.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * 
         * If encryption is used, permission to use the key to decrypt the contents
         * of the bucket will also be granted to the same principal.
         * 
         * @param identity The principal.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * 
         * @param identity The principal.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * 
         * @param identity The principal.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * 
         * @param identity The principal.
         * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
            return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
        }

        /**
         * Grant write permissions to this bucket to an IAM principal.
         * 
         * If encryption is used, permission to use the key to encrypt the contents
         * of written files will also be granted to the same principal.
         * 
         * @param identity The principal.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
            return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
         * 
         * @return a new {@link events.EventRule} instance
         * @param name the logical ID of the newly created Event Rule.
         * @param target the optional target of the Event Rule.
         * @param path the optional path inside the Bucket that will be watched for changes.
         */
        @Override
        public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final java.lang.String path) {
            return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target, path });
        }

        /**
         * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
         * 
         * @return a new {@link events.EventRule} instance
         * @param name the logical ID of the newly created Event Rule.
         * @param target the optional target of the Event Rule.
         */
        @Override
        public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
            return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target });
        }

        /**
         * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
         * 
         * @return a new {@link events.EventRule} instance
         * @param name the logical ID of the newly created Event Rule.
         */
        @Override
        public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name) {
            return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
        }

        /**
         * The https URL of an S3 object.
         * 
         * For example:
         * 
         * Example:
         * 
         * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
         * 
         * @return an ObjectS3Url token
         * @param key The S3 key of the object.
         */
        @Override
        public java.lang.String urlForObject(@javax.annotation.Nullable final java.lang.String key) {
            return this.jsiiCall("urlForObject", java.lang.String.class, new Object[] { key });
        }

        /**
         * The https URL of an S3 object.
         * 
         * For example:
         * 
         * Example:
         * 
         * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
         * 
         * @return an ObjectS3Url token
         */
        @Override
        public java.lang.String urlForObject() {
            return this.jsiiCall("urlForObject", java.lang.String.class);
        }
    }
}
