package software.amazon.awscdk.services.s3;

/**
 * An S3 bucket with associated policy objects.
 * 
 * This bucket does not yet have all features that exposed by the underlying
 * BucketResource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:00.659Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.Bucket")
public class Bucket extends software.amazon.awscdk.Resource {
    protected Bucket(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Bucket(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    public Bucket(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Creates a Bucket construct that represents an external bucket.
     * 
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param props A `BucketAttributes` object.
     */
    public static software.amazon.awscdk.services.s3.IBucket import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.s3.BucketImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.Bucket.class, "import", software.amazon.awscdk.services.s3.IBucket.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a lifecycle rule to the bucket.
     * 
     * @param rule The rule to add.
     */
    public void addLifecycleRule(final software.amazon.awscdk.services.s3.LifecycleRule rule) {
        this.jsiiCall("addLifecycleRule", Void.class, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or it's contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.
     */
    public void addToResourcePolicy(final software.amazon.awscdk.services.iam.PolicyStatement permission) {
        this.jsiiCall("addToResourcePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * Returns an ARN that represents all objects within the bucket that match the key pattern specified.
     * 
     * To represent all keys, specify ``"*"``.
     * 
     * If you specify multiple components for keyPattern, they will be concatenated::
     * 
     *    arnForObjects('home/', team, '/', user, '/*')
     */
    public java.lang.String arnForObjects(final java.lang.String... keyPattern) {
        return this.jsiiCall("arnForObjects", java.lang.String.class, java.util.Arrays.<Object>stream(keyPattern).toArray(Object[]::new));
    }

    /**
     * Exports this bucket from the stack.
     */
    public software.amazon.awscdk.services.s3.BucketImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.s3.BucketImportProps.class);
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM pricipal for objects in this bucket.
     * 
     * @param identity The principal.
     */
    public software.amazon.awscdk.services.iam.Grant grantDelete(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantDelete", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Allows unrestricted access to objects from this bucket.
     * 
     * IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.
     * 
     * Without arguments, this method will grant read ("s3:GetObject") access to
     * all objects ("*") in the bucket.
     * 
     * The method returns the `iam.Grant` object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:
     * 
     *      const grant = bucket.grantPublicAccess();
     *      grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
     * 
     * @param keyPrefix the prefix of S3 object keys (e.g. `home/*`). Default is "*".
     * @param allowedActions the set of S3 actions to allow.
     */
    public software.amazon.awscdk.services.iam.Grant grantPublicAccess(@javax.annotation.Nullable final java.lang.String keyPrefix, final java.lang.String... allowedActions) {
        return this.jsiiCall("grantPublicAccess", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    public software.amazon.awscdk.services.iam.Grant grantPut(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantPut", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * 
     * @param identity The principal.
     */
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity, @javax.annotation.Nullable final java.lang.Object objectsKeyPattern) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant write permissions to this bucket to an IAM principal.
     * 
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * 
     * @param identity The principal.
     */
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Adds a bucket notification event destination.
     * 
     * Example:
     * 
     * bucket.onEvent(EventType.OnObjectCreated, myLambda, 'home/myusername/*')
     * 
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html
     * @param event The event to trigger the notification.
     * @param dest The notification destination (Lambda, SNS Topic or SQS Queue).
     * @param filters S3 object key filter rules to determine which objects trigger this event.
     */
    public void onEvent(final software.amazon.awscdk.services.s3.EventType event, final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onEvent", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(event, "event is required"), java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Subscribes a destination to receive notificatins when an object is created in the bucket.
     * 
     * This is identical to calling
     * `onEvent(EventType.ObjectCreated)`.
     * 
     * @param dest The notification destination (see onEvent).
     * @param filters Filters (see onEvent).
     */
    public void onObjectCreated(final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onObjectCreated", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Subscribes a destination to receive notificatins when an object is removed from the bucket.
     * 
     * This is identical to calling
     * `onEvent(EventType.ObjectRemoved)`.
     * 
     * @param dest The notification destination (see onEvent).
     * @param filters Filters (see onEvent).
     */
    public void onObjectRemoved(final software.amazon.awscdk.services.s3.notifications.IBucketNotificationDestination dest, final software.amazon.awscdk.services.s3.NotificationKeyFilter... filters) {
        this.jsiiCall("onObjectRemoved", Void.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") }), java.util.Arrays.<Object>stream(filters)).toArray(Object[]::new));
    }

    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     */
    public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final java.lang.String path) {
        return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target, path });
    }

    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     */
    public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target });
    }

    /**
     * Defines a CloudWatch Event Rule that triggers upon putting an object into the Bucket.
     */
    public software.amazon.awscdk.services.events.EventRule onPutObject(final java.lang.String name) {
        return this.jsiiCall("onPutObject", software.amazon.awscdk.services.events.EventRule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * The https URL of an S3 object.
     * 
     * For example:
     * 
     * Example:
     * 
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * 
     * @return an ObjectS3Url token
     * @param key The S3 key of the object.
     */
    public java.lang.String urlForObject(@javax.annotation.Nullable final java.lang.String key) {
        return this.jsiiCall("urlForObject", java.lang.String.class, new Object[] { key });
    }

    /**
     * The https URL of an S3 object.
     * 
     * For example:
     * 
     * Example:
     * 
     * https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey
     * 
     * @return an ObjectS3Url token
     */
    public java.lang.String urlForObject() {
        return this.jsiiCall("urlForObject", java.lang.String.class);
    }

    /**
     * The ARN of the bucket.
     */
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     * The IPv4 DNS name of the specified bucket.
     */
    public java.lang.String getBucketDomainName() {
        return this.jsiiGet("bucketDomainName", java.lang.String.class);
    }

    /**
     * The IPv6 DNS name of the specified bucket.
     */
    public java.lang.String getBucketDualStackDomainName() {
        return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
    }

    /**
     * The name of the bucket.
     */
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     * The regional domain name of the specified bucket.
     */
    public java.lang.String getBucketRegionalDomainName() {
        return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
    }

    /**
     * The https:// URL of this bucket.
     * 
     * Example:
     * 
     * https://s3.us-west-1.amazonaws.com/onlybucket
     * Similar to calling `urlForObject` with no object key.
     */
    public java.lang.String getBucketUrl() {
        return this.jsiiGet("bucketUrl", java.lang.String.class);
    }

    public java.lang.String getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this bucket.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    protected java.lang.Boolean getAutoCreatePolicy() {
        return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
    }

    /**
     * Indicates if a bucket resource policy should automatically created upon the first call to `addToResourcePolicy`.
     */
    protected void setAutoCreatePolicy(final java.lang.Boolean value) {
        this.jsiiSet("autoCreatePolicy", java.util.Objects.requireNonNull(value, "autoCreatePolicy is required"));
    }

    /**
     * Whether to disallow public access.
     */
    @javax.annotation.Nullable
    protected java.lang.Boolean getDisallowPublicAccess() {
        return this.jsiiGet("disallowPublicAccess", java.lang.Boolean.class);
    }

    /**
     * Whether to disallow public access.
     */
    protected void setDisallowPublicAccess(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("disallowPublicAccess", value);
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.s3.BucketPolicy getPolicy() {
        return this.jsiiGet("policy", software.amazon.awscdk.services.s3.BucketPolicy.class);
    }

    /**
     * The resource policy assoicated with this bucket.
     * 
     * If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
     * first call to addToResourcePolicy(s).
     */
    public void setPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.BucketPolicy value) {
        this.jsiiSet("policy", value);
    }
}
