package software.amazon.awscdk.services.s3;

/**
 * A CloudFormation `AWS::S3::Bucket`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:00.668Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.CfnResource {
    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnBucket.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::S3::Bucket`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnBucket(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::S3::Bucket`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    public CfnBucket(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     */
    public java.lang.String getBucketArn() {
        return this.jsiiGet("bucketArn", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getBucketDomainName() {
        return this.jsiiGet("bucketDomainName", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getBucketDualStackDomainName() {
        return this.jsiiGet("bucketDualStackDomainName", java.lang.String.class);
    }

    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getBucketRegionalDomainName() {
        return this.jsiiGet("bucketRegionalDomainName", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getBucketWebsiteUrl() {
        return this.jsiiGet("bucketWebsiteUrl", java.lang.String.class);
    }

    public software.amazon.awscdk.services.s3.CfnBucketProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.s3.CfnBucketProps.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        java.lang.Object getDaysAfterInitiation();

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        final class Builder {
            private java.lang.Object _daysAfterInitiation;

            /**
             * Sets the value of DaysAfterInitiation
             * @param value `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
             * @return {@code this}
             */
            public Builder withDaysAfterInitiation(final java.lang.Number value) {
                this._daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }
            /**
             * Sets the value of DaysAfterInitiation
             * @param value `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
             * @return {@code this}
             */
            public Builder withDaysAfterInitiation(final software.amazon.awscdk.Token value) {
                this._daysAfterInitiation = java.util.Objects.requireNonNull(value, "daysAfterInitiation is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AbortIncompleteMultipartUploadProperty build() {
                return new AbortIncompleteMultipartUploadProperty() {
                    private final java.lang.Object $daysAfterInitiation = java.util.Objects.requireNonNull(_daysAfterInitiation, "daysAfterInitiation is required");

                    @Override
                    public java.lang.Object getDaysAfterInitiation() {
                        return this.$daysAfterInitiation;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
             */
            @Override
            public java.lang.Object getDaysAfterInitiation() {
                return this.jsiiGet("daysAfterInitiation", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    public static interface AccelerateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        java.lang.String getAccelerationStatus();

        /**
         * @return a {@link Builder} of {@link AccelerateConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccelerateConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _accelerationStatus;

            /**
             * Sets the value of AccelerationStatus
             * @param value `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
             * @return {@code this}
             */
            public Builder withAccelerationStatus(final java.lang.String value) {
                this._accelerationStatus = java.util.Objects.requireNonNull(value, "accelerationStatus is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccelerateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccelerateConfigurationProperty build() {
                return new AccelerateConfigurationProperty() {
                    private final java.lang.String $accelerationStatus = java.util.Objects.requireNonNull(_accelerationStatus, "accelerationStatus is required");

                    @Override
                    public java.lang.String getAccelerationStatus() {
                        return this.$accelerationStatus;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("accelerationStatus", om.valueToTree(this.getAccelerationStatus()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AccelerateConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
             */
            @Override
            public java.lang.String getAccelerationStatus() {
                return this.jsiiGet("accelerationStatus", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    public static interface AccessControlTranslationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AccessControlTranslationProperty.Owner`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        java.lang.String getOwner();

        /**
         * @return a {@link Builder} of {@link AccessControlTranslationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AccessControlTranslationProperty}
         */
        final class Builder {
            private java.lang.String _owner;

            /**
             * Sets the value of Owner
             * @param value `CfnBucket.AccessControlTranslationProperty.Owner`.
             * @return {@code this}
             */
            public Builder withOwner(final java.lang.String value) {
                this._owner = java.util.Objects.requireNonNull(value, "owner is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlTranslationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AccessControlTranslationProperty build() {
                return new AccessControlTranslationProperty() {
                    private final java.lang.String $owner = java.util.Objects.requireNonNull(_owner, "owner is required");

                    @Override
                    public java.lang.String getOwner() {
                        return this.$owner;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("owner", om.valueToTree(this.getOwner()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AccessControlTranslationProperty.Owner`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
             */
            @Override
            public java.lang.String getOwner() {
                return this.jsiiGet("owner", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        java.lang.String getId();
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        java.lang.Object getStorageClassAnalysis();
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        java.lang.String getPrefix();
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _id;
            private java.lang.Object _storageClassAnalysis;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value `CfnBucket.AnalyticsConfigurationProperty.Id`.
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * @return {@code this}
             */
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.Token value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of StorageClassAnalysis
             * @param value `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * @return {@code this}
             */
            public Builder withStorageClassAnalysis(final software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty value) {
                this._storageClassAnalysis = java.util.Objects.requireNonNull(value, "storageClassAnalysis is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AnalyticsConfigurationProperty build() {
                return new AnalyticsConfigurationProperty() {
                    private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private final java.lang.Object $storageClassAnalysis = java.util.Objects.requireNonNull(_storageClassAnalysis, "storageClassAnalysis is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Object getStorageClassAnalysis() {
                        return this.$storageClassAnalysis;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("storageClassAnalysis", om.valueToTree(this.getStorageClassAnalysis()));
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.AnalyticsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
             */
            @Override
            public java.lang.Object getStorageClassAnalysis() {
                return this.jsiiGet("storageClassAnalysis", java.lang.Object.class);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        java.lang.Object getServerSideEncryptionConfiguration();

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        final class Builder {
            private java.lang.Object _serverSideEncryptionConfiguration;

            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * @return {@code this}
             */
            public Builder withServerSideEncryptionConfiguration(final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionConfiguration
             * @param value `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * @return {@code this}
             */
            public Builder withServerSideEncryptionConfiguration(final java.util.List<java.lang.Object> value) {
                this._serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(value, "serverSideEncryptionConfiguration is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BucketEncryptionProperty build() {
                return new BucketEncryptionProperty() {
                    private final java.lang.Object $serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(_serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");

                    @Override
                    public java.lang.Object getServerSideEncryptionConfiguration() {
                        return this.$serverSideEncryptionConfiguration;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.BucketEncryptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
             */
            @Override
            public java.lang.Object getServerSideEncryptionConfiguration() {
                return this.jsiiGet("serverSideEncryptionConfiguration", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.CorsConfigurationProperty.CorsRules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        java.lang.Object getCorsRules();

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _corsRules;

            /**
             * Sets the value of CorsRules
             * @param value `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * @return {@code this}
             */
            public Builder withCorsRules(final software.amazon.awscdk.Token value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }
            /**
             * Sets the value of CorsRules
             * @param value `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * @return {@code this}
             */
            public Builder withCorsRules(final java.util.List<java.lang.Object> value) {
                this._corsRules = java.util.Objects.requireNonNull(value, "corsRules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CorsConfigurationProperty build() {
                return new CorsConfigurationProperty() {
                    private final java.lang.Object $corsRules = java.util.Objects.requireNonNull(_corsRules, "corsRules is required");

                    @Override
                    public java.lang.Object getCorsRules() {
                        return this.$corsRules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("corsRules", om.valueToTree(this.getCorsRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.CorsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.CorsConfigurationProperty.CorsRules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
             */
            @Override
            public java.lang.Object getCorsRules() {
                return this.jsiiGet("corsRules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.CorsRuleProperty.AllowedMethods`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        java.util.List<java.lang.String> getAllowedMethods();
        /**
         * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        java.util.List<java.lang.String> getAllowedOrigins();
        /**
         * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        java.util.List<java.lang.String> getAllowedHeaders();
        /**
         * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        java.util.List<java.lang.String> getExposedHeaders();
        /**
         * `CfnBucket.CorsRuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        java.lang.String getId();
        /**
         * `CfnBucket.CorsRuleProperty.MaxAge`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        java.lang.Object getMaxAge();

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CorsRuleProperty}
         */
        final class Builder {
            private java.util.List<java.lang.String> _allowedMethods;
            private java.util.List<java.lang.String> _allowedOrigins;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _allowedHeaders;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _exposedHeaders;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _maxAge;

            /**
             * Sets the value of AllowedMethods
             * @param value `CfnBucket.CorsRuleProperty.AllowedMethods`.
             * @return {@code this}
             */
            public Builder withAllowedMethods(final java.util.List<java.lang.String> value) {
                this._allowedMethods = java.util.Objects.requireNonNull(value, "allowedMethods is required");
                return this;
            }
            /**
             * Sets the value of AllowedOrigins
             * @param value `CfnBucket.CorsRuleProperty.AllowedOrigins`.
             * @return {@code this}
             */
            public Builder withAllowedOrigins(final java.util.List<java.lang.String> value) {
                this._allowedOrigins = java.util.Objects.requireNonNull(value, "allowedOrigins is required");
                return this;
            }
            /**
             * Sets the value of AllowedHeaders
             * @param value `CfnBucket.CorsRuleProperty.AllowedHeaders`.
             * @return {@code this}
             */
            public Builder withAllowedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._allowedHeaders = value;
                return this;
            }
            /**
             * Sets the value of ExposedHeaders
             * @param value `CfnBucket.CorsRuleProperty.ExposedHeaders`.
             * @return {@code this}
             */
            public Builder withExposedHeaders(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._exposedHeaders = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.CorsRuleProperty.Id`.
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of MaxAge
             * @param value `CfnBucket.CorsRuleProperty.MaxAge`.
             * @return {@code this}
             */
            public Builder withMaxAge(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxAge = value;
                return this;
            }
            /**
             * Sets the value of MaxAge
             * @param value `CfnBucket.CorsRuleProperty.MaxAge`.
             * @return {@code this}
             */
            public Builder withMaxAge(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxAge = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CorsRuleProperty build() {
                return new CorsRuleProperty() {
                    private final java.util.List<java.lang.String> $allowedMethods = java.util.Objects.requireNonNull(_allowedMethods, "allowedMethods is required");
                    private final java.util.List<java.lang.String> $allowedOrigins = java.util.Objects.requireNonNull(_allowedOrigins, "allowedOrigins is required");
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $allowedHeaders = _allowedHeaders;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $exposedHeaders = _exposedHeaders;
                    @javax.annotation.Nullable
                    private final java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private final java.lang.Object $maxAge = _maxAge;

                    @Override
                    public java.util.List<java.lang.String> getAllowedMethods() {
                        return this.$allowedMethods;
                    }

                    @Override
                    public java.util.List<java.lang.String> getAllowedOrigins() {
                        return this.$allowedOrigins;
                    }

                    @Override
                    public java.util.List<java.lang.String> getAllowedHeaders() {
                        return this.$allowedHeaders;
                    }

                    @Override
                    public java.util.List<java.lang.String> getExposedHeaders() {
                        return this.$exposedHeaders;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Object getMaxAge() {
                        return this.$maxAge;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                        obj.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                        obj.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                        obj.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("maxAge", om.valueToTree(this.getMaxAge()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.CorsRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.CorsRuleProperty.AllowedMethods`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
             */
            @Override
            public java.util.List<java.lang.String> getAllowedMethods() {
                return this.jsiiGet("allowedMethods", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
             */
            @Override
            public java.util.List<java.lang.String> getAllowedOrigins() {
                return this.jsiiGet("allowedOrigins", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getAllowedHeaders() {
                return this.jsiiGet("allowedHeaders", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getExposedHeaders() {
                return this.jsiiGet("exposedHeaders", java.util.List.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.CorsRuleProperty.MaxAge`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxAge() {
                return this.jsiiGet("maxAge", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    public static interface DataExportProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DataExportProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        java.lang.Object getDestination();
        /**
         * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        java.lang.String getOutputSchemaVersion();

        /**
         * @return a {@link Builder} of {@link DataExportProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DataExportProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.String _outputSchemaVersion;

            /**
             * Sets the value of Destination
             * @param value `CfnBucket.DataExportProperty.Destination`.
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value `CfnBucket.DataExportProperty.Destination`.
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of OutputSchemaVersion
             * @param value `CfnBucket.DataExportProperty.OutputSchemaVersion`.
             * @return {@code this}
             */
            public Builder withOutputSchemaVersion(final java.lang.String value) {
                this._outputSchemaVersion = java.util.Objects.requireNonNull(value, "outputSchemaVersion is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataExportProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DataExportProperty build() {
                return new DataExportProperty() {
                    private final java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private final java.lang.String $outputSchemaVersion = java.util.Objects.requireNonNull(_outputSchemaVersion, "outputSchemaVersion is required");

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public java.lang.String getOutputSchemaVersion() {
                        return this.$outputSchemaVersion;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("outputSchemaVersion", om.valueToTree(this.getOutputSchemaVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.DataExportProperty.Destination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
             */
            @Override
            public java.lang.String getOutputSchemaVersion() {
                return this.jsiiGet("outputSchemaVersion", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.DestinationProperty.BucketArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        java.lang.String getBucketArn();
        /**
         * `CfnBucket.DestinationProperty.Format`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        java.lang.String getFormat();
        /**
         * `CfnBucket.DestinationProperty.BucketAccountId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        java.lang.String getBucketAccountId();
        /**
         * `CfnBucket.DestinationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DestinationProperty}
         */
        final class Builder {
            private java.lang.String _bucketArn;
            private java.lang.String _format;
            @javax.annotation.Nullable
            private java.lang.String _bucketAccountId;
            @javax.annotation.Nullable
            private java.lang.String _prefix;

            /**
             * Sets the value of BucketArn
             * @param value `CfnBucket.DestinationProperty.BucketArn`.
             * @return {@code this}
             */
            public Builder withBucketArn(final java.lang.String value) {
                this._bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }
            /**
             * Sets the value of Format
             * @param value `CfnBucket.DestinationProperty.Format`.
             * @return {@code this}
             */
            public Builder withFormat(final java.lang.String value) {
                this._format = java.util.Objects.requireNonNull(value, "format is required");
                return this;
            }
            /**
             * Sets the value of BucketAccountId
             * @param value `CfnBucket.DestinationProperty.BucketAccountId`.
             * @return {@code this}
             */
            public Builder withBucketAccountId(@javax.annotation.Nullable final java.lang.String value) {
                this._bucketAccountId = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.DestinationProperty.Prefix`.
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DestinationProperty build() {
                return new DestinationProperty() {
                    private final java.lang.String $bucketArn = java.util.Objects.requireNonNull(_bucketArn, "bucketArn is required");
                    private final java.lang.String $format = java.util.Objects.requireNonNull(_format, "format is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $bucketAccountId = _bucketAccountId;
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;

                    @Override
                    public java.lang.String getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public java.lang.String getFormat() {
                        return this.$format;
                    }

                    @Override
                    public java.lang.String getBucketAccountId() {
                        return this.$bucketAccountId;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                        obj.set("format", om.valueToTree(this.getFormat()));
                        obj.set("bucketAccountId", om.valueToTree(this.getBucketAccountId()));
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.DestinationProperty.BucketArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
             */
            @Override
            public java.lang.String getBucketArn() {
                return this.jsiiGet("bucketArn", java.lang.String.class);
            }

            /**
             * `CfnBucket.DestinationProperty.Format`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
             */
            @Override
            public java.lang.String getFormat() {
                return this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * `CfnBucket.DestinationProperty.BucketAccountId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getBucketAccountId() {
                return this.jsiiGet("bucketAccountId", java.lang.String.class);
            }

            /**
             * `CfnBucket.DestinationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        java.lang.String getReplicaKmsKeyId();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _replicaKmsKeyId;

            /**
             * Sets the value of ReplicaKmsKeyId
             * @param value `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
             * @return {@code this}
             */
            public Builder withReplicaKmsKeyId(final java.lang.String value) {
                this._replicaKmsKeyId = java.util.Objects.requireNonNull(value, "replicaKmsKeyId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EncryptionConfigurationProperty build() {
                return new EncryptionConfigurationProperty() {
                    private final java.lang.String $replicaKmsKeyId = java.util.Objects.requireNonNull(_replicaKmsKeyId, "replicaKmsKeyId is required");

                    @Override
                    public java.lang.String getReplicaKmsKeyId() {
                        return this.$replicaKmsKeyId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("replicaKmsKeyId", om.valueToTree(this.getReplicaKmsKeyId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
             */
            @Override
            public java.lang.String getReplicaKmsKeyId() {
                return this.jsiiGet("replicaKmsKeyId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.FilterRuleProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        java.lang.String getName();
        /**
         * `CfnBucket.FilterRuleProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FilterRuleProperty}
         */
        final class Builder {
            private java.lang.String _name;
            private java.lang.String _value;

            /**
             * Sets the value of Name
             * @param value `CfnBucket.FilterRuleProperty.Name`.
             * @return {@code this}
             */
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnBucket.FilterRuleProperty.Value`.
             * @return {@code this}
             */
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FilterRuleProperty build() {
                return new FilterRuleProperty() {
                    private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private final java.lang.String $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.FilterRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.FilterRuleProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
             */
            @Override
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * `CfnBucket.FilterRuleProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
             */
            @Override
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    public static interface InventoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.InventoryConfigurationProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        java.lang.Object getDestination();
        /**
         * `CfnBucket.InventoryConfigurationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * `CfnBucket.InventoryConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        java.lang.String getId();
        /**
         * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        java.lang.String getIncludedObjectVersions();
        /**
         * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        java.lang.String getScheduleFrequency();
        /**
         * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        java.util.List<java.lang.String> getOptionalFields();
        /**
         * `CfnBucket.InventoryConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link InventoryConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InventoryConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.Object _enabled;
            private java.lang.String _id;
            private java.lang.String _includedObjectVersions;
            private java.lang.String _scheduleFrequency;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _optionalFields;
            @javax.annotation.Nullable
            private java.lang.String _prefix;

            /**
             * Sets the value of Destination
             * @param value `CfnBucket.InventoryConfigurationProperty.Destination`.
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value `CfnBucket.InventoryConfigurationProperty.Destination`.
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.DestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.InventoryConfigurationProperty.Id`.
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of IncludedObjectVersions
             * @param value `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
             * @return {@code this}
             */
            public Builder withIncludedObjectVersions(final java.lang.String value) {
                this._includedObjectVersions = java.util.Objects.requireNonNull(value, "includedObjectVersions is required");
                return this;
            }
            /**
             * Sets the value of ScheduleFrequency
             * @param value `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
             * @return {@code this}
             */
            public Builder withScheduleFrequency(final java.lang.String value) {
                this._scheduleFrequency = java.util.Objects.requireNonNull(value, "scheduleFrequency is required");
                return this;
            }
            /**
             * Sets the value of OptionalFields
             * @param value `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
             * @return {@code this}
             */
            public Builder withOptionalFields(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._optionalFields = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.InventoryConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InventoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InventoryConfigurationProperty build() {
                return new InventoryConfigurationProperty() {
                    private final java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private final java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");
                    private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    private final java.lang.String $includedObjectVersions = java.util.Objects.requireNonNull(_includedObjectVersions, "includedObjectVersions is required");
                    private final java.lang.String $scheduleFrequency = java.util.Objects.requireNonNull(_scheduleFrequency, "scheduleFrequency is required");
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $optionalFields = _optionalFields;
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.String getIncludedObjectVersions() {
                        return this.$includedObjectVersions;
                    }

                    @Override
                    public java.lang.String getScheduleFrequency() {
                        return this.$scheduleFrequency;
                    }

                    @Override
                    public java.util.List<java.lang.String> getOptionalFields() {
                        return this.$optionalFields;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("includedObjectVersions", om.valueToTree(this.getIncludedObjectVersions()));
                        obj.set("scheduleFrequency", om.valueToTree(this.getScheduleFrequency()));
                        obj.set("optionalFields", om.valueToTree(this.getOptionalFields()));
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.InventoryConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Destination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
             */
            @Override
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
             */
            @Override
            public java.lang.String getIncludedObjectVersions() {
                return this.jsiiGet("includedObjectVersions", java.lang.String.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
             */
            @Override
            public java.lang.String getScheduleFrequency() {
                return this.jsiiGet("scheduleFrequency", java.lang.String.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getOptionalFields() {
                return this.jsiiGet("optionalFields", java.util.List.class);
            }

            /**
             * `CfnBucket.InventoryConfigurationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    public static interface LambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LambdaConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        java.lang.String getEvent();
        /**
         * `CfnBucket.LambdaConfigurationProperty.Function`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        java.lang.String getFunction();
        /**
         * `CfnBucket.LambdaConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link LambdaConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LambdaConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _function;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value `CfnBucket.LambdaConfigurationProperty.Event`.
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Function
             * @param value `CfnBucket.LambdaConfigurationProperty.Function`.
             * @return {@code this}
             */
            public Builder withFunction(final java.lang.String value) {
                this._function = java.util.Objects.requireNonNull(value, "function is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.LambdaConfigurationProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LambdaConfigurationProperty build() {
                return new LambdaConfigurationProperty() {
                    private final java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private final java.lang.String $function = java.util.Objects.requireNonNull(_function, "function is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public java.lang.String getFunction() {
                        return this.$function;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree(this.getEvent()));
                        obj.set("function", om.valueToTree(this.getFunction()));
                        obj.set("filter", om.valueToTree(this.getFilter()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LambdaConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.LambdaConfigurationProperty.Event`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
             */
            @Override
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * `CfnBucket.LambdaConfigurationProperty.Function`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
             */
            @Override
            public java.lang.String getFunction() {
                return this.jsiiGet("function", java.lang.String.class);
            }

            /**
             * `CfnBucket.LambdaConfigurationProperty.Filter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LifecycleConfigurationProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LifecycleConfigurationProperty build() {
                return new LifecycleConfigurationProperty() {
                    private final java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LifecycleConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.LifecycleConfigurationProperty.Rules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        java.lang.String getDestinationBucketName();
        /**
         * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        java.lang.String getLogFilePrefix();

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _destinationBucketName;
            @javax.annotation.Nullable
            private java.lang.String _logFilePrefix;

            /**
             * Sets the value of DestinationBucketName
             * @param value `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
             * @return {@code this}
             */
            public Builder withDestinationBucketName(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationBucketName = value;
                return this;
            }
            /**
             * Sets the value of LogFilePrefix
             * @param value `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
             * @return {@code this}
             */
            public Builder withLogFilePrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._logFilePrefix = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoggingConfigurationProperty build() {
                return new LoggingConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $destinationBucketName = _destinationBucketName;
                    @javax.annotation.Nullable
                    private final java.lang.String $logFilePrefix = _logFilePrefix;

                    @Override
                    public java.lang.String getDestinationBucketName() {
                        return this.$destinationBucketName;
                    }

                    @Override
                    public java.lang.String getLogFilePrefix() {
                        return this.$logFilePrefix;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destinationBucketName", om.valueToTree(this.getDestinationBucketName()));
                        obj.set("logFilePrefix", om.valueToTree(this.getLogFilePrefix()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.LoggingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDestinationBucketName() {
                return this.jsiiGet("destinationBucketName", java.lang.String.class);
            }

            /**
             * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLogFilePrefix() {
                return this.jsiiGet("logFilePrefix", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    public static interface MetricsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.MetricsConfigurationProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        java.lang.String getId();
        /**
         * `CfnBucket.MetricsConfigurationProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        java.lang.String getPrefix();
        /**
         * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        java.lang.Object getTagFilters();

        /**
         * @return a {@link Builder} of {@link MetricsConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MetricsConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;

            /**
             * Sets the value of Id
             * @param value `CfnBucket.MetricsConfigurationProperty.Id`.
             * @return {@code this}
             */
            public Builder withId(final java.lang.String value) {
                this._id = java.util.Objects.requireNonNull(value, "id is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.MetricsConfigurationProperty.Prefix`.
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MetricsConfigurationProperty build() {
                return new MetricsConfigurationProperty() {
                    private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagFilters = _tagFilters;

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.MetricsConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.MetricsConfigurationProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
             */
            @Override
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.MetricsConfigurationProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    public static interface NoncurrentVersionTransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        java.lang.String getStorageClass();
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        java.lang.Object getTransitionInDays();

        /**
         * @return a {@link Builder} of {@link NoncurrentVersionTransitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NoncurrentVersionTransitionProperty}
         */
        final class Builder {
            private java.lang.String _storageClass;
            private java.lang.Object _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
             * @return {@code this}
             */
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            public Builder withTransitionInDays(final java.lang.Number value) {
                this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            public Builder withTransitionInDays(final software.amazon.awscdk.Token value) {
                this._transitionInDays = java.util.Objects.requireNonNull(value, "transitionInDays is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoncurrentVersionTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NoncurrentVersionTransitionProperty build() {
                return new NoncurrentVersionTransitionProperty() {
                    private final java.lang.String $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    private final java.lang.Object $transitionInDays = java.util.Objects.requireNonNull(_transitionInDays, "transitionInDays is required");

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public java.lang.Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                        obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
             */
            @Override
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
             */
            @Override
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        java.lang.Object getLambdaConfigurations();
        /**
         * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        java.lang.Object getQueueConfigurations();
        /**
         * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        java.lang.Object getTopicConfigurations();

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _lambdaConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _queueConfigurations;
            @javax.annotation.Nullable
            private java.lang.Object _topicConfigurations;

            /**
             * Sets the value of LambdaConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of LambdaConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * @return {@code this}
             */
            public Builder withLambdaConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._lambdaConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            public Builder withQueueConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of QueueConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * @return {@code this}
             */
            public Builder withQueueConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._queueConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            public Builder withTopicConfigurations(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._topicConfigurations = value;
                return this;
            }
            /**
             * Sets the value of TopicConfigurations
             * @param value `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * @return {@code this}
             */
            public Builder withTopicConfigurations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._topicConfigurations = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NotificationConfigurationProperty build() {
                return new NotificationConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $lambdaConfigurations = _lambdaConfigurations;
                    @javax.annotation.Nullable
                    private final java.lang.Object $queueConfigurations = _queueConfigurations;
                    @javax.annotation.Nullable
                    private final java.lang.Object $topicConfigurations = _topicConfigurations;

                    @Override
                    public java.lang.Object getLambdaConfigurations() {
                        return this.$lambdaConfigurations;
                    }

                    @Override
                    public java.lang.Object getQueueConfigurations() {
                        return this.$queueConfigurations;
                    }

                    @Override
                    public java.lang.Object getTopicConfigurations() {
                        return this.$topicConfigurations;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("lambdaConfigurations", om.valueToTree(this.getLambdaConfigurations()));
                        obj.set("queueConfigurations", om.valueToTree(this.getQueueConfigurations()));
                        obj.set("topicConfigurations", om.valueToTree(this.getTopicConfigurations()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NotificationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLambdaConfigurations() {
                return this.jsiiGet("lambdaConfigurations", java.lang.Object.class);
            }

            /**
             * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getQueueConfigurations() {
                return this.jsiiGet("queueConfigurations", java.lang.Object.class);
            }

            /**
             * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTopicConfigurations() {
                return this.jsiiGet("topicConfigurations", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    public static interface NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.NotificationFilterProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        java.lang.Object getS3Key();

        /**
         * @return a {@link Builder} of {@link NotificationFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NotificationFilterProperty}
         */
        final class Builder {
            private java.lang.Object _s3Key;

            /**
             * Sets the value of S3Key
             * @param value `CfnBucket.NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            public Builder withS3Key(final software.amazon.awscdk.Token value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value `CfnBucket.NotificationFilterProperty.S3Key`.
             * @return {@code this}
             */
            public Builder withS3Key(final software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NotificationFilterProperty build() {
                return new NotificationFilterProperty() {
                    private final java.lang.Object $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.Object getS3Key() {
                        return this.$s3Key;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.NotificationFilterProperty.S3Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
             */
            @Override
            public java.lang.Object getS3Key() {
                return this.jsiiGet("s3Key", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    public static interface PublicAccessBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        java.lang.Object getBlockPublicAcls();
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        java.lang.Object getBlockPublicPolicy();
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        java.lang.Object getIgnorePublicAcls();
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        java.lang.Object getRestrictPublicBuckets();

        /**
         * @return a {@link Builder} of {@link PublicAccessBlockConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PublicAccessBlockConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _blockPublicPolicy;
            @javax.annotation.Nullable
            private java.lang.Object _ignorePublicAcls;
            @javax.annotation.Nullable
            private java.lang.Object _restrictPublicBuckets;

            /**
             * Sets the value of BlockPublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * @return {@code this}
             */
            public Builder withBlockPublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockPublicAcls = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of BlockPublicPolicy
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * @return {@code this}
             */
            public Builder withBlockPublicPolicy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockPublicPolicy = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of IgnorePublicAcls
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * @return {@code this}
             */
            public Builder withIgnorePublicAcls(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ignorePublicAcls = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._restrictPublicBuckets = value;
                return this;
            }
            /**
             * Sets the value of RestrictPublicBuckets
             * @param value `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * @return {@code this}
             */
            public Builder withRestrictPublicBuckets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._restrictPublicBuckets = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PublicAccessBlockConfigurationProperty build() {
                return new PublicAccessBlockConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockPublicAcls = _blockPublicAcls;
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockPublicPolicy = _blockPublicPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ignorePublicAcls = _ignorePublicAcls;
                    @javax.annotation.Nullable
                    private final java.lang.Object $restrictPublicBuckets = _restrictPublicBuckets;

                    @Override
                    public java.lang.Object getBlockPublicAcls() {
                        return this.$blockPublicAcls;
                    }

                    @Override
                    public java.lang.Object getBlockPublicPolicy() {
                        return this.$blockPublicPolicy;
                    }

                    @Override
                    public java.lang.Object getIgnorePublicAcls() {
                        return this.$ignorePublicAcls;
                    }

                    @Override
                    public java.lang.Object getRestrictPublicBuckets() {
                        return this.$restrictPublicBuckets;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("blockPublicAcls", om.valueToTree(this.getBlockPublicAcls()));
                        obj.set("blockPublicPolicy", om.valueToTree(this.getBlockPublicPolicy()));
                        obj.set("ignorePublicAcls", om.valueToTree(this.getIgnorePublicAcls()));
                        obj.set("restrictPublicBuckets", om.valueToTree(this.getRestrictPublicBuckets()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.PublicAccessBlockConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicAcls() {
                return this.jsiiGet("blockPublicAcls", java.lang.Object.class);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockPublicPolicy() {
                return this.jsiiGet("blockPublicPolicy", java.lang.Object.class);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePublicAcls() {
                return this.jsiiGet("ignorePublicAcls", java.lang.Object.class);
            }

            /**
             * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRestrictPublicBuckets() {
                return this.jsiiGet("restrictPublicBuckets", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    public static interface QueueConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.QueueConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        java.lang.String getEvent();
        /**
         * `CfnBucket.QueueConfigurationProperty.Queue`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        java.lang.String getQueue();
        /**
         * `CfnBucket.QueueConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link QueueConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link QueueConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _queue;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value `CfnBucket.QueueConfigurationProperty.Event`.
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Queue
             * @param value `CfnBucket.QueueConfigurationProperty.Queue`.
             * @return {@code this}
             */
            public Builder withQueue(final java.lang.String value) {
                this._queue = java.util.Objects.requireNonNull(value, "queue is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.QueueConfigurationProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public QueueConfigurationProperty build() {
                return new QueueConfigurationProperty() {
                    private final java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private final java.lang.String $queue = java.util.Objects.requireNonNull(_queue, "queue is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public java.lang.String getQueue() {
                        return this.$queue;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree(this.getEvent()));
                        obj.set("queue", om.valueToTree(this.getQueue()));
                        obj.set("filter", om.valueToTree(this.getFilter()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.QueueConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.QueueConfigurationProperty.Event`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
             */
            @Override
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * `CfnBucket.QueueConfigurationProperty.Queue`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
             */
            @Override
            public java.lang.String getQueue() {
                return this.jsiiGet("queue", java.lang.String.class);
            }

            /**
             * `CfnBucket.QueueConfigurationProperty.Filter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    public static interface RedirectAllRequestsToProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        java.lang.String getHostName();
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        java.lang.String getProtocol();

        /**
         * @return a {@link Builder} of {@link RedirectAllRequestsToProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectAllRequestsToProperty}
         */
        final class Builder {
            private java.lang.String _hostName;
            @javax.annotation.Nullable
            private java.lang.String _protocol;

            /**
             * Sets the value of HostName
             * @param value `CfnBucket.RedirectAllRequestsToProperty.HostName`.
             * @return {@code this}
             */
            public Builder withHostName(final java.lang.String value) {
                this._hostName = java.util.Objects.requireNonNull(value, "hostName is required");
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectAllRequestsToProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectAllRequestsToProperty build() {
                return new RedirectAllRequestsToProperty() {
                    private final java.lang.String $hostName = java.util.Objects.requireNonNull(_hostName, "hostName is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $protocol = _protocol;

                    @Override
                    public java.lang.String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("hostName", om.valueToTree(this.getHostName()));
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
             */
            @Override
            public java.lang.String getHostName() {
                return this.jsiiGet("hostName", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    public static interface RedirectRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RedirectRuleProperty.HostName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        java.lang.String getHostName();
        /**
         * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        java.lang.String getHttpRedirectCode();
        /**
         * `CfnBucket.RedirectRuleProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        java.lang.String getProtocol();
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        java.lang.String getReplaceKeyPrefixWith();
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        java.lang.String getReplaceKeyWith();

        /**
         * @return a {@link Builder} of {@link RedirectRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _hostName;
            @javax.annotation.Nullable
            private java.lang.String _httpRedirectCode;
            @javax.annotation.Nullable
            private java.lang.String _protocol;
            @javax.annotation.Nullable
            private java.lang.String _replaceKeyPrefixWith;
            @javax.annotation.Nullable
            private java.lang.String _replaceKeyWith;

            /**
             * Sets the value of HostName
             * @param value `CfnBucket.RedirectRuleProperty.HostName`.
             * @return {@code this}
             */
            public Builder withHostName(@javax.annotation.Nullable final java.lang.String value) {
                this._hostName = value;
                return this;
            }
            /**
             * Sets the value of HttpRedirectCode
             * @param value `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
             * @return {@code this}
             */
            public Builder withHttpRedirectCode(@javax.annotation.Nullable final java.lang.String value) {
                this._httpRedirectCode = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value `CfnBucket.RedirectRuleProperty.Protocol`.
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyPrefixWith
             * @param value `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
             * @return {@code this}
             */
            public Builder withReplaceKeyPrefixWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyPrefixWith = value;
                return this;
            }
            /**
             * Sets the value of ReplaceKeyWith
             * @param value `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
             * @return {@code this}
             */
            public Builder withReplaceKeyWith(@javax.annotation.Nullable final java.lang.String value) {
                this._replaceKeyWith = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectRuleProperty build() {
                return new RedirectRuleProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $hostName = _hostName;
                    @javax.annotation.Nullable
                    private final java.lang.String $httpRedirectCode = _httpRedirectCode;
                    @javax.annotation.Nullable
                    private final java.lang.String $protocol = _protocol;
                    @javax.annotation.Nullable
                    private final java.lang.String $replaceKeyPrefixWith = _replaceKeyPrefixWith;
                    @javax.annotation.Nullable
                    private final java.lang.String $replaceKeyWith = _replaceKeyWith;

                    @Override
                    public java.lang.String getHostName() {
                        return this.$hostName;
                    }

                    @Override
                    public java.lang.String getHttpRedirectCode() {
                        return this.$httpRedirectCode;
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public java.lang.String getReplaceKeyPrefixWith() {
                        return this.$replaceKeyPrefixWith;
                    }

                    @Override
                    public java.lang.String getReplaceKeyWith() {
                        return this.$replaceKeyWith;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("hostName", om.valueToTree(this.getHostName()));
                        obj.set("httpRedirectCode", om.valueToTree(this.getHttpRedirectCode()));
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                        obj.set("replaceKeyPrefixWith", om.valueToTree(this.getReplaceKeyPrefixWith()));
                        obj.set("replaceKeyWith", om.valueToTree(this.getReplaceKeyWith()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.HostName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHostName() {
                return this.jsiiGet("hostName", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHttpRedirectCode() {
                return this.jsiiGet("httpRedirectCode", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.Protocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getReplaceKeyPrefixWith() {
                return this.jsiiGet("replaceKeyPrefixWith", java.lang.String.class);
            }

            /**
             * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getReplaceKeyWith() {
                return this.jsiiGet("replaceKeyWith", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    public static interface ReplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Role`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        java.lang.String getRole();
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link ReplicationConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _role;
            private java.lang.Object _rules;

            /**
             * Sets the value of Role
             * @param value `CfnBucket.ReplicationConfigurationProperty.Role`.
             * @return {@code this}
             */
            public Builder withRole(final java.lang.String value) {
                this._role = java.util.Objects.requireNonNull(value, "role is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationConfigurationProperty build() {
                return new ReplicationConfigurationProperty() {
                    private final java.lang.String $role = java.util.Objects.requireNonNull(_role, "role is required");
                    private final java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.String getRole() {
                        return this.$role;
                    }

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("role", om.valueToTree(this.getRole()));
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ReplicationConfigurationProperty.Role`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
             */
            @Override
            public java.lang.String getRole() {
                return this.jsiiGet("role", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationConfigurationProperty.Rules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    public static interface ReplicationDestinationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationDestinationProperty.Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        java.lang.String getBucket();
        /**
         * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        java.lang.Object getAccessControlTranslation();
        /**
         * `CfnBucket.ReplicationDestinationProperty.Account`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        java.lang.String getAccount();
        /**
         * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        java.lang.Object getEncryptionConfiguration();
        /**
         * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        java.lang.String getStorageClass();

        /**
         * @return a {@link Builder} of {@link ReplicationDestinationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationDestinationProperty}
         */
        final class Builder {
            private java.lang.String _bucket;
            @javax.annotation.Nullable
            private java.lang.Object _accessControlTranslation;
            @javax.annotation.Nullable
            private java.lang.String _account;
            @javax.annotation.Nullable
            private java.lang.Object _encryptionConfiguration;
            @javax.annotation.Nullable
            private java.lang.String _storageClass;

            /**
             * Sets the value of Bucket
             * @param value `CfnBucket.ReplicationDestinationProperty.Bucket`.
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of AccessControlTranslation
             * @param value `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * @return {@code this}
             */
            public Builder withAccessControlTranslation(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AccessControlTranslationProperty value) {
                this._accessControlTranslation = value;
                return this;
            }
            /**
             * Sets the value of Account
             * @param value `CfnBucket.ReplicationDestinationProperty.Account`.
             * @return {@code this}
             */
            public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
                this._account = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of EncryptionConfiguration
             * @param value `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * @return {@code this}
             */
            public Builder withEncryptionConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.EncryptionConfigurationProperty value) {
                this._encryptionConfiguration = value;
                return this;
            }
            /**
             * Sets the value of StorageClass
             * @param value `CfnBucket.ReplicationDestinationProperty.StorageClass`.
             * @return {@code this}
             */
            public Builder withStorageClass(@javax.annotation.Nullable final java.lang.String value) {
                this._storageClass = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationDestinationProperty build() {
                return new ReplicationDestinationProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $accessControlTranslation = _accessControlTranslation;
                    @javax.annotation.Nullable
                    private final java.lang.String $account = _account;
                    @javax.annotation.Nullable
                    private final java.lang.Object $encryptionConfiguration = _encryptionConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.String $storageClass = _storageClass;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.Object getAccessControlTranslation() {
                        return this.$accessControlTranslation;
                    }

                    @Override
                    public java.lang.String getAccount() {
                        return this.$account;
                    }

                    @Override
                    public java.lang.Object getEncryptionConfiguration() {
                        return this.$encryptionConfiguration;
                    }

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("accessControlTranslation", om.valueToTree(this.getAccessControlTranslation()));
                        obj.set("account", om.valueToTree(this.getAccount()));
                        obj.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                        obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.Bucket`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
             */
            @Override
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAccessControlTranslation() {
                return this.jsiiGet("accessControlTranslation", java.lang.Object.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.Account`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAccount() {
                return this.jsiiGet("account", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncryptionConfiguration() {
                return this.jsiiGet("encryptionConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    public static interface ReplicationRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ReplicationRuleProperty.Destination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        java.lang.Object getDestination();
        /**
         * `CfnBucket.ReplicationRuleProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        java.lang.String getPrefix();
        /**
         * `CfnBucket.ReplicationRuleProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        java.lang.String getStatus();
        /**
         * `CfnBucket.ReplicationRuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        java.lang.String getId();
        /**
         * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        java.lang.Object getSourceSelectionCriteria();

        /**
         * @return a {@link Builder} of {@link ReplicationRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReplicationRuleProperty}
         */
        final class Builder {
            private java.lang.Object _destination;
            private java.lang.String _prefix;
            private java.lang.String _status;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _sourceSelectionCriteria;

            /**
             * Sets the value of Destination
             * @param value `CfnBucket.ReplicationRuleProperty.Destination`.
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.Token value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Destination
             * @param value `CfnBucket.ReplicationRuleProperty.Destination`.
             * @return {@code this}
             */
            public Builder withDestination(final software.amazon.awscdk.services.s3.CfnBucket.ReplicationDestinationProperty value) {
                this._destination = java.util.Objects.requireNonNull(value, "destination is required");
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.ReplicationRuleProperty.Prefix`.
             * @return {@code this}
             */
            public Builder withPrefix(final java.lang.String value) {
                this._prefix = java.util.Objects.requireNonNull(value, "prefix is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value `CfnBucket.ReplicationRuleProperty.Status`.
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.ReplicationRuleProperty.Id`.
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sourceSelectionCriteria = value;
                return this;
            }
            /**
             * Sets the value of SourceSelectionCriteria
             * @param value `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * @return {@code this}
             */
            public Builder withSourceSelectionCriteria(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty value) {
                this._sourceSelectionCriteria = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ReplicationRuleProperty build() {
                return new ReplicationRuleProperty() {
                    private final java.lang.Object $destination = java.util.Objects.requireNonNull(_destination, "destination is required");
                    private final java.lang.String $prefix = java.util.Objects.requireNonNull(_prefix, "prefix is required");
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sourceSelectionCriteria = _sourceSelectionCriteria;

                    @Override
                    public java.lang.Object getDestination() {
                        return this.$destination;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Object getSourceSelectionCriteria() {
                        return this.$sourceSelectionCriteria;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("destination", om.valueToTree(this.getDestination()));
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                        obj.set("status", om.valueToTree(this.getStatus()));
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("sourceSelectionCriteria", om.valueToTree(this.getSourceSelectionCriteria()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ReplicationRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Destination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
             */
            @Override
            public java.lang.Object getDestination() {
                return this.jsiiGet("destination", java.lang.Object.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
             */
            @Override
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSourceSelectionCriteria() {
                return this.jsiiGet("sourceSelectionCriteria", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    public static interface RoutingRuleConditionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        java.lang.String getHttpErrorCodeReturnedEquals();
        /**
         * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        java.lang.String getKeyPrefixEquals();

        /**
         * @return a {@link Builder} of {@link RoutingRuleConditionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleConditionProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _httpErrorCodeReturnedEquals;
            @javax.annotation.Nullable
            private java.lang.String _keyPrefixEquals;

            /**
             * Sets the value of HttpErrorCodeReturnedEquals
             * @param value `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
             * @return {@code this}
             */
            public Builder withHttpErrorCodeReturnedEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._httpErrorCodeReturnedEquals = value;
                return this;
            }
            /**
             * Sets the value of KeyPrefixEquals
             * @param value `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
             * @return {@code this}
             */
            public Builder withKeyPrefixEquals(@javax.annotation.Nullable final java.lang.String value) {
                this._keyPrefixEquals = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RoutingRuleConditionProperty build() {
                return new RoutingRuleConditionProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $httpErrorCodeReturnedEquals = _httpErrorCodeReturnedEquals;
                    @javax.annotation.Nullable
                    private final java.lang.String $keyPrefixEquals = _keyPrefixEquals;

                    @Override
                    public java.lang.String getHttpErrorCodeReturnedEquals() {
                        return this.$httpErrorCodeReturnedEquals;
                    }

                    @Override
                    public java.lang.String getKeyPrefixEquals() {
                        return this.$keyPrefixEquals;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("httpErrorCodeReturnedEquals", om.valueToTree(this.getHttpErrorCodeReturnedEquals()));
                        obj.set("keyPrefixEquals", om.valueToTree(this.getKeyPrefixEquals()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHttpErrorCodeReturnedEquals() {
                return this.jsiiGet("httpErrorCodeReturnedEquals", java.lang.String.class);
            }

            /**
             * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKeyPrefixEquals() {
                return this.jsiiGet("keyPrefixEquals", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    public static interface RoutingRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RoutingRuleProperty.RedirectRule`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        java.lang.Object getRedirectRule();
        /**
         * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        java.lang.Object getRoutingRuleCondition();

        /**
         * @return a {@link Builder} of {@link RoutingRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RoutingRuleProperty}
         */
        final class Builder {
            private java.lang.Object _redirectRule;
            @javax.annotation.Nullable
            private java.lang.Object _routingRuleCondition;

            /**
             * Sets the value of RedirectRule
             * @param value `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * @return {@code this}
             */
            public Builder withRedirectRule(final software.amazon.awscdk.Token value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RedirectRule
             * @param value `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * @return {@code this}
             */
            public Builder withRedirectRule(final software.amazon.awscdk.services.s3.CfnBucket.RedirectRuleProperty value) {
                this._redirectRule = java.util.Objects.requireNonNull(value, "redirectRule is required");
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._routingRuleCondition = value;
                return this;
            }
            /**
             * Sets the value of RoutingRuleCondition
             * @param value `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * @return {@code this}
             */
            public Builder withRoutingRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleConditionProperty value) {
                this._routingRuleCondition = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RoutingRuleProperty build() {
                return new RoutingRuleProperty() {
                    private final java.lang.Object $redirectRule = java.util.Objects.requireNonNull(_redirectRule, "redirectRule is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $routingRuleCondition = _routingRuleCondition;

                    @Override
                    public java.lang.Object getRedirectRule() {
                        return this.$redirectRule;
                    }

                    @Override
                    public java.lang.Object getRoutingRuleCondition() {
                        return this.$routingRuleCondition;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("redirectRule", om.valueToTree(this.getRedirectRule()));
                        obj.set("routingRuleCondition", om.valueToTree(this.getRoutingRuleCondition()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RoutingRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RoutingRuleProperty.RedirectRule`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
             */
            @Override
            public java.lang.Object getRedirectRule() {
                return this.jsiiGet("redirectRule", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRuleCondition() {
                return this.jsiiGet("routingRuleCondition", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.RuleProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        java.lang.String getStatus();
        /**
         * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        java.lang.Object getAbortIncompleteMultipartUpload();
        /**
         * `CfnBucket.RuleProperty.ExpirationDate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        java.lang.Object getExpirationDate();
        /**
         * `CfnBucket.RuleProperty.ExpirationInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        java.lang.Object getExpirationInDays();
        /**
         * `CfnBucket.RuleProperty.Id`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        java.lang.String getId();
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        java.lang.Object getNoncurrentVersionExpirationInDays();
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        java.lang.Object getNoncurrentVersionTransition();
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        java.lang.Object getNoncurrentVersionTransitions();
        /**
         * `CfnBucket.RuleProperty.Prefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        java.lang.String getPrefix();
        /**
         * `CfnBucket.RuleProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        java.lang.Object getTagFilters();
        /**
         * `CfnBucket.RuleProperty.Transition`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        java.lang.Object getTransition();
        /**
         * `CfnBucket.RuleProperty.Transitions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        java.lang.Object getTransitions();

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RuleProperty}
         */
        final class Builder {
            private java.lang.String _status;
            @javax.annotation.Nullable
            private java.lang.Object _abortIncompleteMultipartUpload;
            @javax.annotation.Nullable
            private java.lang.Object _expirationDate;
            @javax.annotation.Nullable
            private java.lang.Object _expirationInDays;
            @javax.annotation.Nullable
            private java.lang.String _id;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionExpirationInDays;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransition;
            @javax.annotation.Nullable
            private java.lang.Object _noncurrentVersionTransitions;
            @javax.annotation.Nullable
            private java.lang.String _prefix;
            @javax.annotation.Nullable
            private java.lang.Object _tagFilters;
            @javax.annotation.Nullable
            private java.lang.Object _transition;
            @javax.annotation.Nullable
            private java.lang.Object _transitions;

            /**
             * Sets the value of Status
             * @param value `CfnBucket.RuleProperty.Status`.
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of AbortIncompleteMultipartUpload
             * @param value `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * @return {@code this}
             */
            public Builder withAbortIncompleteMultipartUpload(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty value) {
                this._abortIncompleteMultipartUpload = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            public Builder withExpirationDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationDate
             * @param value `CfnBucket.RuleProperty.ExpirationDate`.
             * @return {@code this}
             */
            public Builder withExpirationDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._expirationDate = value;
                return this;
            }
            /**
             * Sets the value of ExpirationInDays
             * @param value `CfnBucket.RuleProperty.ExpirationInDays`.
             * @return {@code this}
             */
            public Builder withExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._expirationInDays = value;
                return this;
            }
            /**
             * Sets the value of ExpirationInDays
             * @param value `CfnBucket.RuleProperty.ExpirationInDays`.
             * @return {@code this}
             */
            public Builder withExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._expirationInDays = value;
                return this;
            }
            /**
             * Sets the value of Id
             * @param value `CfnBucket.RuleProperty.Id`.
             * @return {@code this}
             */
            public Builder withId(@javax.annotation.Nullable final java.lang.String value) {
                this._id = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
             * @return {@code this}
             */
            public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionExpirationInDays
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
             * @return {@code this}
             */
            public Builder withNoncurrentVersionExpirationInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionExpirationInDays = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransition
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty value) {
                this._noncurrentVersionTransition = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of NoncurrentVersionTransitions
             * @param value `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * @return {@code this}
             */
            public Builder withNoncurrentVersionTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._noncurrentVersionTransitions = value;
                return this;
            }
            /**
             * Sets the value of Prefix
             * @param value `CfnBucket.RuleProperty.Prefix`.
             * @return {@code this}
             */
            public Builder withPrefix(@javax.annotation.Nullable final java.lang.String value) {
                this._prefix = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of TagFilters
             * @param value `CfnBucket.RuleProperty.TagFilters`.
             * @return {@code this}
             */
            public Builder withTagFilters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagFilters = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transition
             * @param value `CfnBucket.RuleProperty.Transition`.
             * @return {@code this}
             */
            public Builder withTransition(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty value) {
                this._transition = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            public Builder withTransitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitions = value;
                return this;
            }
            /**
             * Sets the value of Transitions
             * @param value `CfnBucket.RuleProperty.Transitions`.
             * @return {@code this}
             */
            public Builder withTransitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._transitions = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RuleProperty build() {
                return new RuleProperty() {
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $abortIncompleteMultipartUpload = _abortIncompleteMultipartUpload;
                    @javax.annotation.Nullable
                    private final java.lang.Object $expirationDate = _expirationDate;
                    @javax.annotation.Nullable
                    private final java.lang.Object $expirationInDays = _expirationInDays;
                    @javax.annotation.Nullable
                    private final java.lang.String $id = _id;
                    @javax.annotation.Nullable
                    private final java.lang.Object $noncurrentVersionExpirationInDays = _noncurrentVersionExpirationInDays;
                    @javax.annotation.Nullable
                    private final java.lang.Object $noncurrentVersionTransition = _noncurrentVersionTransition;
                    @javax.annotation.Nullable
                    private final java.lang.Object $noncurrentVersionTransitions = _noncurrentVersionTransitions;
                    @javax.annotation.Nullable
                    private final java.lang.String $prefix = _prefix;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagFilters = _tagFilters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $transition = _transition;
                    @javax.annotation.Nullable
                    private final java.lang.Object $transitions = _transitions;

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    @Override
                    public java.lang.Object getAbortIncompleteMultipartUpload() {
                        return this.$abortIncompleteMultipartUpload;
                    }

                    @Override
                    public java.lang.Object getExpirationDate() {
                        return this.$expirationDate;
                    }

                    @Override
                    public java.lang.Object getExpirationInDays() {
                        return this.$expirationInDays;
                    }

                    @Override
                    public java.lang.String getId() {
                        return this.$id;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionExpirationInDays() {
                        return this.$noncurrentVersionExpirationInDays;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransition() {
                        return this.$noncurrentVersionTransition;
                    }

                    @Override
                    public java.lang.Object getNoncurrentVersionTransitions() {
                        return this.$noncurrentVersionTransitions;
                    }

                    @Override
                    public java.lang.String getPrefix() {
                        return this.$prefix;
                    }

                    @Override
                    public java.lang.Object getTagFilters() {
                        return this.$tagFilters;
                    }

                    @Override
                    public java.lang.Object getTransition() {
                        return this.$transition;
                    }

                    @Override
                    public java.lang.Object getTransitions() {
                        return this.$transitions;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree(this.getStatus()));
                        obj.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                        obj.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                        obj.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                        obj.set("id", om.valueToTree(this.getId()));
                        obj.set("noncurrentVersionExpirationInDays", om.valueToTree(this.getNoncurrentVersionExpirationInDays()));
                        obj.set("noncurrentVersionTransition", om.valueToTree(this.getNoncurrentVersionTransition()));
                        obj.set("noncurrentVersionTransitions", om.valueToTree(this.getNoncurrentVersionTransitions()));
                        obj.set("prefix", om.valueToTree(this.getPrefix()));
                        obj.set("tagFilters", om.valueToTree(this.getTagFilters()));
                        obj.set("transition", om.valueToTree(this.getTransition()));
                        obj.set("transitions", om.valueToTree(this.getTransitions()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.RuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.RuleProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }

            /**
             * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.jsiiGet("abortIncompleteMultipartUpload", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.ExpirationDate`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExpirationDate() {
                return this.jsiiGet("expirationDate", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.ExpirationInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getExpirationInDays() {
                return this.jsiiGet("expirationInDays", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.Id`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getId() {
                return this.jsiiGet("id", java.lang.String.class);
            }

            /**
             * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionExpirationInDays() {
                return this.jsiiGet("noncurrentVersionExpirationInDays", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransition() {
                return this.jsiiGet("noncurrentVersionTransition", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoncurrentVersionTransitions() {
                return this.jsiiGet("noncurrentVersionTransitions", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.Prefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrefix() {
                return this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * `CfnBucket.RuleProperty.TagFilters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagFilters() {
                return this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.Transition`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransition() {
                return this.jsiiGet("transition", java.lang.Object.class);
            }

            /**
             * `CfnBucket.RuleProperty.Transitions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitions() {
                return this.jsiiGet("transitions", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.S3KeyFilterProperty.Rules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        final class Builder {
            private java.lang.Object _rules;

            /**
             * Sets the value of Rules
             * @param value `CfnBucket.S3KeyFilterProperty.Rules`.
             * @return {@code this}
             */
            public Builder withRules(final software.amazon.awscdk.Token value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }
            /**
             * Sets the value of Rules
             * @param value `CfnBucket.S3KeyFilterProperty.Rules`.
             * @return {@code this}
             */
            public Builder withRules(final java.util.List<java.lang.Object> value) {
                this._rules = java.util.Objects.requireNonNull(value, "rules is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3KeyFilterProperty build() {
                return new S3KeyFilterProperty() {
                    private final java.lang.Object $rules = java.util.Objects.requireNonNull(_rules, "rules is required");

                    @Override
                    public java.lang.Object getRules() {
                        return this.$rules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("rules", om.valueToTree(this.getRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.S3KeyFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.S3KeyFilterProperty.Rules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
             */
            @Override
            public java.lang.Object getRules() {
                return this.jsiiGet("rules", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        java.lang.String getSseAlgorithm();
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        java.lang.String getKmsMasterKeyId();

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        final class Builder {
            private java.lang.String _sseAlgorithm;
            @javax.annotation.Nullable
            private java.lang.String _kmsMasterKeyId;

            /**
             * Sets the value of SseAlgorithm
             * @param value `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
             * @return {@code this}
             */
            public Builder withSseAlgorithm(final java.lang.String value) {
                this._sseAlgorithm = java.util.Objects.requireNonNull(value, "sseAlgorithm is required");
                return this;
            }
            /**
             * Sets the value of KmsMasterKeyId
             * @param value `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
             * @return {@code this}
             */
            public Builder withKmsMasterKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this._kmsMasterKeyId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ServerSideEncryptionByDefaultProperty build() {
                return new ServerSideEncryptionByDefaultProperty() {
                    private final java.lang.String $sseAlgorithm = java.util.Objects.requireNonNull(_sseAlgorithm, "sseAlgorithm is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $kmsMasterKeyId = _kmsMasterKeyId;

                    @Override
                    public java.lang.String getSseAlgorithm() {
                        return this.$sseAlgorithm;
                    }

                    @Override
                    public java.lang.String getKmsMasterKeyId() {
                        return this.$kmsMasterKeyId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("sseAlgorithm", om.valueToTree(this.getSseAlgorithm()));
                        obj.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
             */
            @Override
            public java.lang.String getSseAlgorithm() {
                return this.jsiiGet("sseAlgorithm", java.lang.String.class);
            }

            /**
             * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKmsMasterKeyId() {
                return this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        java.lang.Object getServerSideEncryptionByDefault();

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _serverSideEncryptionByDefault;

            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }
            /**
             * Sets the value of ServerSideEncryptionByDefault
             * @param value `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * @return {@code this}
             */
            public Builder withServerSideEncryptionByDefault(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty value) {
                this._serverSideEncryptionByDefault = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ServerSideEncryptionRuleProperty build() {
                return new ServerSideEncryptionRuleProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $serverSideEncryptionByDefault = _serverSideEncryptionByDefault;

                    @Override
                    public java.lang.Object getServerSideEncryptionByDefault() {
                        return this.$serverSideEncryptionByDefault;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("serverSideEncryptionByDefault", om.valueToTree(this.getServerSideEncryptionByDefault()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getServerSideEncryptionByDefault() {
                return this.jsiiGet("serverSideEncryptionByDefault", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    public static interface SourceSelectionCriteriaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        java.lang.Object getSseKmsEncryptedObjects();

        /**
         * @return a {@link Builder} of {@link SourceSelectionCriteriaProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceSelectionCriteriaProperty}
         */
        final class Builder {
            private java.lang.Object _sseKmsEncryptedObjects;

            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * @return {@code this}
             */
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.Token value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }
            /**
             * Sets the value of SseKmsEncryptedObjects
             * @param value `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * @return {@code this}
             */
            public Builder withSseKmsEncryptedObjects(final software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty value) {
                this._sseKmsEncryptedObjects = java.util.Objects.requireNonNull(value, "sseKmsEncryptedObjects is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSelectionCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceSelectionCriteriaProperty build() {
                return new SourceSelectionCriteriaProperty() {
                    private final java.lang.Object $sseKmsEncryptedObjects = java.util.Objects.requireNonNull(_sseKmsEncryptedObjects, "sseKmsEncryptedObjects is required");

                    @Override
                    public java.lang.Object getSseKmsEncryptedObjects() {
                        return this.$sseKmsEncryptedObjects;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("sseKmsEncryptedObjects", om.valueToTree(this.getSseKmsEncryptedObjects()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.SourceSelectionCriteriaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
             */
            @Override
            public java.lang.Object getSseKmsEncryptedObjects() {
                return this.jsiiGet("sseKmsEncryptedObjects", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    public static interface SseKmsEncryptedObjectsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link SseKmsEncryptedObjectsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SseKmsEncryptedObjectsProperty}
         */
        final class Builder {
            private java.lang.String _status;

            /**
             * Sets the value of Status
             * @param value `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseKmsEncryptedObjectsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SseKmsEncryptedObjectsProperty build() {
                return new SseKmsEncryptedObjectsProperty() {
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree(this.getStatus()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.SseKmsEncryptedObjectsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    public static interface StorageClassAnalysisProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        java.lang.Object getDataExport();

        /**
         * @return a {@link Builder} of {@link StorageClassAnalysisProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StorageClassAnalysisProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _dataExport;

            /**
             * Sets the value of DataExport
             * @param value `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._dataExport = value;
                return this;
            }
            /**
             * Sets the value of DataExport
             * @param value `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * @return {@code this}
             */
            public Builder withDataExport(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.DataExportProperty value) {
                this._dataExport = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageClassAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StorageClassAnalysisProperty build() {
                return new StorageClassAnalysisProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $dataExport = _dataExport;

                    @Override
                    public java.lang.Object getDataExport() {
                        return this.$dataExport;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("dataExport", om.valueToTree(this.getDataExport()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.StorageClassAnalysisProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDataExport() {
                return this.jsiiGet("dataExport", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        java.lang.String getKey();
        /**
         * `CfnBucket.TagFilterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        final class Builder {
            private java.lang.String _key;
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value `CfnBucket.TagFilterProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnBucket.TagFilterProperty.Value`.
             * @return {@code this}
             */
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagFilterProperty build() {
                return new TagFilterProperty() {
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private final java.lang.String $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.TagFilterProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnBucket.TagFilterProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
             */
            @Override
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    public static interface TopicConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TopicConfigurationProperty.Event`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        java.lang.String getEvent();
        /**
         * `CfnBucket.TopicConfigurationProperty.Topic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        java.lang.String getTopic();
        /**
         * `CfnBucket.TopicConfigurationProperty.Filter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link TopicConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TopicConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _event;
            private java.lang.String _topic;
            @javax.annotation.Nullable
            private java.lang.Object _filter;

            /**
             * Sets the value of Event
             * @param value `CfnBucket.TopicConfigurationProperty.Event`.
             * @return {@code this}
             */
            public Builder withEvent(final java.lang.String value) {
                this._event = java.util.Objects.requireNonNull(value, "event is required");
                return this;
            }
            /**
             * Sets the value of Topic
             * @param value `CfnBucket.TopicConfigurationProperty.Topic`.
             * @return {@code this}
             */
            public Builder withTopic(final java.lang.String value) {
                this._topic = java.util.Objects.requireNonNull(value, "topic is required");
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._filter = value;
                return this;
            }
            /**
             * Sets the value of Filter
             * @param value `CfnBucket.TopicConfigurationProperty.Filter`.
             * @return {@code this}
             */
            public Builder withFilter(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.NotificationFilterProperty value) {
                this._filter = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TopicConfigurationProperty build() {
                return new TopicConfigurationProperty() {
                    private final java.lang.String $event = java.util.Objects.requireNonNull(_event, "event is required");
                    private final java.lang.String $topic = java.util.Objects.requireNonNull(_topic, "topic is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $filter = _filter;

                    @Override
                    public java.lang.String getEvent() {
                        return this.$event;
                    }

                    @Override
                    public java.lang.String getTopic() {
                        return this.$topic;
                    }

                    @Override
                    public java.lang.Object getFilter() {
                        return this.$filter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("event", om.valueToTree(this.getEvent()));
                        obj.set("topic", om.valueToTree(this.getTopic()));
                        obj.set("filter", om.valueToTree(this.getFilter()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TopicConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.TopicConfigurationProperty.Event`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
             */
            @Override
            public java.lang.String getEvent() {
                return this.jsiiGet("event", java.lang.String.class);
            }

            /**
             * `CfnBucket.TopicConfigurationProperty.Topic`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
             */
            @Override
            public java.lang.String getTopic() {
                return this.jsiiGet("topic", java.lang.String.class);
            }

            /**
             * `CfnBucket.TopicConfigurationProperty.Filter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFilter() {
                return this.jsiiGet("filter", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    public static interface TransitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.TransitionProperty.StorageClass`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        java.lang.String getStorageClass();
        /**
         * `CfnBucket.TransitionProperty.TransitionDate`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        java.lang.Object getTransitionDate();
        /**
         * `CfnBucket.TransitionProperty.TransitionInDays`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        java.lang.Object getTransitionInDays();

        /**
         * @return a {@link Builder} of {@link TransitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TransitionProperty}
         */
        final class Builder {
            private java.lang.String _storageClass;
            @javax.annotation.Nullable
            private java.lang.Object _transitionDate;
            @javax.annotation.Nullable
            private java.lang.Object _transitionInDays;

            /**
             * Sets the value of StorageClass
             * @param value `CfnBucket.TransitionProperty.StorageClass`.
             * @return {@code this}
             */
            public Builder withStorageClass(final java.lang.String value) {
                this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            public Builder withTransitionDate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionDate
             * @param value `CfnBucket.TransitionProperty.TransitionDate`.
             * @return {@code this}
             */
            public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
                this._transitionDate = value;
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value `CfnBucket.TransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            public Builder withTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._transitionInDays = value;
                return this;
            }
            /**
             * Sets the value of TransitionInDays
             * @param value `CfnBucket.TransitionProperty.TransitionInDays`.
             * @return {@code this}
             */
            public Builder withTransitionInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._transitionInDays = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TransitionProperty build() {
                return new TransitionProperty() {
                    private final java.lang.String $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $transitionDate = _transitionDate;
                    @javax.annotation.Nullable
                    private final java.lang.Object $transitionInDays = _transitionInDays;

                    @Override
                    public java.lang.String getStorageClass() {
                        return this.$storageClass;
                    }

                    @Override
                    public java.lang.Object getTransitionDate() {
                        return this.$transitionDate;
                    }

                    @Override
                    public java.lang.Object getTransitionInDays() {
                        return this.$transitionInDays;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                        obj.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                        obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.TransitionProperty.StorageClass`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
             */
            @Override
            public java.lang.String getStorageClass() {
                return this.jsiiGet("storageClass", java.lang.String.class);
            }

            /**
             * `CfnBucket.TransitionProperty.TransitionDate`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitionDate() {
                return this.jsiiGet("transitionDate", java.lang.Object.class);
            }

            /**
             * `CfnBucket.TransitionProperty.TransitionInDays`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTransitionInDays() {
                return this.jsiiGet("transitionInDays", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    public static interface VersioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.VersioningConfigurationProperty.Status`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link VersioningConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VersioningConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _status;

            /**
             * Sets the value of Status
             * @param value `CfnBucket.VersioningConfigurationProperty.Status`.
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VersioningConfigurationProperty build() {
                return new VersioningConfigurationProperty() {
                    private final java.lang.String $status = java.util.Objects.requireNonNull(_status, "status is required");

                    @Override
                    public java.lang.String getStatus() {
                        return this.$status;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("status", om.valueToTree(this.getStatus()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.VersioningConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.VersioningConfigurationProperty.Status`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
             */
            @Override
            public java.lang.String getStatus() {
                return this.jsiiGet("status", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    public static interface WebsiteConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        java.lang.String getErrorDocument();
        /**
         * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        java.lang.String getIndexDocument();
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        java.lang.Object getRedirectAllRequestsTo();
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        java.lang.Object getRoutingRules();

        /**
         * @return a {@link Builder} of {@link WebsiteConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link WebsiteConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _errorDocument;
            @javax.annotation.Nullable
            private java.lang.String _indexDocument;
            @javax.annotation.Nullable
            private java.lang.Object _redirectAllRequestsTo;
            @javax.annotation.Nullable
            private java.lang.Object _routingRules;

            /**
             * Sets the value of ErrorDocument
             * @param value `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
             * @return {@code this}
             */
            public Builder withErrorDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._errorDocument = value;
                return this;
            }
            /**
             * Sets the value of IndexDocument
             * @param value `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
             * @return {@code this}
             */
            public Builder withIndexDocument(@javax.annotation.Nullable final java.lang.String value) {
                this._indexDocument = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RedirectAllRequestsTo
             * @param value `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * @return {@code this}
             */
            public Builder withRedirectAllRequestsTo(@javax.annotation.Nullable final software.amazon.awscdk.services.s3.CfnBucket.RedirectAllRequestsToProperty value) {
                this._redirectAllRequestsTo = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            public Builder withRoutingRules(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._routingRules = value;
                return this;
            }
            /**
             * Sets the value of RoutingRules
             * @param value `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * @return {@code this}
             */
            public Builder withRoutingRules(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._routingRules = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebsiteConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public WebsiteConfigurationProperty build() {
                return new WebsiteConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $errorDocument = _errorDocument;
                    @javax.annotation.Nullable
                    private final java.lang.String $indexDocument = _indexDocument;
                    @javax.annotation.Nullable
                    private final java.lang.Object $redirectAllRequestsTo = _redirectAllRequestsTo;
                    @javax.annotation.Nullable
                    private final java.lang.Object $routingRules = _routingRules;

                    @Override
                    public java.lang.String getErrorDocument() {
                        return this.$errorDocument;
                    }

                    @Override
                    public java.lang.String getIndexDocument() {
                        return this.$indexDocument;
                    }

                    @Override
                    public java.lang.Object getRedirectAllRequestsTo() {
                        return this.$redirectAllRequestsTo;
                    }

                    @Override
                    public java.lang.Object getRoutingRules() {
                        return this.$routingRules;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("errorDocument", om.valueToTree(this.getErrorDocument()));
                        obj.set("indexDocument", om.valueToTree(this.getIndexDocument()));
                        obj.set("redirectAllRequestsTo", om.valueToTree(this.getRedirectAllRequestsTo()));
                        obj.set("routingRules", om.valueToTree(this.getRoutingRules()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.CfnBucket.WebsiteConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getErrorDocument() {
                return this.jsiiGet("errorDocument", java.lang.String.class);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getIndexDocument() {
                return this.jsiiGet("indexDocument", java.lang.String.class);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRedirectAllRequestsTo() {
                return this.jsiiGet("redirectAllRequestsTo", java.lang.Object.class);
            }

            /**
             * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRoutingRules() {
                return this.jsiiGet("routingRules", java.lang.Object.class);
            }
        }
    }
}
