package software.amazon.awscdk.services.s3;

/**
 * Notification event types.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:00.713Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3.$Module.class, fqn = "@aws-cdk/aws-s3.EventType")
public enum EventType {
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * 
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    ObjectCreated,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * 
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    ObjectCreatedPut,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * 
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    ObjectCreatedPost,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * 
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    ObjectCreatedCopy,
    /**
     * Amazon S3 APIs such as PUT, POST, and COPY can create an object.
     * 
     * Using
     * these event types, you can enable notification when an object is created
     * using a specific API, or you can use the s3:ObjectCreated:* event type to
     * request notification regardless of the API that was used to create an
     * object.
     */
    ObjectCreatedCompleteMultipartUpload,
    /**
     * By using the ObjectRemoved event types, you can enable notification when an object or a batch of objects is removed from a bucket.
     * 
     * You can request notification when an object is deleted or a versioned
     * object is permanently deleted by using the s3:ObjectRemoved:Delete event
     * type. Or you can request notification when a delete marker is created for
     * a versioned object by using s3:ObjectRemoved:DeleteMarkerCreated. For
     * information about deleting versioned objects, see Deleting Object
     * Versions. You can also use a wildcard s3:ObjectRemoved:* to request
     * notification anytime an object is deleted.
     * 
     * You will not receive event notifications from automatic deletes from
     * lifecycle policies or from failed operations.
     */
    ObjectRemoved,
    /**
     * By using the ObjectRemoved event types, you can enable notification when an object or a batch of objects is removed from a bucket.
     * 
     * You can request notification when an object is deleted or a versioned
     * object is permanently deleted by using the s3:ObjectRemoved:Delete event
     * type. Or you can request notification when a delete marker is created for
     * a versioned object by using s3:ObjectRemoved:DeleteMarkerCreated. For
     * information about deleting versioned objects, see Deleting Object
     * Versions. You can also use a wildcard s3:ObjectRemoved:* to request
     * notification anytime an object is deleted.
     * 
     * You will not receive event notifications from automatic deletes from
     * lifecycle policies or from failed operations.
     */
    ObjectRemovedDelete,
    /**
     * By using the ObjectRemoved event types, you can enable notification when an object or a batch of objects is removed from a bucket.
     * 
     * You can request notification when an object is deleted or a versioned
     * object is permanently deleted by using the s3:ObjectRemoved:Delete event
     * type. Or you can request notification when a delete marker is created for
     * a versioned object by using s3:ObjectRemoved:DeleteMarkerCreated. For
     * information about deleting versioned objects, see Deleting Object
     * Versions. You can also use a wildcard s3:ObjectRemoved:* to request
     * notification anytime an object is deleted.
     * 
     * You will not receive event notifications from automatic deletes from
     * lifecycle policies or from failed operations.
     */
    ObjectRemovedDeleteMarkerCreated,
    /**
     * You can use this event type to request Amazon S3 to send a notification message when Amazon S3 detects that an object of the RRS storage class is lost.
     */
    ReducedRedundancyLostObject,
}
