/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.s3.StorageClass;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface Transition
extends JsiiSerializable {
    public StorageClass getStorageClass();

    public Instant getTransitionDate();

    public Number getTransitionInDays();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StorageClass _storageClass;
        @Nullable
        private Instant _transitionDate;
        @Nullable
        private Number _transitionInDays;

        public Builder withStorageClass(StorageClass value) {
            this._storageClass = Objects.requireNonNull(value, "storageClass is required");
            return this;
        }

        public Builder withTransitionDate(@Nullable Instant value) {
            this._transitionDate = value;
            return this;
        }

        public Builder withTransitionInDays(@Nullable Number value) {
            this._transitionInDays = value;
            return this;
        }

        public Transition build() {
            return new Transition(){
                private final StorageClass $storageClass;
                @Nullable
                private final Instant $transitionDate;
                @Nullable
                private final Number $transitionInDays;
                {
                    this.$storageClass = Objects.requireNonNull(_storageClass, "storageClass is required");
                    this.$transitionDate = _transitionDate;
                    this.$transitionInDays = _transitionInDays;
                }

                @Override
                public StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public Instant getTransitionDate() {
                    return this.$transitionDate;
                }

                @Override
                public Number getTransitionInDays() {
                    return this.$transitionInDays;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("storageClass", om.valueToTree((Object)this.getStorageClass()));
                    obj.set("transitionDate", om.valueToTree((Object)this.getTransitionDate()));
                    obj.set("transitionInDays", om.valueToTree((Object)this.getTransitionInDays()));
                    return obj;
                }
            };
        }
    }
}

