package software.amazon.awscdk.services.s3;

/**
 * An interface that represents the coordinates of a specific object in an S3 Bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:52:33.394Z")
public interface Coordinates extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the S3 Bucket the object is in.
     */
    java.lang.String getBucketName();
    /**
     * The path inside the Bucket where the object is located at.
     */
    java.lang.String getObjectKey();

    /**
     * @return a {@link Builder} of {@link Coordinates}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Coordinates}
     */
    final class Builder {
        private java.lang.String _bucketName;
        private java.lang.String _objectKey;

        /**
         * Sets the value of BucketName
         * @param value The name of the S3 Bucket the object is in.
         * @return {@code this}
         */
        public Builder withBucketName(final java.lang.String value) {
            this._bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
            return this;
        }
        /**
         * Sets the value of ObjectKey
         * @param value The path inside the Bucket where the object is located at.
         * @return {@code this}
         */
        public Builder withObjectKey(final java.lang.String value) {
            this._objectKey = java.util.Objects.requireNonNull(value, "objectKey is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Coordinates}
         * @throws NullPointerException if any required attribute was not provided
         */
        public Coordinates build() {
            return new Coordinates() {
                private final java.lang.String $bucketName = java.util.Objects.requireNonNull(_bucketName, "bucketName is required");
                private final java.lang.String $objectKey = java.util.Objects.requireNonNull(_objectKey, "objectKey is required");

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public java.lang.String getObjectKey() {
                    return this.$objectKey;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("bucketName", om.valueToTree(this.getBucketName()));
                    obj.set("objectKey", om.valueToTree(this.getObjectKey()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.Coordinates {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the S3 Bucket the object is in.
         */
        @Override
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The path inside the Bucket where the object is located at.
         */
        @Override
        public java.lang.String getObjectKey() {
            return this.jsiiGet("objectKey", java.lang.String.class);
        }
    }
}
