package software.amazon.awscdk.services.s3;

/**
 * Represents the properties of a notification destination.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:05:54.333Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BucketNotificationDestinationConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the destination (i.e. Lambda, SNS, SQS).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getArn();
    /**
     * The notification type.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.s3.BucketNotificationDestinationType getType();
    /**
     * Any additional dependencies that should be resolved before the bucket notification can be configured (for example, the SNS Topic Policy resource).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.IDependable> getDependencies();

    /**
     * @return a {@link Builder} of {@link BucketNotificationDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BucketNotificationDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _arn;
        private software.amazon.awscdk.services.s3.BucketNotificationDestinationType _type;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.IDependable> _dependencies;

        /**
         * Sets the value of Arn
         * @param value The ARN of the destination (i.e. Lambda, SNS, SQS).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withArn(final java.lang.String value) {
            this._arn = java.util.Objects.requireNonNull(value, "arn is required");
            return this;
        }
        /**
         * Sets the value of Type
         * @param value The notification type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withType(final software.amazon.awscdk.services.s3.BucketNotificationDestinationType value) {
            this._type = java.util.Objects.requireNonNull(value, "type is required");
            return this;
        }
        /**
         * Sets the value of Dependencies
         * @param value Any additional dependencies that should be resolved before the bucket notification can be configured (for example, the SNS Topic Policy resource).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDependencies(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.IDependable> value) {
            this._dependencies = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketNotificationDestinationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public BucketNotificationDestinationConfig build() {
            return new BucketNotificationDestinationConfig() {
                private final java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");
                private final software.amazon.awscdk.services.s3.BucketNotificationDestinationType $type = java.util.Objects.requireNonNull(_type, "type is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.IDependable> $dependencies = _dependencies;

                @Override
                public java.lang.String getArn() {
                    return this.$arn;
                }

                @Override
                public software.amazon.awscdk.services.s3.BucketNotificationDestinationType getType() {
                    return this.$type;
                }

                @Override
                public java.util.List<software.amazon.awscdk.IDependable> getDependencies() {
                    return this.$dependencies;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("arn", om.valueToTree(this.getArn()));
                    obj.set("type", om.valueToTree(this.getType()));
                    if (this.getDependencies() != null) {
                        obj.set("dependencies", om.valueToTree(this.getDependencies()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.BucketNotificationDestinationConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the destination (i.e. Lambda, SNS, SQS).
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getArn() {
            return this.jsiiGet("arn", java.lang.String.class);
        }

        /**
         * The notification type.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.s3.BucketNotificationDestinationType getType() {
            return this.jsiiGet("type", software.amazon.awscdk.services.s3.BucketNotificationDestinationType.class);
        }

        /**
         * Any additional dependencies that should be resolved before the bucket notification can be configured (for example, the SNS Topic Policy resource).
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.IDependable> getDependencies() {
            return this.jsiiGet("dependencies", java.util.List.class);
        }
    }
}
