package software.amazon.awscdk.services.s3;

/**
 * An interface that represents the coordinates of a specific object in an S3 Bucket.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:05:54.365Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Coordinates extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the S3 Bucket the object is in.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getBucketName();
    /**
     * The path inside the Bucket where the object is located at.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getObjectKey();

    /**
     * @return a {@link Builder} of {@link Coordinates}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Coordinates}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _bucketName;
        private java.lang.String _objectKey;

        /**
         * Sets the value of BucketName
         * @param value The name of the S3 Bucket the object is in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withBucketName(final java.lang.String value) {
            this._bucketName = java.util.Objects.requireNonNull(value, "bucketName is required");
            return this;
        }
        /**
         * Sets the value of ObjectKey
         * @param value The path inside the Bucket where the object is located at.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withObjectKey(final java.lang.String value) {
            this._objectKey = java.util.Objects.requireNonNull(value, "objectKey is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Coordinates}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Coordinates build() {
            return new Coordinates() {
                private final java.lang.String $bucketName = java.util.Objects.requireNonNull(_bucketName, "bucketName is required");
                private final java.lang.String $objectKey = java.util.Objects.requireNonNull(_objectKey, "objectKey is required");

                @Override
                public java.lang.String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public java.lang.String getObjectKey() {
                    return this.$objectKey;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("bucketName", om.valueToTree(this.getBucketName()));
                    obj.set("objectKey", om.valueToTree(this.getObjectKey()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.Coordinates {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the S3 Bucket the object is in.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getBucketName() {
            return this.jsiiGet("bucketName", java.lang.String.class);
        }

        /**
         * The path inside the Bucket where the object is located at.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getObjectKey() {
            return this.jsiiGet("objectKey", java.lang.String.class);
        }
    }
}
