package software.amazon.awscdk.services.s3;

/**
 * Describes when an object transitions to a specified storage class.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:05:54.369Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Transition extends software.amazon.jsii.JsiiSerializable {
    /**
     * The storage class to which you want the object to transition.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.s3.StorageClass getStorageClass();
    /**
     * Indicates when objects are transitioned to the specified storage class.
     * 
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     * 
     * Default: No transition date.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.time.Instant getTransitionDate();
    /**
     * Indicates the number of days after creation when objects are transitioned to the specified storage class.
     * 
     * Default: No transition count.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getTransitionInDays();

    /**
     * @return a {@link Builder} of {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Transition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.s3.StorageClass _storageClass;
        @javax.annotation.Nullable
        private java.time.Instant _transitionDate;
        @javax.annotation.Nullable
        private java.lang.Number _transitionInDays;

        /**
         * Sets the value of StorageClass
         * @param value The storage class to which you want the object to transition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withStorageClass(final software.amazon.awscdk.services.s3.StorageClass value) {
            this._storageClass = java.util.Objects.requireNonNull(value, "storageClass is required");
            return this;
        }
        /**
         * Sets the value of TransitionDate
         * @param value Indicates when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTransitionDate(@javax.annotation.Nullable final java.time.Instant value) {
            this._transitionDate = value;
            return this;
        }
        /**
         * Sets the value of TransitionInDays
         * @param value Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTransitionInDays(@javax.annotation.Nullable final java.lang.Number value) {
            this._transitionInDays = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Transition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Transition build() {
            return new Transition() {
                private final software.amazon.awscdk.services.s3.StorageClass $storageClass = java.util.Objects.requireNonNull(_storageClass, "storageClass is required");
                @javax.annotation.Nullable
                private final java.time.Instant $transitionDate = _transitionDate;
                @javax.annotation.Nullable
                private final java.lang.Number $transitionInDays = _transitionInDays;

                @Override
                public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
                    return this.$storageClass;
                }

                @Override
                public java.time.Instant getTransitionDate() {
                    return this.$transitionDate;
                }

                @Override
                public java.lang.Number getTransitionInDays() {
                    return this.$transitionInDays;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("storageClass", om.valueToTree(this.getStorageClass()));
                    if (this.getTransitionDate() != null) {
                        obj.set("transitionDate", om.valueToTree(this.getTransitionDate()));
                    }
                    if (this.getTransitionInDays() != null) {
                        obj.set("transitionInDays", om.valueToTree(this.getTransitionInDays()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.Transition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The storage class to which you want the object to transition.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.s3.StorageClass getStorageClass() {
            return this.jsiiGet("storageClass", software.amazon.awscdk.services.s3.StorageClass.class);
        }

        /**
         * Indicates when objects are transitioned to the specified storage class.
         * 
         * The date value must be in ISO 8601 format. The time is always midnight UTC.
         * 
         * Default: No transition date.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.time.Instant getTransitionDate() {
            return this.jsiiGet("transitionDate", java.time.Instant.class);
        }

        /**
         * Indicates the number of days after creation when objects are transitioned to the specified storage class.
         * 
         * Default: No transition count.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getTransitionInDays() {
            return this.jsiiGet("transitionInDays", java.lang.Number.class);
        }
    }
}
